/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.WsaClientPipe;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.TransportPipeFactory;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.handler.ClientLogicalHandlerPipe;
import com.sun.xml.ws.handler.ClientSOAPHandlerPipe;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.protocol.soap.ClientMUPipe;
import com.sun.xml.ws.transport.DeferredTransportPipe;
import com.sun.xml.ws.util.pipe.DumpPipe;
import javax.xml.ws.soap.SOAPBinding;

public final class ClientPipeAssemblerContext {
    @NotNull
    private final EndpointAddress address;
    @NotNull
    private final WSDLPort wsdlModel;
    @NotNull
    private final WSService rootOwner;
    @NotNull
    private final WSBinding binding;
    @NotNull
    private final Container container;

    public ClientPipeAssemblerContext(@NotNull EndpointAddress address, @NotNull WSDLPort wsdlModel, @NotNull WSService rootOwner, @NotNull WSBinding binding) {
        this(address, wsdlModel, rootOwner, binding, Container.NONE);
    }

    public ClientPipeAssemblerContext(@NotNull EndpointAddress address, @NotNull WSDLPort wsdlModel, @NotNull WSService rootOwner, @NotNull WSBinding binding, @NotNull Container container) {
        this.address = address;
        this.wsdlModel = wsdlModel;
        this.rootOwner = rootOwner;
        this.binding = binding;
        this.container = container;
    }

    @NotNull
    public EndpointAddress getAddress() {
        return this.address;
    }

    @Nullable
    public WSDLPort getWsdlModel() {
        return this.wsdlModel;
    }

    @NotNull
    public WSService getService() {
        return this.rootOwner;
    }

    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    public Container getContainer() {
        return this.container;
    }

    public Pipe createDumpPipe(Pipe next) {
        return new DumpPipe("dump", System.out, next);
    }

    public Pipe createClientMUPipe(Pipe next) {
        if (this.binding instanceof SOAPBinding) {
            return new ClientMUPipe(this.binding, next);
        }
        return next;
    }

    public Pipe createHandlerPipe(Pipe next) {
        ClientSOAPHandlerPipe soapHandlerPipe = null;
        if (this.binding instanceof SOAPBinding) {
            soapHandlerPipe = new ClientSOAPHandlerPipe(this.binding, this.wsdlModel, next);
            next = soapHandlerPipe;
        }
        return new ClientLogicalHandlerPipe(this.binding, next, soapHandlerPipe);
    }

    public Pipe createWsaPipe(Pipe next) {
        if (this.wsdlModel == null) {
            if (this.binding.hasFeature("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
                return new WsaClientPipe(this.wsdlModel, this.binding, next);
            }
            return next;
        }
        WSDLPortImpl impl = (WSDLPortImpl)this.wsdlModel;
        if (impl.isAddressingEnabled()) {
            return new WsaClientPipe(this.wsdlModel, this.binding, next);
        }
        return next;
    }

    public Pipe createTransportPipe() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (this.address.toString().equals("") || this.address.toString().equals("REPLACE_WITH_ACTUAL_URL")) {
            return new DeferredTransportPipe(cl, this);
        }
        return TransportPipeFactory.create(cl, this);
    }
}

