/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.util.DistributedPropertySet;
import com.sun.xml.ws.util.PropertySet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.BindingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Packet
extends DistributedPropertySet {
    private Message message;
    public boolean wasTransportSecure;
    @PropertySet.Property(value="com.sun.xml.ws.handler.config")
    public HandlerConfiguration handlerConfig;
    @PropertySet.Property(value="com.sun.xml.ws.client.handle")
    public BindingProvider proxy;
    public EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation;
    public String acceptableMimeTypes;
    public WebServiceContextDelegate webServiceContextDelegate;
    public TransportBackChannel transportBackChannel;
    public WSEndpoint endpoint;
    @PropertySet.Property(value="SOAPAction")
    public String soapAction;
    @PropertySet.Property(value="com.sun.xml.ws.server.OneWayOperation")
    public Boolean expectReply;
    @Deprecated
    public Boolean isOneWay;
    private Set<String> handlerScopePropertyNames;
    public final Map<String, Object> invocationProperties;
    private static final PropertySet.PropertyMap model = Packet.parse(Packet.class);

    public Packet(Message request) {
        this();
        this.message = request;
    }

    public Packet() {
        this.invocationProperties = new HashMap<String, Object>();
    }

    private Packet(Packet that) {
        that.copySatelliteInto(this);
        this.invocationProperties = that.invocationProperties;
        this.handlerScopePropertyNames = that.handlerScopePropertyNames;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    @PropertySet.Property(value="javax.xml.ws.service.endpoint.address")
    public String getEndPointAddressString() {
        if (this.endpointAddress == null) {
            return null;
        }
        return this.endpointAddress.toString();
    }

    public void setEndPointAddressString(String s) {
        this.endpointAddress = s == null ? null : EndpointAddress.create(s);
    }

    @PropertySet.Property(value="com.sun.xml.ws.client.ContentNegotiation")
    public String getContentNegotiationString() {
        return this.contentNegotiation != null ? this.contentNegotiation.toString() : null;
    }

    public void setContentNegotiationString(String s) {
        if (s == null) {
            this.contentNegotiation = null;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    public final Set<String> getHandlerScopePropertyNames(boolean readOnly) {
        Set<String> o = this.handlerScopePropertyNames;
        if (o == null) {
            if (readOnly) {
                return Collections.emptySet();
            }
            this.handlerScopePropertyNames = o = new HashSet<String>();
        }
        return o;
    }

    public final Set<String> getApplicationScopePropertyNames(boolean readOnly) {
        assert (false);
        return new HashSet<String>();
    }

    @Deprecated
    public Packet createResponse(Message msg) {
        Packet response = new Packet(this);
        response.setMessage(msg);
        return response;
    }

    public Packet createClientResponse(Message msg) {
        Packet response = new Packet(this);
        response.setMessage(msg);
        return response;
    }

    public Packet createServerResponse(Message msg, String action, WSBinding binding) {
        Packet r = this.createClientResponse(msg);
        return r;
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

