/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.v2.runtime.MarshallerImpl;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.encoding.StreamSOAPCodec;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.message.AttachmentSetImpl;
import com.sun.xml.ws.message.DOMMessage;
import com.sun.xml.ws.message.EmptyMessageImpl;
import com.sun.xml.ws.message.jaxb.JAXBMessage;
import com.sun.xml.ws.message.saaj.SAAJMessage;
import com.sun.xml.ws.message.source.PayloadSourceMessage;
import com.sun.xml.ws.message.source.ProtocolSourceMessage;
import com.sun.xml.ws.streaming.XMLStreamReaderException;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.DOMUtil;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Messages {
    private Messages() {
    }

    public static Message create(JAXBRIContext context, Object jaxbObject, SOAPVersion soapVersion) {
        return new JAXBMessage(context, jaxbObject, soapVersion);
    }

    public static Message create(Marshaller marshaller, Object jaxbObject, SOAPVersion soapVersion) {
        return new JAXBMessage((JAXBRIContext)((MarshallerImpl)marshaller).getContext(), jaxbObject, soapVersion);
    }

    public static Message create(SOAPMessage saaj) {
        return new SAAJMessage(saaj);
    }

    public static Message createUsingPayload(Source payload, SOAPVersion ver) {
        return new PayloadSourceMessage(payload, ver);
    }

    public static Message createUsingPayload(Element payload, SOAPVersion ver) {
        return new DOMMessage(ver, payload);
    }

    public static Message create(Element soapEnvelope) {
        Element body;
        SOAPVersion ver = SOAPVersion.fromNsUri(soapEnvelope.getNamespaceURI());
        Element header = DOMUtil.getFirstChild(soapEnvelope, ver.nsUri, "Header");
        HeaderList headers = null;
        if (header != null) {
            for (Node n = header.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                if (headers == null) {
                    headers = new HeaderList();
                }
                headers.add(Headers.create(ver, (Element)n));
            }
        }
        if ((body = DOMUtil.getFirstChild(soapEnvelope, ver.nsUri, "Body")) == null) {
            throw new WebServiceException("Message doesn't have <S:Body> " + soapEnvelope);
        }
        Element payload = DOMUtil.getFirstChild(soapEnvelope, ver.nsUri, "Body");
        if (payload == null) {
            return new EmptyMessageImpl(headers, new AttachmentSetImpl(), ver);
        }
        return new DOMMessage(ver, headers, payload);
    }

    public static Message create(Source envelope, SOAPVersion soapVersion) {
        return new ProtocolSourceMessage(envelope, soapVersion);
    }

    public static Message createEmpty(SOAPVersion soapVersion) {
        return new EmptyMessageImpl(soapVersion);
    }

    @NotNull
    public static Message create(@NotNull XMLStreamReader reader) {
        if (reader.getEventType() != 1) {
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        assert (reader.getEventType() == 1) : reader.getEventType();
        SOAPVersion ver = SOAPVersion.fromNsUri(reader.getNamespaceURI());
        return StreamSOAPCodec.create(ver).decode(reader);
    }

    @NotNull
    public static Message create(@NotNull XMLStreamBuffer xsb) {
        try {
            return Messages.create((XMLStreamReader)xsb.readAsXMLStreamReader());
        }
        catch (XMLStreamException e) {
            throw new XMLStreamReaderException(e);
        }
    }

    public static Message create(Throwable t, SOAPVersion soapVersion) {
        return SOAPFaultBuilder.createSOAPFaultMessage(soapVersion, null, t);
    }

    public static Message create(SOAPFault fault) {
        SOAPVersion ver = SOAPVersion.fromNsUri(fault.getNamespaceURI());
        return new DOMMessage(ver, (Element)fault);
    }

    @NotNull
    public static Message create(@NotNull SOAPVersion soapVersion, @NotNull ProtocolException pex, @Nullable QName faultcode) {
        return SOAPFaultBuilder.createSOAPFaultMessage(soapVersion, pex, faultcode);
    }
}

