/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.addressing;

import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AddressingVersion {
    W3C("http://www.w3.org/2005/08/addressing", "w3c-anonymous-epr.xml"){

        public boolean isReferenceParameter(String localName) {
            return localName.equals("ReferenceParameters");
        }
    }
    ,
    MEMBER("http://schemas.xmlsoap.org/ws/2004/08/addressing", "member-anonymous-epr.xml"){

        public boolean isReferenceParameter(String localName) {
            return localName.equals("ReferenceParameters") || localName.equals("ReferenceProperties");
        }
    };

    public final String nsUri;
    public final WSEndpointReference anonymousEpr;
    public final QName toTag;
    public final QName fromTag;
    public final QName replyToTag;
    public final QName faultToTag;
    public final QName actionTag;
    public final QName messageIDTag;
    public final QName fault_missingAddressInEpr;
    private static final String EXTENDED_FAULT_NAMESPACE = "http://jax-ws.dev.java.net/addressing/fault";
    public static final QName fault_duplicateAddressInEpr;

    private AddressingVersion(String nsUri, String anonymousEprResrouceName) {
        this.nsUri = nsUri;
        this.toTag = new QName(nsUri, "To");
        this.fromTag = new QName(nsUri, "From");
        this.replyToTag = new QName(nsUri, "ReplyTo");
        this.faultToTag = new QName(nsUri, "FaultTo");
        this.actionTag = new QName(nsUri, "Action");
        this.messageIDTag = new QName(nsUri, "MessageID");
        this.fault_missingAddressInEpr = new QName(nsUri, "MissingAddressInEPR", "wsa");
        try {
            this.anonymousEpr = new WSEndpointReference(((Object)((Object)this)).getClass().getResourceAsStream(anonymousEprResrouceName), this);
        }
        catch (XMLStreamException e) {
            throw new Error(e);
        }
        catch (XMLStreamBufferException e) {
            throw new Error(e);
        }
    }

    public static AddressingVersion fromNsUri(String nsUri) {
        if (nsUri.equals(AddressingVersion.W3C.nsUri)) {
            return W3C;
        }
        if (nsUri.equals(AddressingVersion.MEMBER.nsUri)) {
            return MEMBER;
        }
        return null;
    }

    public static AddressingVersion fromBinding(WSBinding binding) {
        if (binding.hasFeature("http://www.w3.org/2005/08/addressing/module")) {
            return W3C;
        }
        if (binding.hasFeature("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
            return MEMBER;
        }
        return null;
    }

    public static AddressingVersion fromPort(WSDLPort port) {
        String ns = port.getBinding().getAddressingVersion();
        if (ns.equals(AddressingVersion.W3C.nsUri)) {
            return W3C;
        }
        if (ns.equals(AddressingVersion.MEMBER.nsUri)) {
            return MEMBER;
        }
        return null;
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public abstract boolean isReferenceParameter(String var1);

    static {
        fault_duplicateAddressInEpr = new QName(EXTENDED_FAULT_NAMESPACE, "DuplicateAddressInEpr");
    }
}

