/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.xml.ws.addressing.EndpointReferenceImpl;
import com.sun.xml.ws.addressing.ProblemAction;
import com.sun.xml.ws.addressing.ProblemHeaderQName;
import com.sun.xml.ws.addressing.RelationshipImpl;
import com.sun.xml.ws.addressing.W3CAddressingConstants;
import com.sun.xml.ws.addressing.WsaPipeHelper;
import com.sun.xml.ws.addressing.model.AddressingProperties;
import com.sun.xml.ws.addressing.model.Elements;
import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.addressing.model.MapRequiredException;
import com.sun.xml.ws.addressing.model.Relationship;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.message.RelatesToHeader;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsaPipeHelperImpl
extends WsaPipeHelper {
    static final JAXBContext jc;

    public WsaPipeHelperImpl() {
        try {
            this.unmarshaller = jc.createUnmarshaller();
            this.marshaller = jc.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public WsaPipeHelperImpl(WSDLPort wsdlPort, WSBinding binding) {
        this();
        this.wsdlPort = wsdlPort;
        this.binding = binding;
    }

    public final void getProblemActionDetail(String action, Element element) {
        ProblemAction pa = new ProblemAction(action);
        try {
            this.marshaller.marshal((Object)pa, (Node)element);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public final void getInvalidMapDetail(QName name, Element element) {
        ProblemHeaderQName phq = new ProblemHeaderQName(name);
        try {
            this.marshaller.marshal((Object)phq, (Node)element);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public final void getMapRequiredDetail(QName name, Element element) {
        this.getInvalidMapDetail(name, element);
    }

    public final SOAPElement getSoap11FaultDetail() {
        try {
            if (this.binding == null) {
                return null;
            }
            return this.binding.getSOAPVersion().saajSoapFactory.createElement(new QName("http://www.w3.org/2005/08/addressing", "FaultDetail"));
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    protected final void checkAnonymousSemantics(WSDLBoundOperation wbo, AddressingProperties ap) {
        if (wbo == null) {
            return;
        }
        if (ap == null) {
            return;
        }
        WSDLBoundOperationImpl impl = (WSDLBoundOperationImpl)wbo;
        WSDLBoundOperationImpl.ANONYMOUS anon = impl.getAnonymous();
        String replyTo = null;
        String faultTo = null;
        if (ap.getReplyTo() != null) {
            replyTo = ((EndpointReferenceImpl)ap.getReplyTo()).getAddress();
        }
        if (ap.getFaultTo() != null) {
            faultTo = ((EndpointReferenceImpl)ap.getFaultTo()).getAddress();
        }
        if (anon != WSDLBoundOperationImpl.ANONYMOUS.optional) {
            if (anon == WSDLBoundOperationImpl.ANONYMOUS.required) {
                if (replyTo != null && !replyTo.equals(this.getAnonymousURI())) {
                    throw new InvalidMapException(this.getReplyToQName(), W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultTo != null && !faultTo.equals(this.getAnonymousURI())) {
                    throw new InvalidMapException(this.getFaultToQName(), W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
            } else if (anon == WSDLBoundOperationImpl.ANONYMOUS.prohibited) {
                if (replyTo != null && replyTo.equals(this.getAnonymousURI())) {
                    throw new InvalidMapException(this.getReplyToQName(), W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultTo != null && faultTo.equals(this.getAnonymousURI())) {
                    throw new InvalidMapException(this.getFaultToQName(), W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
            } else {
                throw new WebServiceException("Invalid value in TWsaWSDLBindingOperationExtension: \"" + (Object)((Object)anon) + "\"");
            }
        }
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2005/08/addressing";
    }

    public QName getMessageIDQName() {
        return W3CAddressingConstants.WSA_MESSAGEID_QNAME;
    }

    public QName getFromQName() {
        return W3CAddressingConstants.WSA_FROM_QNAME;
    }

    public QName getToQName() {
        return W3CAddressingConstants.WSA_TO_QNAME;
    }

    public QName getReplyToQName() {
        return W3CAddressingConstants.WSA_REPLYTO_QNAME;
    }

    public QName getFaultToQName() {
        return W3CAddressingConstants.WSA_FAULTTO_QNAME;
    }

    public QName getActionQName() {
        return W3CAddressingConstants.WSA_ACTION_QNAME;
    }

    public QName getRelatesToQName() {
        return W3CAddressingConstants.WSA_RELATESTO_QNAME;
    }

    public QName getRelationshipTypeQName() {
        return W3CAddressingConstants.WSA_RELATIONSHIPTYPE_QNAME;
    }

    public String getDefaultFaultAction() {
        return "http://www.w3.org/2005/08/addressing/fault";
    }

    public QName getIsReferenceParameterQName() {
        return W3CAddressingConstants.WSA_REFERENCEPARAMETERS_QNAME;
    }

    public QName getMapRequiredQName() {
        return W3CAddressingConstants.MAP_REQUIRED_QNAME;
    }

    public String getMapRequiredText() {
        return "A required header representing a Message Addressing Property is not present";
    }

    public QName getActionNotSupportedQName() {
        return W3CAddressingConstants.ACTION_NOT_SUPPORTED_QNAME;
    }

    public String getActionNotSupportedText() {
        return "The \"%s\" cannot be processed at the receiver";
    }

    public QName getFaultDetailQName() {
        return W3CAddressingConstants.FAULT_DETAIL_QNAME;
    }

    public QName getInvalidMapQName() {
        return W3CAddressingConstants.INVALID_MAP_QNAME;
    }

    public String getInvalidMapText() {
        return "A header representing a Message Addressing Property is not valid and the message cannot be processed";
    }

    public AddressingProperties toReply(AddressingProperties ap) {
        return this.toReplyOrFault(ap, false);
    }

    public AddressingProperties toFault(AddressingProperties ap) {
        return this.toReplyOrFault(ap, true);
    }

    public String getAnonymousURI() {
        return "http://www.w3.org/2005/08/addressing/anonymous";
    }

    public String getRelationshipType() {
        return "http://www.w3.org/2005/08/addressing/reply";
    }

    public void writeRelatesTo(AddressingProperties ap, HeaderList hl, SOAPVersion soapVersion) {
        if (ap.getRelatesTo() != null && ap.getRelatesTo().size() > 0) {
            for (Relationship rel : ap.getRelatesTo()) {
                hl.add(new RelatesToHeader(this.getRelatesToQName(), rel.getId(), rel.getType()));
            }
        }
    }

    public void writeRelatesTo(Relationship rel, HeaderList hl, SOAPVersion soapVersion) {
        RelationshipImpl reli = (RelationshipImpl)rel;
        hl.add(Headers.create(soapVersion, this.marshaller, this.getRelatesToQName(), (Object)reli));
    }

    public Relationship newRelationship(Relationship r) {
        return new RelationshipImpl(r.getId(), r.getType());
    }

    public Relationship newRelationship(String mid) {
        return new RelationshipImpl(mid);
    }

    public EndpointReference newEndpointReference() {
        return new EndpointReferenceImpl();
    }

    public QName getInvalidCardinalityQName() {
        return W3CAddressingConstants.INVALID_CARDINALITY;
    }

    public String getNoneURI() {
        return "http://www.w3.org/2005/08/addressing/none";
    }

    public String getAddress(EndpointReference epr) {
        if (epr == null) {
            return null;
        }
        return ((EndpointReferenceImpl)epr).getAddress();
    }

    private AddressingProperties toReplyOrFault(AddressingProperties source, boolean isFault) {
        if (source == null) {
            throw new WebServiceException("Source addressing properties is null.");
        }
        EndpointReference destination = isFault ? (source.getFaultTo() != null ? source.getFaultTo() : source.getReplyTo()) : source.getReplyTo();
        if (destination == null) {
            destination = new EndpointReferenceImpl();
        }
        AddressingProperties response = this.toDestination(destination);
        String uri = source.getMessageID();
        if (uri == null) {
            throw new MapRequiredException(W3CAddressingConstants.WSA_MESSAGEID_QNAME);
        }
        response.getRelatesTo().add(new RelationshipImpl(uri, "http://www.w3.org/2005/08/addressing/reply"));
        return response;
    }

    private AddressingProperties toDestination(EndpointReference source) {
        AddressingProperties props = new AddressingProperties();
        if (source == null) {
            throw new WebServiceException("Source addressing properties is null.");
        }
        String uri = ((EndpointReferenceImpl)source).getAddress();
        if (uri == null) {
            throw new InvalidMapException(W3CAddressingConstants.INVALID_MAP_QNAME, W3CAddressingConstants.MISSING_ADDRESS_IN_EPR);
        }
        props.setTo(uri);
        Elements params = ((EndpointReferenceImpl)source).getRefParams();
        if (params != null) {
            for (Element refp : params.getElements()) {
                this.addIsRefp(refp);
                props.getReferenceParameters().getElements().add(refp);
            }
        }
        return props;
    }

    void addIsRefp(Element refp) {
        refp.setAttributeNS("http://www.w3.org/2005/08/addressing", "wsa:" + W3CAddressingConstants.WSA_IS_REFERENCE_PARAMETER_QNAME.getLocalPart(), "true");
        refp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa", "http://www.w3.org/2005/08/addressing");
    }

    static {
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{EndpointReferenceImpl.class, ObjectFactory.class, RelationshipImpl.class, ProblemAction.class, ProblemHeaderQName.class});
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRegistry
    final class ObjectFactory {
        ObjectFactory() {
        }

        @XmlElementDecl(namespace="http://www.w3.org/2005/08/addressing", name="From")
        final JAXBElement<EndpointReferenceImpl> createFrom(EndpointReferenceImpl u) {
            return null;
        }

        @XmlElementDecl(namespace="http://www.w3.org/2005/08/addressing", name="Action")
        final JAXBElement<String> createAction(String u) {
            return null;
        }

        @XmlElementDecl(namespace="http://www.w3.org/2005/08/addressing", name="To")
        final JAXBElement<String> createTo(String u) {
            return null;
        }

        @XmlElementDecl(namespace="http://www.w3.org/2005/08/addressing", name="ReplyTo")
        final JAXBElement<EndpointReferenceImpl> createReplyTo(EndpointReferenceImpl u) {
            return null;
        }

        @XmlElementDecl(namespace="http://www.w3.org/2005/08/addressing", name="FaultTo")
        final JAXBElement<EndpointReferenceImpl> createFaultTo(EndpointReferenceImpl u) {
            return null;
        }

        @XmlElementDecl(namespace="http://www.w3.org/2005/08/addressing", name="MessageID")
        final JAXBElement<String> createMessageID(String u) {
            return null;
        }

        @XmlElementDecl(namespace="http://www.w3.org/2005/08/addressing", name="RelatesTo")
        final JAXBElement<RelationshipImpl> createRelationship(RelationshipImpl u) {
            return null;
        }
    }
}

