/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.xml.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.ws.addressing.model.AddressingProperties;
import com.sun.xml.ws.addressing.model.Elements;
import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.addressing.model.MapRequiredException;
import com.sun.xml.ws.addressing.model.Relationship;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.message.StringHeader;
import com.sun.xml.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WsaPipeHelper {
    protected static final DocumentBuilder db;
    protected Unmarshaller unmarshaller;
    protected Marshaller marshaller;
    protected WSDLPort wsdlPort;
    protected WSBinding binding;
    private WSDLBoundOperation wbo;
    private static final QName s11Role;
    private static final QName s12Role;

    public final Packet writeClientOutboundHeaders(Packet packet) {
        AddressingProperties ap = new AddressingProperties();
        EndpointAddress to = packet.endpointAddress;
        if (to == null) {
            to = EndpointAddress.create("http://null.ENDPOINT_ADDRESS_PROPERTY");
        }
        ap.setTo(to.toString());
        ap.setMessageID(packet.getMessage().getID(this.binding));
        if (this.wsdlPort != null && !packet.getMessage().isOneWay(this.wsdlPort)) {
            EndpointReference epr = this.newEndpointReference();
            ap.setReplyTo(epr);
        }
        String action = this.getInputAction(packet);
        if (this.isInputActionDefault(packet) && packet.soapAction != null && !packet.soapAction.equals("")) {
            action = packet.soapAction;
        }
        ap.setAction(action == null ? "http://fake.input.action" : action);
        packet.soapAction = ap.getAction();
        this.writeHeaders(packet, ap);
        return packet;
    }

    public final void writeHeaders(Packet packet, AddressingProperties ap) {
        Message message = packet.getMessage();
        HeaderList hl = message.getHeaders();
        SOAPVersion soapVersion = this.binding.getSOAPVersion();
        if (ap.getTo() != null && !ap.getTo().equals("")) {
            hl.add(new StringHeader(this.getToQName(), ap.getTo()));
        }
        if (ap.getMessageID() != null && !ap.getMessageID().equals("")) {
            hl.add(new StringHeader(this.getMessageIDQName(), ap.getMessageID()));
        }
        if (ap.getFrom() != null && !ap.getFrom().equals("")) {
            hl.add(Headers.create(soapVersion, this.marshaller, this.getFromQName(), (Object)ap.getFrom()));
        }
        if (ap.getReplyTo() != null && !ap.getReplyTo().equals("")) {
            hl.add(Headers.create(soapVersion, this.marshaller, this.getReplyToQName(), (Object)ap.getReplyTo()));
        }
        if (ap.getFaultTo() != null && !ap.getFaultTo().equals("")) {
            hl.add(Headers.create(soapVersion, this.marshaller, this.getFaultToQName(), (Object)ap.getFaultTo()));
        }
        if (ap.getAction() != null && !ap.getAction().equals("")) {
            hl.add(new StringHeader(this.getActionQName(), ap.getAction()));
            packet.soapAction = ap.getAction();
        }
        if (ap.getReferenceParameters() != null && !ap.getReferenceParameters().getElements().isEmpty()) {
            Elements refps = ap.getReferenceParameters();
            for (Element refp : refps.getElements()) {
                hl.add(Headers.create(refp));
            }
        }
        this.writeRelatesTo(ap, hl, soapVersion);
    }

    public final Packet readServerInboundHeaders(Packet packet) {
        SOAPFault soapFault;
        if (packet.invocationProperties.get("server.inbound") != null) {
            return this.prepareOutbound(packet, false);
        }
        if (this.wsdlPort != null) {
            this.wbo = packet.getMessage().getOperation(this.wsdlPort);
        }
        SOAPElement s11FaultDetail = this.getSoap11FaultDetail();
        StringBuffer mid = new StringBuffer();
        try {
            AddressingProperties inbound = this.readInboundHeaders(packet, mid);
            packet.invocationProperties.put("server.inbound", inbound);
            this.checkMandatoryHeaders(inbound);
            this.checkAnonymousSemantics(this.wbo, inbound);
            return this.prepareOutbound(packet, true);
        }
        catch (InvalidMapException e) {
            soapFault = this.newInvalidMapFault(e);
            this.getInvalidMapDetail(e.getMapQName(), (Element)s11FaultDetail);
        }
        catch (MapRequiredException e) {
            soapFault = this.newMapRequiredFault(e);
            this.getMapRequiredDetail(e.getMapQName(), (Element)s11FaultDetail);
        }
        catch (ActionNotSupportedException e) {
            soapFault = this.newActionNotSupportedFault(e.getAction());
            this.getProblemActionDetail(e.getAction(), (Element)s11FaultDetail);
        }
        if (soapFault != null) {
            Message m = Messages.create(soapFault);
            Header defaultFaultAction = Headers.create(this.binding.getSOAPVersion(), this.marshaller, this.getActionQName(), (Object)this.getDefaultFaultAction());
            Header actionHeader = m.getHeaders().get(this.getActionQName(), true);
            if (actionHeader == null) {
                m.getHeaders().add(defaultFaultAction);
            } else {
                m.getHeaders().remove(actionHeader);
                m.getHeaders().add(defaultFaultAction);
            }
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_11) {
                m.getHeaders().add(Headers.create((Element)s11FaultDetail));
            }
            if (mid != null) {
                Relationship rel = this.newRelationship(mid.toString());
                this.writeRelatesTo(rel, m.getHeaders(), this.binding.getSOAPVersion());
            }
            return packet.createResponse(m);
        }
        return packet;
    }

    private AddressingProperties readInboundHeaders(Packet packet, StringBuffer mid) {
        Message message = packet.getMessage();
        if (message == null) {
            return null;
        }
        if (message.getHeaders() == null) {
            return null;
        }
        AddressingProperties ap = new AddressingProperties();
        Iterator<Header> hIter = message.getHeaders().getHeaders(this.getNamespaceURI(), true);
        WSDLPortImpl impl = (WSDLPortImpl)this.wsdlPort;
        if (this.wsdlPort != null && !impl.isAddressingRequired() && !hIter.hasNext()) {
            return null;
        }
        try {
            Header midHeader = message.getHeaders().get(this.getMessageIDQName(), true);
            if (midHeader != null) {
                mid.append(midHeader.getStringContent());
            }
            QName faultyHeader = null;
            while (hIter.hasNext()) {
                Header h = hIter.next();
                if (!this.isInCurrentRole(h)) continue;
                String local = h.getLocalPart();
                if (local.equals(this.getFromQName().getLocalPart())) {
                    if (ap.getFrom() != null) {
                        faultyHeader = this.getFromQName();
                        break;
                    }
                    ap.setFrom((EndpointReference)((JAXBElement)h.readAsJAXB(this.unmarshaller)).getValue());
                    continue;
                }
                if (local.equals(this.getToQName().getLocalPart())) {
                    if (ap.getTo() != null) {
                        faultyHeader = this.getToQName();
                        break;
                    }
                    ap.setTo(h.getStringContent());
                    continue;
                }
                if (local.equals(this.getReplyToQName().getLocalPart())) {
                    if (ap.getReplyTo() != null) {
                        faultyHeader = this.getReplyToQName();
                        break;
                    }
                    ap.setReplyTo((EndpointReference)((JAXBElement)h.readAsJAXB(this.unmarshaller)).getValue());
                    continue;
                }
                if (local.equals(this.getFaultToQName().getLocalPart())) {
                    if (ap.getFaultTo() != null) {
                        faultyHeader = this.getFaultToQName();
                        break;
                    }
                    ap.setFaultTo((EndpointReference)((JAXBElement)h.readAsJAXB(this.unmarshaller)).getValue());
                    continue;
                }
                if (local.equals(this.getActionQName().getLocalPart())) {
                    if (ap.getAction() != null) {
                        faultyHeader = this.getActionQName();
                        break;
                    }
                    ap.setAction(h.getStringContent());
                    continue;
                }
                if (local.equals(this.getMessageIDQName().getLocalPart())) {
                    if (ap.getMessageID() != null) {
                        faultyHeader = this.getMessageIDQName();
                        break;
                    }
                    ap.setMessageID(h.getStringContent());
                    continue;
                }
                if (local.equals(this.getRelatesToQName().getLocalPart())) {
                    String mid2 = h.getStringContent();
                    Relationship rel = this.newRelationship(mid2);
                    ap.getRelatesTo().add(rel);
                    continue;
                }
                if (local.equals(this.getFaultDetailQName().getLocalPart())) continue;
                throw new WebServiceException("unknown WS-A header");
            }
            if (faultyHeader != null) {
                throw new InvalidMapException(faultyHeader, this.getInvalidCardinalityQName());
            }
            HeaderList hl = message.getHeaders();
            for (Header h : hl) {
                if (!this.isReferenceParameter(h)) continue;
                ap.getReferenceParameters().getElements().add(WsaPipeHelper.unmarshalRefp(h));
            }
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
        return ap;
    }

    private boolean isReferenceParameter(Header h) {
        String val = h.getAttribute(this.getIsReferenceParameterQName());
        return val != null && Boolean.valueOf(val) != false;
    }

    private boolean isInCurrentRole(Header header) {
        if (this.binding == null) {
            return true;
        }
        if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_11) {
            return true;
        }
        String role = header.getAttribute(s12Role);
        return role == null || !role.equals("http://www.w3.org/2003/05/soap-envelope/role/none");
    }

    private void checkMandatoryHeaders(AddressingProperties ap) {
        WSDLPortImpl impl = null;
        if (this.wsdlPort != null) {
            impl = (WSDLPortImpl)this.wsdlPort;
        }
        if (impl != null && impl.isAddressingRequired() && ap == null) {
            throw new WebServiceException("No WS-A headers are found");
        }
        if (impl != null && impl.isAddressingRequired() && ap.getAction() == null) {
            throw new MapRequiredException(this.getActionQName());
        }
        if (impl != null && impl.isAddressingRequired() && ap.getTo() == null) {
            throw new MapRequiredException(this.getToQName());
        }
    }

    private Packet prepareOutbound(Packet packet, boolean validateAction) {
        AddressingProperties inbound = (AddressingProperties)packet.invocationProperties.get("server.inbound");
        if (this.wsdlPort != null) {
            this.wbo = packet.getMessage().getOperation(this.wsdlPort);
        }
        WSDLOperation op = null;
        if (this.wbo != null) {
            op = this.wbo.getOperation();
        }
        if (this.wbo == null || op == null) {
            return packet;
        }
        if (op.isOneWay()) {
            if (validateAction) {
                this.validateAction(packet, inbound.getAction());
            }
            return packet;
        }
        AddressingProperties outbound = this.toOutbound(inbound, packet);
        if (packet.invocationProperties.get("server.outbound") == null) {
            packet.invocationProperties.put("server.outbound", outbound);
        }
        if (inbound != null && inbound.getAction() != null && validateAction) {
            this.validateAction(packet, inbound.getAction());
        }
        return packet;
    }

    public final AddressingProperties toOutbound(AddressingProperties inbound, Packet packet) {
        AddressingProperties outbound;
        block3: {
            outbound = new AddressingProperties();
            try {
                if (inbound != null) {
                    outbound = this.toReply(inbound);
                }
            }
            catch (MapRequiredException e) {
                WSDLPortImpl impl;
                if (this.wsdlPort == null || !(impl = (WSDLPortImpl)this.wsdlPort).isAddressingRequired()) break block3;
                throw e;
            }
        }
        outbound.setAction(this.getOutputAction(packet));
        return outbound;
    }

    public final Packet writeServerOutboundHeaders(Packet packet) {
        AddressingProperties outbound = (AddressingProperties)packet.invocationProperties.get("server.outbound");
        if (outbound == null) {
            return packet;
        }
        Message message = packet.getMessage();
        if (message == null) {
            return packet;
        }
        if (message.isFault()) {
            AddressingProperties inbound = (AddressingProperties)packet.invocationProperties.get("server.inbound");
            outbound = this.toFault(inbound);
            String action = this.getFaultAction(message);
            if (action != null) {
                outbound.setAction(action);
            }
        }
        if (outbound.getTo() == null) {
            EndpointAddress to = packet.endpointAddress;
            if (to == null) {
                outbound.setTo(this.getAnonymousURI());
            } else {
                outbound.setTo(to.toString());
            }
        }
        this.writeHeaders(packet, outbound);
        return packet;
    }

    private String getFaultAction(Message message) {
        String action = this.getDefaultFaultAction();
        if (this.wsdlPort == null) {
            return null;
        }
        try {
            SOAPMessage sm = message.readAsSOAPMessage();
            if (sm == null) {
                return action;
            }
            if (sm.getSOAPBody() == null) {
                return action;
            }
            if (sm.getSOAPBody().getFault() == null) {
                return action;
            }
            Detail detail = sm.getSOAPBody().getFault().getDetail();
            if (detail == null) {
                return action;
            }
            String ns = detail.getFirstChild().getNamespaceURI();
            String name = detail.getFirstChild().getLocalName();
            WSDLOperation o = this.wbo.getOperation();
            if (o == null) {
                return action;
            }
            WSDLFault fault = o.getFault(new QName(ns, name));
            if (fault == null) {
                return action;
            }
            WSDLOperationImpl impl = (WSDLOperationImpl)o;
            Map<String, String> map = impl.getFaultActionMap();
            if (map == null) {
                return action;
            }
            action = map.get(fault.getName());
            return action;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private static Element unmarshalRefp(Header h) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = doc.createElement("wrapper");
            DOMResult dom = new DOMResult();
            dom.setNode(element);
            XMLStreamWriter xsw = XMLOutputFactory.newInstance().createXMLStreamWriter(dom);
            h.writeTo(xsw);
            DOMSource source = new DOMSource(dom.getNode().getFirstChild());
            DOMResult result = new DOMResult();
            XmlUtil.newTransformer().transform(source, result);
            return (Element)result.getNode().getFirstChild();
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    private void validateAction(Packet packet, String gotA) {
        if (packet.proxy != null) {
            return;
        }
        if (gotA == null) {
            throw new WebServiceException("null input action");
        }
        String expected = this.getInputAction(packet);
        String soapAction = this.getSOAPAction(packet);
        if (this.isInputActionDefault(packet) && soapAction != null && !soapAction.equals("")) {
            expected = soapAction;
        }
        if (expected != null && !gotA.equals(expected)) {
            throw new ActionNotSupportedException(gotA);
        }
    }

    public String getInputAction(Packet packet) {
        WSDLOperation op;
        WSDLBoundOperation wbo;
        String action = null;
        if (this.wsdlPort != null && this.wsdlPort.getBinding() != null && (wbo = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart())) != null && (op = wbo.getOperation()) != null) {
            action = ((WSDLOperationImpl)op).getInput().getAction();
        }
        return action;
    }

    public boolean isInputActionDefault(Packet packet) {
        if (this.wsdlPort == null) {
            return false;
        }
        if (this.wsdlPort.getBinding() == null) {
            return false;
        }
        WSDLBoundOperation wbo = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
        if (wbo == null) {
            return false;
        }
        WSDLOperation op = wbo.getOperation();
        if (op == null) {
            return false;
        }
        return ((WSDLOperationImpl)op).getInput().isDefaultAction();
    }

    private String getSOAPAction(Packet packet) {
        String action = "";
        if (packet == null) {
            return action;
        }
        if (packet.getMessage() == null) {
            return action;
        }
        WSDLBoundOperation op = packet.getMessage().getOperation(this.wsdlPort);
        if (op == null) {
            return action;
        }
        action = op.getSOAPAction();
        return action;
    }

    private String getOutputAction(Packet packet) {
        WSDLOperationImpl op;
        WSDLBoundOperation wbo;
        String action = "http://fake.output.action";
        if (this.wsdlPort != null && this.wsdlPort.getBinding() != null && (wbo = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart())) != null && (op = (WSDLOperationImpl)wbo.getOperation()) != null) {
            action = op.getOutput().getAction();
        }
        return action;
    }

    private SOAPFault newActionNotSupportedFault(String action) {
        QName subcode = this.getActionNotSupportedQName();
        String faultstring = String.format(this.getActionNotSupportedText(), action);
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                this.getProblemActionDetail(action, (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private SOAPFault newInvalidMapFault(InvalidMapException e) {
        QName name = e.getMapQName();
        QName subsubcode = e.getSubsubcode();
        QName subcode = this.getInvalidMapQName();
        String faultstring = String.format(this.getInvalidMapText(), name, subsubcode);
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                fault.appendFaultSubcode(subsubcode);
                this.getInvalidMapDetail(name, (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subsubcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new WebServiceException((Throwable)se);
        }
    }

    private SOAPFault newMapRequiredFault(MapRequiredException e) {
        QName subcode = this.getMapRequiredQName();
        QName subsubcode = this.getMapRequiredQName();
        String faultstring = this.getMapRequiredText();
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                fault.appendFaultSubcode(subsubcode);
                this.getMapRequiredDetail(e.getMapQName(), (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subsubcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new WebServiceException((Throwable)se);
        }
    }

    protected void checkAnonymousSemantics(WSDLBoundOperation wbo, AddressingProperties ap) {
    }

    public abstract void getProblemActionDetail(String var1, Element var2);

    public abstract void getInvalidMapDetail(QName var1, Element var2);

    public abstract void getMapRequiredDetail(QName var1, Element var2);

    public abstract SOAPElement getSoap11FaultDetail();

    public abstract String getNamespaceURI();

    public abstract QName getMessageIDQName();

    public abstract QName getFromQName();

    public abstract QName getToQName();

    public abstract QName getReplyToQName();

    public abstract QName getFaultToQName();

    public abstract QName getActionQName();

    public abstract QName getRelatesToQName();

    public abstract QName getRelationshipTypeQName();

    public abstract QName getFaultDetailQName();

    public abstract String getDefaultFaultAction();

    public abstract QName getIsReferenceParameterQName();

    public abstract QName getMapRequiredQName();

    public abstract String getMapRequiredText();

    public abstract QName getActionNotSupportedQName();

    public abstract String getActionNotSupportedText();

    public abstract QName getInvalidMapQName();

    public abstract String getInvalidMapText();

    public abstract AddressingProperties toReply(AddressingProperties var1);

    public abstract AddressingProperties toFault(AddressingProperties var1);

    public abstract String getAnonymousURI();

    public abstract String getRelationshipType();

    public abstract void writeRelatesTo(AddressingProperties var1, HeaderList var2, SOAPVersion var3);

    public abstract void writeRelatesTo(Relationship var1, HeaderList var2, SOAPVersion var3);

    public abstract Relationship newRelationship(Relationship var1);

    public abstract Relationship newRelationship(String var1);

    public abstract EndpointReference newEndpointReference();

    public abstract QName getInvalidCardinalityQName();

    public abstract String getNoneURI();

    public abstract String getAddress(EndpointReference var1);

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new WebServiceException((Throwable)e);
        }
        s11Role = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Actor");
        s12Role = new QName("http://www.w3.org/2003/05/soap-envelope", "role");
    }
}

