/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.streaming.XMLReaderException;
import com.sun.xml.ws.streaming.XMLStreamReaderException;
import com.sun.xml.ws.streaming.XMLStreamWriterException;
import com.sun.xml.ws.util.FastInfosetReflection;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastInfosetUtil {
    public static boolean isFastInfosetAccepted(String[] accepts) {
        for (String accept : accepts) {
            if (!FastInfosetUtil.isFastInfosetAccepted(accept)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFastInfosetAccepted(String accept) {
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.equalsIgnoreCase("application/fastinfoset")) continue;
            return true;
        }
        return false;
    }

    public static String getFastInfosetFromAccept(List<String> accepts) {
        for (String accept : accepts) {
            StringTokenizer st = new StringTokenizer(accept, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.equalsIgnoreCase("application/fastinfoset")) {
                    return "application/fastinfoset";
                }
                if (!token.equalsIgnoreCase("application/soap+fastinfoset")) continue;
                return "application/soap+fastinfoset";
            }
        }
        return null;
    }

    public static void transcodeXMLStringToFI(String xml, OutputStream out) {
        try {
            XmlUtil.newTransformer().transform(new StreamSource(new StringReader(xml)), FastInfosetReflection.FastInfosetResult_new(out));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static XMLStreamReader createFIStreamReader(InputSource source) {
        return FastInfosetUtil.createFIStreamReader(source.getByteStream());
    }

    public static XMLStreamReader createFIStreamReader(InputStream in) {
        if (FastInfosetReflection.fiStAXDocumentParser_new == null) {
            throw new XMLReaderException("fastinfoset.noImplementation", new Object[0]);
        }
        try {
            Object sdp = FastInfosetReflection.fiStAXDocumentParser_new.newInstance(new Object[0]);
            FastInfosetReflection.fiStAXDocumentParser_setStringInterning.invoke(sdp, Boolean.TRUE);
            FastInfosetReflection.fiStAXDocumentParser_setInputStream.invoke(sdp, in);
            return (XMLStreamReader)sdp;
        }
        catch (Exception e) {
            throw new XMLStreamReaderException(e);
        }
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream out) {
        return FastInfosetUtil.createFIStreamWriter(out, "UTF-8");
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream out, String encoding) {
        return FastInfosetUtil.createFIStreamWriter(out, encoding, true);
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream out, String encoding, boolean declare) {
        if (FastInfosetReflection.fiStAXDocumentSerializer_new == null) {
            throw new XMLReaderException("fastinfoset.noImplementation", new Object[0]);
        }
        try {
            Object sds = FastInfosetReflection.fiStAXDocumentSerializer_new.newInstance(new Object[0]);
            FastInfosetReflection.fiStAXDocumentSerializer_setOutputStream.invoke(sds, out);
            FastInfosetReflection.fiStAXDocumentSerializer_setEncoding.invoke(sds, encoding);
            return (XMLStreamWriter)sds;
        }
        catch (Exception e) {
            throw new XMLStreamWriterException(e);
        }
    }
}

