/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.AsyncInvoker;
import com.sun.xml.ws.client.AsyncResponseImpl;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.RESTSourceDispatch;
import com.sun.xml.ws.client.dispatch.SOAPSourceDispatch;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.message.AttachmentSetImpl;
import com.sun.xml.ws.message.DataHandlerAttachment;
import com.sun.xml.ws.resources.DispatchMessages;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DispatchImpl<T>
extends Stub
implements Dispatch<T> {
    final Service.Mode mode;
    final QName portname;
    final SOAPVersion soapVersion;
    static final long AWAIT_TERMINATION_TIME = 800L;
    static final String HTTP_REQUEST_METHOD_GET = "GET";
    static final String HTTP_REQUEST_METHOD_POST = "POST";
    static final String HTTP_REQUEST_METHOD_PUT = "PUT";

    protected DispatchImpl(QName port, Service.Mode mode, WSServiceDelegate owner, Tube pipe, BindingImpl binding, @Nullable WSEndpointReference epr) {
        super(owner, pipe, binding, owner.getWsdlService() != null ? owner.getWsdlService().get(port) : null, owner.getEndpointAddress(port), epr);
        this.portname = port;
        this.mode = mode;
        this.soapVersion = binding.getSOAPVersion();
    }

    abstract Packet createPacket(T var1);

    abstract T toReturnValue(Packet var1);

    public final Response<T> invokeAsync(T param) {
        DispatchAsyncInvoker invoker = new DispatchAsyncInvoker(param);
        AsyncResponseImpl ft = new AsyncResponseImpl((Runnable)invoker, null);
        invoker.setReceiver(ft);
        this.owner.getExecutor().execute(ft);
        return ft;
    }

    public final Future<?> invokeAsync(T param, AsyncHandler<T> asyncHandler) {
        DispatchAsyncInvoker invoker = new DispatchAsyncInvoker(param);
        AsyncResponseImpl<T> ft = new AsyncResponseImpl<T>((Runnable)invoker, asyncHandler);
        invoker.setReceiver(ft);
        ExecutorService exec = (ExecutorService)this.owner.getExecutor();
        try {
            exec.awaitTermination(800L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException e) {
            throw new WebServiceException((Throwable)e);
        }
        exec.execute(ft);
        return ft;
    }

    public final T doInvoke(T in, RequestContext rc, ResponseContextReceiver receiver) {
        Packet response;
        try {
            DispatchImpl.checkNullAllowed(in, rc, this.binding, this.mode);
            Packet message = this.createPacket(in);
            this.resolveEndpointAddress(message, rc);
            this.setProperties(message, true);
            response = this.process(message, rc, receiver);
            Message msg = response.getMessage();
            if (msg != null && msg.isFault()) {
                SOAPFaultBuilder faultBuilder = SOAPFaultBuilder.create(msg);
                throw (SOAPFaultException)faultBuilder.createException(null);
            }
        }
        catch (JAXBException e) {
            throw new DeserializationException(DispatchMessages.INVALID_RESPONSE_DESERIALIZATION(), new Object[]{e});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebServiceException(e);
        }
        return this.toReturnValue(response);
    }

    public final T invoke(T in) {
        return this.doInvoke(in, this.requestContext, this);
    }

    public final void invokeOneWay(T in) {
        DispatchImpl.checkNullAllowed(in, this.requestContext, this.binding, this.mode);
        Packet request = this.createPacket(in);
        this.setProperties(request, false);
        Packet response = this.process(request, this.requestContext, this);
    }

    void setProperties(Packet packet, boolean expectReply) {
        packet.expectReply = expectReply;
    }

    static boolean isXMLHttp(@NotNull WSBinding binding) {
        return binding.getBindingId().equals(BindingID.XML_HTTP);
    }

    static boolean isPAYLOADMode(@NotNull Service.Mode mode) {
        return mode == Service.Mode.PAYLOAD;
    }

    static void checkNullAllowed(@Nullable Object in, RequestContext rc, WSBinding binding, Service.Mode mode) {
        if (in != null) {
            return;
        }
        if (DispatchImpl.isXMLHttp(binding)) {
            if (DispatchImpl.methodNotOk(rc)) {
                throw new WebServiceException(DispatchMessages.INVALID_NULLARG_XMLHTTP_REQUEST_METHOD(HTTP_REQUEST_METHOD_POST, HTTP_REQUEST_METHOD_GET));
            }
        } else if (mode == Service.Mode.MESSAGE) {
            throw new WebServiceException(DispatchMessages.INVALID_NULLARG_SOAP_MSGMODE(mode.name(), Service.Mode.PAYLOAD.toString()));
        }
    }

    static boolean methodNotOk(@NotNull RequestContext rc) {
        String requestMethod = (String)rc.get("javax.xml.ws.http.request.method");
        String request = requestMethod == null ? HTTP_REQUEST_METHOD_POST : requestMethod;
        return HTTP_REQUEST_METHOD_POST.equalsIgnoreCase(request) || HTTP_REQUEST_METHOD_PUT.equalsIgnoreCase(request);
    }

    public static void checkValidSOAPMessageDispatch(WSBinding binding, Service.Mode mode) {
        if (DispatchImpl.isXMLHttp(binding)) {
            throw new WebServiceException(DispatchMessages.INVALID_SOAPMESSAGE_DISPATCH_BINDING("http://www.w3.org/2004/08/wsdl/http", "http://schemas.xmlsoap.org/wsdl/soap/http or http://www.w3.org/2003/05/soap/bindings/HTTP/"));
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException(DispatchMessages.INVALID_SOAPMESSAGE_DISPATCH_MSGMODE(mode.name(), Service.Mode.MESSAGE.toString()));
        }
    }

    public static void checkValidDataSourceDispatch(WSBinding binding, Service.Mode mode) {
        if (!DispatchImpl.isXMLHttp(binding)) {
            throw new WebServiceException(DispatchMessages.INVALID_DATASOURCE_DISPATCH_BINDING("SOAP/HTTP", "http://www.w3.org/2004/08/wsdl/http"));
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException(DispatchMessages.INVALID_DATASOURCE_DISPATCH_MSGMODE(mode.name(), Service.Mode.MESSAGE.toString()));
        }
    }

    @Override
    @NotNull
    protected final QName getPortName() {
        return this.portname;
    }

    void resolveEndpointAddress(@NotNull Packet message, @NotNull RequestContext requestContext) {
        String endpoint = (String)requestContext.get("javax.xml.ws.service.endpoint.address");
        if (endpoint == null) {
            endpoint = message.endpointAddress.toString();
        }
        String pathInfo = null;
        String queryString = null;
        if (requestContext.get("javax.xml.ws.http.request.pathinfo") != null) {
            pathInfo = (String)requestContext.get("javax.xml.ws.http.request.pathinfo");
        }
        if (requestContext.get("javax.xml.ws.http.request.querystring") != null) {
            queryString = (String)requestContext.get("javax.xml.ws.http.request.querystring");
        }
        String resolvedEndpoint = null;
        if (pathInfo != null || queryString != null) {
            pathInfo = DispatchImpl.checkPath(pathInfo);
            queryString = DispatchImpl.checkQuery(queryString);
            if (endpoint != null) {
                try {
                    URI endpointURI = new URI(endpoint);
                    resolvedEndpoint = this.resolveURI(endpointURI, pathInfo, queryString);
                }
                catch (URISyntaxException e) {
                    throw new WebServiceException(DispatchMessages.INVALID_URI(endpoint));
                }
            }
            requestContext.put("javax.xml.ws.service.endpoint.address", resolvedEndpoint);
        }
    }

    @NotNull
    protected String resolveURI(@NotNull URI endpointURI, @Nullable String pathInfo, @Nullable String queryString) {
        String query = null;
        String fragment = null;
        if (queryString != null) {
            URI result;
            try {
                URI tp = new URI(null, null, endpointURI.getPath(), queryString, null);
                result = endpointURI.resolve(tp);
            }
            catch (URISyntaxException e) {
                throw new WebServiceException(DispatchMessages.INVALID_QUERY_STRING(queryString));
            }
            query = result.getQuery();
            fragment = result.getFragment();
        }
        String path = pathInfo != null ? pathInfo : endpointURI.getPath();
        try {
            URI temp = new URI(null, null, path, query, fragment);
            return URLDecoder.decode(endpointURI.resolve(temp).toURL().toExternalForm(), "UTF-8");
        }
        catch (URISyntaxException e) {
            throw new WebServiceException(DispatchMessages.INVALID_URI_PATH_QUERY(path, query));
        }
        catch (MalformedURLException e) {
            throw new WebServiceException(DispatchMessages.INVALID_URI_RESOLUTION(path));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebServiceException(DispatchMessages.INVALID_URI_DECODE());
        }
    }

    private static String checkPath(@Nullable String path) {
        return path == null || path.startsWith("/") ? path : "/" + path;
    }

    private static String checkQuery(@Nullable String query) {
        if (query == null) {
            return null;
        }
        if (query.indexOf(63) == 0) {
            throw new WebServiceException(DispatchMessages.INVALID_QUERY_LEADING_CHAR(query));
        }
        return query;
    }

    protected AttachmentSet setOutboundAttachments() {
        HashMap attachments = (HashMap)this.getRequestContext().get("javax.xml.ws.binding.attachments.outbound");
        if (attachments != null) {
            ArrayList<Attachment> alist = new ArrayList<Attachment>();
            for (Map.Entry att : attachments.entrySet()) {
                DataHandlerAttachment dha = new DataHandlerAttachment((String)att.getKey(), (DataHandler)att.getValue());
                alist.add(dha);
            }
            return new AttachmentSetImpl(alist);
        }
        return new AttachmentSetImpl();
    }

    @Override
    public void setOutboundHeaders(Object ... headers) {
        throw new UnsupportedOperationException();
    }

    public static Dispatch<Source> createSourceDispatch(QName port, Service.Mode mode, WSServiceDelegate owner, Tube pipe, BindingImpl binding, WSEndpointReference epr) {
        if (DispatchImpl.isXMLHttp(binding)) {
            return new RESTSourceDispatch(port, mode, owner, pipe, binding, epr);
        }
        return new SOAPSourceDispatch(port, mode, owner, pipe, binding, epr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DispatchAsyncInvoker
    extends AsyncInvoker {
        private final T param;
        private final RequestContext rc;

        DispatchAsyncInvoker(T param) {
            this.rc = DispatchImpl.this.requestContext.copy();
            this.param = param;
        }

        @Override
        public void run() {
            DispatchImpl.checkNullAllowed(this.param, this.rc, DispatchImpl.this.binding, DispatchImpl.this.mode);
            Packet message = DispatchImpl.this.createPacket(this.param);
            DispatchImpl.this.resolveEndpointAddress(message, this.rc);
            DispatchImpl.this.setProperties(message, true);
            Fiber.CompletionCallback callback = new Fiber.CompletionCallback(){

                public void onCompletion(@NotNull Packet response) {
                    Message msg = response.getMessage();
                    try {
                        if (msg != null && msg.isFault()) {
                            SOAPFaultBuilder faultBuilder = SOAPFaultBuilder.create(msg);
                            throw (SOAPFaultException)faultBuilder.createException(null);
                        }
                        DispatchAsyncInvoker.this.responseImpl.setResponseContext(new ResponseContext(response));
                        DispatchAsyncInvoker.this.responseImpl.set(DispatchImpl.this.toReturnValue(response), null);
                    }
                    catch (JAXBException e) {
                        DispatchAsyncInvoker.this.responseImpl.set(null, (Throwable)((Object)new DeserializationException(DispatchMessages.INVALID_RESPONSE_DESERIALIZATION(), new Object[]{e})));
                    }
                    catch (RuntimeException e) {
                        DispatchAsyncInvoker.this.responseImpl.set(null, e);
                    }
                    catch (Throwable e) {
                        DispatchAsyncInvoker.this.responseImpl.set(null, new WebServiceException(e));
                    }
                }

                public void onCompletion(@NotNull Throwable error) {
                    DispatchAsyncInvoker.this.responseImpl.set(null, error);
                }
            };
            DispatchImpl.this.processAsync(message, this.rc, callback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Invoker
    implements Callable {
        private final T param;
        private final RequestContext rc;
        private ResponseContextReceiver receiver;

        Invoker(T param) {
            this.rc = DispatchImpl.this.requestContext.copy();
            this.param = param;
        }

        public T call() throws Exception {
            return DispatchImpl.this.doInvoke(this.param, this.rc, this.receiver);
        }

        void setReceiver(ResponseContextReceiver receiver) {
            this.receiver = receiver;
        }
    }
}

