/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.pipe.ContentType;

public final class ContentTypeImpl
implements ContentType {
    @NotNull
    private final String contentType;
    @NotNull
    private final String soapAction;
    @Nullable
    private final String accept;
    @Nullable
    private final String charset;

    public ContentTypeImpl(String contentType) {
        this(contentType, null, null);
    }

    public ContentTypeImpl(String contentType, @Nullable String soapAction) {
        this(contentType, soapAction, null);
    }

    public ContentTypeImpl(String contentType, @Nullable String soapAction, @Nullable String accept) {
        this.contentType = contentType;
        this.accept = accept;
        this.soapAction = this.getQuotedSOAPAction(soapAction);
        String tmpCharset = null;
        try {
            tmpCharset = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(contentType).getParameter("charset");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.charset = tmpCharset;
    }

    @Nullable
    public String getCharSet() {
        return this.charset;
    }

    private String getQuotedSOAPAction(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            return "\"\"";
        }
        if (soapAction.charAt(0) != '\"' && soapAction.charAt(soapAction.length() - 1) != '\"') {
            return "\"" + soapAction + "\"";
        }
        return soapAction;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getSOAPActionHeader() {
        return this.soapAction;
    }

    public String getAcceptHeader() {
        return this.accept;
    }
}

