/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.sei.DispatchException;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.ws.server.sei.SEIInvokerTube;
import com.sun.xml.ws.util.QNameMap;
import javax.xml.namespace.QName;

final class PayloadQNameBasedDispatcher
implements EndpointMethodDispatcher {
    private final QNameMap<EndpointMethodHandler> methodHandlers;
    private static final String EMPTY_PAYLOAD_LOCAL = "";
    private static final String EMPTY_PAYLOAD_NSURI = "";
    private static final QName EMPTY_PAYLOAD = new QName("", "");
    private WSBinding binding;

    public PayloadQNameBasedDispatcher(AbstractSEIModelImpl model, WSBinding binding, SEIInvokerTube invokerTube) {
        this.binding = binding;
        this.methodHandlers = new QNameMap();
        for (JavaMethodImpl m : model.getJavaMethods()) {
            QName name = m.getRequestPayloadName();
            if (name == null) {
                name = EMPTY_PAYLOAD;
            }
            this.methodHandlers.put(name, new EndpointMethodHandler(invokerTube, m, binding));
        }
    }

    @NotNull
    public EndpointMethodHandler getEndpointMethodHandler(Packet request) throws DispatchException {
        String nsUri;
        Message message = request.getMessage();
        String localPart = message.getPayloadLocalPart();
        if (localPart == null) {
            localPart = "";
            nsUri = "";
        } else {
            nsUri = message.getPayloadNamespaceURI();
        }
        EndpointMethodHandler h = this.methodHandlers.get(nsUri, localPart);
        if (h == null) {
            String dispatchKey = "{" + nsUri + "}" + localPart;
            String faultString = ServerMessages.DISPATCH_CANNOT_FIND_METHOD(dispatchKey, "Payload QName-based Dispatcher");
            throw new DispatchException(SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), faultString, this.binding.getSOAPVersion().faultCodeClient));
        }
        return h;
    }
}

