/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.FragmentContentHandler;
import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.developer.EPRRecipe;
import com.sun.xml.ws.developer.StatefulWebServiceManager;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.AbstractInstanceResolver;
import com.sun.xml.ws.server.AbstractMultiInstanceResolver;
import com.sun.xml.ws.server.InvokerTube;
import com.sun.xml.ws.spi.ProviderImpl;
import com.sun.xml.ws.util.xml.ContentHandlerToXMLStreamWriter;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatefulInstanceResolver<T>
extends AbstractMultiInstanceResolver<T>
implements StatefulWebServiceManager<T> {
    @Nullable
    private volatile T fallback;
    private final Map<String, Instance> instances = Collections.synchronizedMap(new HashMap());
    private final Map<T, String> reverseInstances = Collections.synchronizedMap(new HashMap());
    private volatile long timeoutMilliseconds = 0L;
    private volatile StatefulWebServiceManager.Callback<T> timeoutCallback;
    private static volatile Timer timer;
    private static final QName COOKIE_TAG;
    private static final Logger logger;

    public StatefulInstanceResolver(Class<T> clazz) {
        super(clazz);
    }

    @Override
    @NotNull
    public T resolve(Packet request) {
        T fallback;
        HeaderList headers = request.getMessage().getHeaders();
        Header header = headers.get(COOKIE_TAG, true);
        String id = null;
        if (header != null) {
            id = header.getStringContent();
            Instance o = this.instances.get(id);
            if (o != null) {
                o.restartTimer();
                return o.instance;
            }
            logger.log(Level.INFO, "Request had an unrecognized object ID " + id);
        }
        if ((fallback = this.fallback) != null) {
            return fallback;
        }
        if (id == null) {
            throw new WebServiceException(ServerMessages.STATEFUL_COOKIE_HEADER_REQUIRED(COOKIE_TAG));
        }
        throw new WebServiceException(ServerMessages.STATEFUL_COOKIE_HEADER_INCORRECT(COOKIE_TAG, id));
    }

    @Override
    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        super.start(wsc, endpoint);
        if (endpoint.getBinding().getAddressingVersion() == null) {
            throw new WebServiceException(ServerMessages.STATEFUL_REQURES_ADDRESSING(this.clazz));
        }
        for (Field field : this.clazz.getDeclaredFields()) {
            if (field.getType() != StatefulWebServiceManager.class) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(StatefulWebServiceManager.class, field));
            }
            new AbstractInstanceResolver.FieldInjectionPlan<Object, StatefulInstanceResolver>(field).inject(null, this);
        }
        for (AccessibleObject accessibleObject : this.clazz.getDeclaredMethods()) {
            Class<?>[] paramTypes = ((Method)accessibleObject).getParameterTypes();
            if (paramTypes.length != 1 || paramTypes[0] != StatefulWebServiceManager.class) continue;
            if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(StatefulWebServiceManager.class, accessibleObject));
            }
            new AbstractInstanceResolver.MethodInjectionPlan<Object, StatefulInstanceResolver>((Method)accessibleObject).inject(null, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.reverseInstances.clear();
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            for (Instance t : this.instances.values()) {
                t.cancel();
                this.dispose(t.instance);
            }
            this.instances.clear();
        }
        if (this.fallback != null) {
            this.dispose(this.fallback);
        }
        this.fallback = null;
    }

    @Override
    @NotNull
    public W3CEndpointReference export(T o) {
        return this.export(W3CEndpointReference.class, o);
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> epr, T o) {
        return this.export(epr, o, null);
    }

    @Override
    public <EPR extends EndpointReference> EPR export(Class<EPR> epr, T o, EPRRecipe recipe) {
        return this.export(epr, InvokerTube.getCurrentPacket(), o, recipe);
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> epr, WebServiceContext context, T o) {
        if (context instanceof WSWebServiceContext) {
            WSWebServiceContext wswsc = (WSWebServiceContext)context;
            return this.export(epr, wswsc.getRequestPacket(), o);
        }
        throw new WebServiceException(ServerMessages.STATEFUL_INVALID_WEBSERVICE_CONTEXT(context));
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> adrsVer, @NotNull Packet currentRequest, T o) {
        return this.export(adrsVer, currentRequest, o, null);
    }

    @Override
    public <EPR extends EndpointReference> EPR export(Class<EPR> adrsVer, @NotNull Packet currentRequest, T o, EPRRecipe recipe) {
        return this.export(adrsVer, currentRequest.webServiceContextDelegate.getEPRAddress(currentRequest, this.owner), o, recipe);
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> adrsVer, String endpointAddress, T o) {
        return this.export(adrsVer, endpointAddress, o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> adrsVer, String endpointAddress, T o, EPRRecipe recipe) {
        if (endpointAddress == null) {
            throw new IllegalArgumentException("No address available");
        }
        String key = this.reverseInstances.get(o);
        if (key != null) {
            return this.createEPR(key, adrsVer, endpointAddress, recipe);
        }
        StatefulInstanceResolver statefulInstanceResolver = this;
        synchronized (statefulInstanceResolver) {
            key = this.reverseInstances.get(o);
            if (key != null) {
                return this.createEPR(key, adrsVer, endpointAddress, recipe);
            }
            if (o != null) {
                this.prepare(o);
            }
            key = UUID.randomUUID().toString();
            Instance instance = new Instance(o);
            this.instances.put(key, instance);
            this.reverseInstances.put(o, key);
            if (this.timeoutMilliseconds != 0L) {
                instance.restartTimer();
            }
        }
        return this.createEPR(key, adrsVer, endpointAddress, recipe);
    }

    private <EPR extends EndpointReference> EPR createEPR(String key, Class<EPR> eprClass, String address, EPRRecipe recipe) {
        AddressingVersion adrsVer = AddressingVersion.fromSpecClass(eprClass);
        try {
            List<Source> metadata;
            StreamWriterBufferCreator w = new StreamWriterBufferCreator();
            w.writeStartDocument();
            w.writeStartElement("wsa", "EndpointReference", adrsVer.nsUri);
            w.writeNamespace("wsa", adrsVer.nsUri);
            w.writeStartElement("wsa", "Address", adrsVer.nsUri);
            w.writeCharacters(address);
            w.writeEndElement();
            w.writeStartElement("wsa", "ReferenceParameters", adrsVer.nsUri);
            w.writeStartElement(COOKIE_TAG.getPrefix(), COOKIE_TAG.getLocalPart(), COOKIE_TAG.getNamespaceURI());
            w.writeCharacters(key);
            w.writeEndElement();
            if (recipe != null) {
                for (Header h : recipe.getReferenceParameters()) {
                    h.writeTo((XMLStreamWriter)w);
                }
            }
            w.writeEndElement();
            if (recipe != null && !(metadata = recipe.getMetadata()).isEmpty()) {
                w.writeStartElement("wsa", "Metadata", adrsVer.nsUri);
                Transformer t = XmlUtil.newTransformer();
                for (Source s : metadata) {
                    try {
                        t.transform(s, new SAXResult((ContentHandler)new FragmentContentHandler((ContentHandler)new ContentHandlerToXMLStreamWriter((XMLStreamWriter)w))));
                    }
                    catch (TransformerException e) {
                        throw new IllegalArgumentException("Unable to write EPR metadata " + s, e);
                    }
                }
                w.writeEndElement();
            }
            w.writeEndElement();
            w.writeEndDocument();
            return (EPR)((EndpointReference)eprClass.cast(ProviderImpl.INSTANCE.readEndpointReference((Source)new XMLStreamBufferSource((XMLStreamBuffer)w.getXMLStreamBuffer()))));
        }
        catch (XMLStreamException e) {
            throw new Error(e);
        }
    }

    @Override
    public void unexport(@Nullable T o) {
        if (o == null) {
            return;
        }
        String key = this.reverseInstances.get(o);
        if (key == null) {
            return;
        }
        this.instances.remove(key);
    }

    @Override
    public T resolve(EndpointReference epr) {
        class CookieSniffer
        extends DefaultHandler {
            StringBuilder buf = new StringBuilder();
            boolean inCookie = false;

            CookieSniffer() {
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals(COOKIE_TAG.getLocalPart()) && uri.equals(COOKIE_TAG.getNamespaceURI())) {
                    this.inCookie = true;
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.inCookie) {
                    this.buf.append(ch, start, length);
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                this.inCookie = false;
            }
        }
        CookieSniffer sniffer = new CookieSniffer();
        epr.writeTo((Result)new SAXResult(sniffer));
        Instance o = this.instances.get(sniffer.buf.toString());
        if (o != null) {
            return o.instance;
        }
        return null;
    }

    @Override
    public void setFallbackInstance(T o) {
        if (o != null) {
            this.prepare(o);
        }
        this.fallback = o;
    }

    @Override
    public void setTimeout(long milliseconds, StatefulWebServiceManager.Callback<T> callback) {
        if (milliseconds < 0L) {
            throw new IllegalArgumentException();
        }
        this.timeoutMilliseconds = milliseconds;
        this.timeoutCallback = callback;
        if (this.timeoutMilliseconds > 0L) {
            StatefulInstanceResolver.startTimer();
        }
    }

    @Override
    public void touch(T o) {
        String key = this.reverseInstances.get(o);
        if (key == null) {
            return;
        }
        Instance inst = this.instances.get(key);
        if (inst == null) {
            return;
        }
        inst.restartTimer();
    }

    private static synchronized void startTimer() {
        if (timer == null) {
            timer = new Timer("JAX-WS stateful web service timeout timer");
        }
    }

    static {
        COOKIE_TAG = new QName("http://jax-ws.dev.java.net/xml/ns/", "objectId", "jaxws");
        logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Instance {
        @NotNull
        final T instance;
        TimerTask task;

        public Instance(T instance) {
            this.instance = instance;
        }

        public synchronized void restartTimer() {
            this.cancel();
            if (StatefulInstanceResolver.this.timeoutMilliseconds == 0L) {
                return;
            }
            this.task = new TimerTask(){

                public void run() {
                    try {
                        StatefulWebServiceManager.Callback cb = StatefulInstanceResolver.this.timeoutCallback;
                        if (cb != null) {
                            cb.onTimeout(Instance.this.instance, StatefulInstanceResolver.this);
                            return;
                        }
                        StatefulInstanceResolver.this.unexport(Instance.this.instance);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "time out handler failed", e);
                    }
                }
            };
            timer.schedule(this.task, StatefulInstanceResolver.this.timeoutMilliseconds);
        }

        public synchronized void cancel() {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = null;
        }
    }
}

