/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.dtd;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.istack.SAXParseException2;
import com.sun.tools.xjc.AbortException;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.TypeUse;
import com.sun.tools.xjc.model.TypeUseFactory;
import com.sun.tools.xjc.reader.ModelChecker;
import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.dtd.Element;
import com.sun.tools.xjc.reader.dtd.Messages;
import com.sun.tools.xjc.reader.dtd.ModelGroup;
import com.sun.tools.xjc.reader.dtd.Occurence;
import com.sun.tools.xjc.reader.dtd.Term;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIAttribute;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIElement;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIInterface;
import com.sun.tools.xjc.reader.dtd.bindinfo.BindInfo;
import com.sun.tools.xjc.util.CodeModelClassFactory;
import com.sun.tools.xjc.util.ErrorReceiverFilter;
import com.sun.xml.bind.api.impl.NameConverter;
import com.sun.xml.dtdparser.DTDHandlerBase;
import com.sun.xml.dtdparser.DTDParser;
import com.sun.xml.dtdparser.InputEntity;
import com.sun.xml.xsom.XmlString;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class TDTDReader
extends DTDHandlerBase {
    private final EntityResolver entityResolver;
    final BindInfo bindInfo;
    final Model model = Ring.get(Model.class);
    private final CodeModelClassFactory classFactory;
    private final ErrorReceiverFilter errorReceiver;
    private final Map<String, Element> elements = new HashMap<String, Element>();
    private final Stack<ModelGroup> modelGroups = new Stack();
    private Locator locator;
    private static final Map<String, TypeUse> builtinConversions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model parse(InputSource dtd, InputSource bindingInfo, ErrorReceiver errorReceiver, Options opts) {
        try {
            Ring old = Ring.begin();
            try {
                ErrorReceiverFilter ef = new ErrorReceiverFilter(errorReceiver);
                JCodeModel cm = new JCodeModel();
                Model model = new Model(opts, cm, NameConverter.standard, opts.classNameAllocator, null);
                Ring.add(cm);
                Ring.add(model);
                Ring.add(ErrorReceiver.class, ef);
                TDTDReader reader = new TDTDReader(ef, opts, bindingInfo);
                DTDParser parser = new DTDParser();
                parser.setDtdHandler(reader);
                if (opts.entityResolver != null) {
                    parser.setEntityResolver(opts.entityResolver);
                }
                try {
                    parser.parse(dtd);
                }
                catch (SAXParseException e) {
                    Model model2 = null;
                    Ring.end(old);
                    return model2;
                }
                Ring.get(ModelChecker.class).check();
                if (ef.hadError()) {
                    Model model3 = null;
                    return model3;
                }
                Model model4 = model;
                return model4;
            }
            finally {
                Ring.end(old);
            }
        }
        catch (IOException e) {
            errorReceiver.error(new SAXParseException2(e.getMessage(), null, e));
            return null;
        }
        catch (SAXException e) {
            errorReceiver.error(new SAXParseException2(e.getMessage(), null, e));
            return null;
        }
        catch (AbortException e) {
            return null;
        }
    }

    protected TDTDReader(ErrorReceiver errorReceiver, Options opts, InputSource _bindInfo) throws AbortException {
        this.entityResolver = opts.entityResolver;
        this.errorReceiver = new ErrorReceiverFilter(errorReceiver);
        this.bindInfo = new BindInfo(this.model, _bindInfo, (ErrorReceiver)this.errorReceiver);
        this.classFactory = new CodeModelClassFactory(errorReceiver);
    }

    public void startDTD(InputEntity entity) throws SAXException {
    }

    public void endDTD() throws SAXException {
        for (Element e : this.elements.values()) {
            e.bind();
        }
        if (this.errorReceiver.hadError()) {
            return;
        }
        this.processInterfaceDeclarations();
        this.model.serialVersionUID = this.bindInfo.getSerialVersionUID();
        if (this.model.serialVersionUID != null) {
            this.model.serializable = true;
        }
        this.model.rootClass = this.bindInfo.getSuperClass();
        this.model.rootInterface = this.bindInfo.getSuperInterface();
        this.processConstructorDeclarations();
    }

    private void processInterfaceDeclarations() {
        HashMap<String, InterfaceAcceptor> fromName = new HashMap<String, InterfaceAcceptor>();
        HashMap<BIInterface, JDefinedClass> decls = new HashMap<BIInterface, JDefinedClass>();
        for (BIInterface bIInterface : this.bindInfo.interfaces()) {
            final JDefinedClass intf = this.classFactory.createInterface(this.bindInfo.getTargetPackage(), bIInterface.name(), this.copyLocator());
            decls.put(bIInterface, intf);
            fromName.put(bIInterface.name(), new InterfaceAcceptor(){

                public void implement(JClass c) {
                    intf._implements(c);
                }
            });
        }
        for (final CClassInfo cClassInfo : this.model.beans().values()) {
            fromName.put(cClassInfo.getName(), new InterfaceAcceptor(){

                public void implement(JClass c) {
                    cClassInfo._implements(c);
                }
            });
        }
        for (Map.Entry entry : decls.entrySet()) {
            BIInterface decl = (BIInterface)entry.getKey();
            JClass c = (JClass)entry.getValue();
            for (String member : decl.members()) {
                InterfaceAcceptor acc = (InterfaceAcceptor)fromName.get(member);
                if (acc == null) {
                    this.error(decl.getSourceLocation(), "TDTDReader.BindInfo.NonExistentInterfaceMember", member);
                    continue;
                }
                acc.implement(c);
            }
        }
    }

    JPackage getTargetPackage() {
        return this.bindInfo.getTargetPackage();
    }

    private void processConstructorDeclarations() {
        for (BIElement decl : this.bindInfo.elements()) {
            Element e = this.elements.get(decl.name());
            if (e == null) {
                this.error(decl.getSourceLocation(), "TDTDReader.BindInfo.NonExistentElementDeclaration", decl.name());
                continue;
            }
            if (!decl.isClass()) continue;
            decl.declareConstructors(e.getClassInfo());
        }
    }

    public void attributeDecl(String elementName, String attributeName, String attributeType, String[] enumeration, short attributeUse, String defaultValue) throws SAXException {
        this.getOrCreateElement((String)elementName).attributes.add(this.createAttribute(elementName, attributeName, attributeType, enumeration, attributeUse, defaultValue));
    }

    protected CPropertyInfo createAttribute(String elementName, String attributeName, String attributeType, String[] enums, short attributeUse, String defaultValue) throws SAXException {
        boolean required = attributeUse == 3;
        BIElement edecl = this.bindInfo.element(elementName);
        BIAttribute decl = null;
        if (edecl != null) {
            decl = edecl.attribute(attributeName);
        }
        String propName = decl == null ? this.model.getNameConverter().toPropertyName(attributeName) : decl.getPropertyName();
        QName qname2 = new QName("", attributeName);
        TypeUse use = decl != null && decl.getConversion() != null ? decl.getConversion().getTransducer() : builtinConversions.get(attributeType);
        CAttributePropertyInfo r = new CAttributePropertyInfo(propName, null, null, this.copyLocator(), qname2, use, null, required);
        if (defaultValue != null) {
            r.defaultValue = CDefaultValue.create(use, new XmlString(defaultValue));
        }
        return r;
    }

    Element getOrCreateElement(String elementName) {
        Element r = this.elements.get(elementName);
        if (r == null) {
            r = new Element(this, elementName);
            this.elements.put(elementName, r);
        }
        return r;
    }

    public void startContentModel(String elementName, short contentModelType) throws SAXException {
        assert (this.modelGroups.isEmpty());
        this.modelGroups.push(new ModelGroup());
    }

    public void endContentModel(String elementName, short contentModelType) throws SAXException {
        assert (this.modelGroups.size() == 1);
        Term term = this.modelGroups.pop().wrapUp();
        Element e = this.getOrCreateElement(elementName);
        e.define(contentModelType, term, this.copyLocator());
    }

    public void startModelGroup() throws SAXException {
        this.modelGroups.push(new ModelGroup());
    }

    public void endModelGroup(short occurence) throws SAXException {
        Term t = Occurence.wrap(this.modelGroups.pop().wrapUp(), occurence);
        this.modelGroups.peek().addTerm(t);
    }

    public void connector(short connectorType) throws SAXException {
        this.modelGroups.peek().setKind(connectorType);
    }

    public void childElement(String elementName, short occurence) throws SAXException {
        Element child = this.getOrCreateElement(elementName);
        this.modelGroups.peek().addTerm(Occurence.wrap(child, occurence));
        child.isReferenced = true;
    }

    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    private Locator copyLocator() {
        return new LocatorImpl(this.locator);
    }

    public void error(SAXParseException e) throws SAXException {
        this.errorReceiver.error(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.errorReceiver.fatalError(e);
    }

    public void warning(SAXParseException e) throws SAXException {
        this.errorReceiver.warning(e);
    }

    protected final void error(Locator loc, String prop, Object ... args) {
        this.errorReceiver.error(loc, Messages.format(prop, args));
    }

    static {
        HashMap<String, TypeUse> m = new HashMap<String, TypeUse>();
        m.put("CDATA", CBuiltinLeafInfo.NORMALIZED_STRING);
        m.put("ENTITY", CBuiltinLeafInfo.TOKEN);
        m.put("ENTITIES", CBuiltinLeafInfo.STRING.makeCollection());
        m.put("NMTOKEN", CBuiltinLeafInfo.TOKEN);
        m.put("NMTOKENS", CBuiltinLeafInfo.STRING.makeCollection());
        m.put("ID", CBuiltinLeafInfo.ID);
        m.put("IDREF", CBuiltinLeafInfo.IDREF);
        m.put("IDREFS", TypeUseFactory.makeCollection(CBuiltinLeafInfo.IDREF));
        m.put("ENUMERATION", CBuiltinLeafInfo.TOKEN);
        builtinConversions = Collections.unmodifiableMap(m);
    }

    private static interface InterfaceAcceptor {
        public void implement(JClass var1);
    }
}

