/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.async_client_transport;

import jakarta.xml.ws.WebServiceException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.UUID;

public class NonAnonymousAddressAllocator {
    private static final NonAnonymousAddressAllocator INSTANCE = new NonAnonymousAddressAllocator();
    private String address;

    private NonAnonymousAddressAllocator() {
    }

    public static NonAnonymousAddressAllocator getInstance() {
        return INSTANCE;
    }

    private String getAddress() {
        if (this.address == null) {
            this.address = NonAnonymousAddressAllocator.getAvailableAddress();
        }
        return this.address;
    }

    private static String getAvailableAddress() {
        try {
            ServerSocket server = new ServerSocket(0);
            String host = InetAddress.getLocalHost().getHostAddress();
            int port = server.getLocalPort();
            server.close();
            return "http://" + host + ":" + port;
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public String createNonAnonymousAddress() {
        return this.getAddress() + "/nonanonymous_" + UUID.randomUUID().toString();
    }
}

