/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.xml.rpc.processor.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;

/**
 *
 * @author JAX-RPC Development Team
 */
public class EnumerationFacet extends ConstrainingFacet {
    
    public EnumerationFacet() {
        super(SchemaConstants.QNAME_ENUMERATION);
    }
    
    public void addValue(String s) {
        values.add(s);
    }
    
    public Iterator values() {
        return values.iterator();
    }
    
    public void addPrefix(String prefix, String nspace) {
        prefixes.put(prefix, nspace);
    }
    
    public String getNamespaceURI(String prefix) {
        return (String)prefixes.get(prefix);
    }
    
    public Map getPrefixes() {
        return prefixes;
    }
    
    private List values = new ArrayList();
    private Map prefixes = new HashMap();
}
