/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.StubTieGeneratorBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.HeaderFault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttachmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.tools.plugin.ToolPluginFactory;
import com.sun.xml.rpc.tools.wscompile.TieHooksIf;
import com.sun.xml.rpc.util.VersionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class TieGenerator
extends StubTieGeneratorBase {
    private Set operationNames;
    private Set soapActionValues;
    private boolean hasUniqueOperationNames;
    private boolean hasUniqueSoapActions;
    private String dirPath = "";
    private String sourceVersion;

    public TieGenerator() {
    }

    public TieGenerator(SOAPVersion ver) {
        super(ver);
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new TieGenerator(model, config, properties);
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new TieGenerator(model, config, properties);
    }

    private TieGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
        String key = "sourceDirectory";
        this.dirPath = properties.getProperty(key);
        key = "sourceVersion";
        this.sourceVersion = properties.getProperty(key);
    }

    private TieGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        super(model, config, properties, ver);
        String key = "sourceDirectory";
        this.dirPath = properties.getProperty(key);
        key = "sourceVersion";
        this.sourceVersion = properties.getProperty(key);
    }

    @Override
    protected String getClassName() {
        return this.env.getNames().tieFor(this.port);
    }

    @Override
    protected String getStateType() {
        return "StreamingHandlerState";
    }

    @Override
    protected Message getMessageToDeserialize(Operation operation) {
        Request message = operation.getRequest();
        if (message.getBodyBlockCount() > 1) {
            TieGenerator.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
        }
        return message;
    }

    @Override
    protected String getStateGetRequestResponseString() {
        return "getRequest";
    }

    @Override
    protected String getInitializeAccess() {
        return "private";
    }

    @Override
    protected boolean superClassHasInitialize() {
        return false;
    }

    @Override
    protected void writeImports(IndentingWriter p) throws IOException {
        super.writeImports(p);
        p.pln("import com.sun.xml.rpc.server.*;");
        p.pln("import javax.xml.rpc.handler.HandlerInfo;");
        p.pln("import com.sun.xml.rpc.client.HandlerChainImpl;");
    }

    @Override
    protected void preVisitPort(Port port) throws Exception {
        super.preVisitPort(port);
        this.operationNames = new HashSet();
        this.soapActionValues = new HashSet();
        this.hasUniqueOperationNames = true;
        this.hasUniqueSoapActions = true;
    }

    @Override
    protected void postVisitPort(Port port) throws Exception {
        this.operationNames = null;
        this.soapActionValues = null;
        super.postVisitPort(port);
    }

    @Override
    protected void preVisitOperation(Operation operation) throws Exception {
        String name = operation.getName().getLocalPart();
        if (this.operationNames.contains(name)) {
            this.hasUniqueOperationNames = false;
        }
        this.operationNames.add(name);
        if (operation.getSOAPAction() != null) {
            if (this.soapActionValues.contains(operation.getSOAPAction())) {
                this.hasUniqueSoapActions = false;
            }
            this.soapActionValues.add(operation.getSOAPAction());
        } else {
            this.hasUniqueSoapActions = false;
        }
    }

    @Override
    protected void writeClassDecl(IndentingWriter p, String tieClassName) throws IOException {
        File classFile = this.env.getNames().sourceFileForClass(tieClassName, tieClassName, new File(this.dirPath), this.env);
        GeneratedFileInfo fi = new GeneratedFileInfo();
        fi.setFile(classFile);
        fi.setType("Tie");
        this.env.addGeneratedFile(fi);
        p.plnI("public class " + Names.stripQualifier(tieClassName));
        p.pln("extends com.sun.xml.rpc.server.TieBase implements SerializerConstants {");
        p.pln();
    }

    protected String getSOAPVersion() {
        if (this.port.getSOAPVersion().equals(SOAPVersion.SOAP_11.toString())) {
            return " SOAPVersion.SOAP_11";
        }
        return " SOAPVersion.SOAP_12";
    }

    @Override
    protected void writeConstructor(IndentingWriter p, String tieClassName) throws IOException {
        JavaInterface intf = this.service.getJavaInterface();
        String serializerRegistryName = this.env.getNames().serializerRegistryClassName(intf);
        p.plnI("public " + Names.stripQualifier(tieClassName) + "() throws Exception {");
        p.pln("super(new " + serializerRegistryName + "().getRegistry());");
        p.pln("initialize(internalTypeMappingRegistry);");
        this.writeHandlerInfo(p);
        p.pOln("}");
    }

    private void writeHandlerInfo(IndentingWriter p) throws IOException {
        HandlerChainInfo portServiceHandlers = this.port.getServerHandlerChainInfo();
        Iterator eachHandler = portServiceHandlers.getHandlers();
        if (eachHandler.hasNext()) {
            p.pln();
            p.plnI("{");
            p.pln("java.util.List handlerInfos = new java.util.Vector();");
            while (eachHandler.hasNext()) {
                HandlerInfo currentHandler = (HandlerInfo)eachHandler.next();
                Map properties = currentHandler.getProperties();
                String propertiesName = "props";
                p.plnI("{");
                p.pln("java.util.Map " + propertiesName + " = new java.util.HashMap();");
                for (Map.Entry entry : properties.entrySet()) {
                    p.pln(propertiesName + ".put(\"" + (String)entry.getKey() + "\", \"" + (String)entry.getValue() + "\");");
                }
                Object[] headers = currentHandler.getHeaderNames().toArray();
                if (headers != null && headers.length > 0) {
                    p.plnI("QName[] headers = {");
                    for (int i = 0; i < headers.length; ++i) {
                        QName hdr = (QName)headers[i];
                        p.pln("new QName(\"" + hdr.getNamespaceURI() + "\"" + ", " + "\"" + hdr.getLocalPart() + "\"" + ")" + (i != headers.length - 1 ? "," : ""));
                    }
                    p.pOln("};");
                } else {
                    p.pln("QName[] headers = null;");
                }
                p.pln("HandlerInfo handlerInfo = new HandlerInfo(" + currentHandler.getHandlerClassName() + ".class" + ", " + propertiesName + ", headers);");
                p.pln("handlerInfos.add(handlerInfo);");
                p.pOln("}");
            }
            Set roles = portServiceHandlers.getRoles();
            p.p("java.lang.String[] roles = new java.lang.String[] {");
            boolean first = true;
            Iterator i = roles.iterator();
            while (i.hasNext()) {
                if (!first) {
                    p.p(", ");
                } else {
                    first = false;
                }
                p.p("\"" + i.next() + "\"");
            }
            p.pln("};");
            p.pln("handlerChain = new HandlerChainImpl(handlerInfos);");
            p.pln("handlerChain.setRoles(roles);");
            p.pln("handlerChain.addUnderstoodHeaders(getUnderstoodHeaders());");
            p.pOln("}");
        }
    }

    @Override
    protected void writePeekFirstBodyElementMethod(IndentingWriter p) throws IOException {
        boolean useSoapActionDispatching;
        boolean useOperationNameDispatching = this.hasUniqueOperationNames;
        boolean bl = useSoapActionDispatching = !useOperationNameDispatching && this.hasUniqueSoapActions;
        if (!useOperationNameDispatching && !useSoapActionDispatching) {
            throw new GeneratorException("generator.tie.port.cannot.dispatch", this.port.getName().getLocalPart());
        }
        p.pln("/*");
        p.pln(" * This method must determine the opcode of the operation that has been invoked.");
        p.pln(" */");
        p.plnI("protected void peekFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingHandlerState state) throws Exception {");
        if (useSoapActionDispatching) {
            p.pln("java.lang.String soapaction = null;");
            p.pln("java.lang.String[] soapactionheaders = state.getMessageContext().getMessage().getMimeHeaders().getHeader(\"SOAPAction\");");
            p.plnI("if (soapactionheaders.length > 0) {");
            p.pln("soapaction = soapactionheaders[0];");
            p.pOlnI("} else {");
            p.pln("throw new SOAPProtocolViolationException(\"soap.request.missing.soapaction.cannot.dispatch\");");
            p.pOln("}");
        }
        Iterator operationsIter = this.operations.iterator();
        Operation operationWithEmptyBody = null;
        int j = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            if (useOperationNameDispatching) {
                boolean hasEmptyBody;
                Request message = operation.getRequest();
                boolean bl2 = hasEmptyBody = message.getBodyBlockCount() == 0;
                if (hasEmptyBody) {
                    if (operationWithEmptyBody != null) {
                        TieGenerator.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
                    } else {
                        operationWithEmptyBody = operation;
                    }
                }
                if (message.getBodyBlockCount() > 1) {
                    TieGenerator.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
                }
                if (hasEmptyBody) continue;
                Block bodyBlock = (Block)message.getBodyBlocks().next();
                if (j++ > 0) {
                    p.p("else ");
                }
                p.plnI("if (bodyReader.getName().equals(" + this.env.getNames().getBlockQNameName(operation, bodyBlock) + ")) {");
                if (operation.isOverloaded()) {
                    p.pln("throw new SOAPProtocolViolationException(\"soap.operation.cannot.dispatch\", \"" + operation.getName().getLocalPart() + "\");");
                } else {
                    p.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
                }
                p.pOln("}");
                continue;
            }
            if (!useSoapActionDispatching) continue;
            if (j++ > 0) {
                p.p("else ");
            }
            p.plnI("if (soapaction.equals(\"\\\"" + operation.getSOAPAction() + "\\\"\")) {");
            p.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
            p.pOln("}");
        }
        if (j > 0) {
            p.plnI("else {");
        }
        p.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", bodyReader.getName().toString());");
        if (j > 0) {
            p.pOln("}");
        }
        p.pOln("}");
    }

    @Override
    protected void writeUsesSOAPActionForDispatching(IndentingWriter p) throws IOException {
        boolean useSoapActionDispatching;
        boolean useOperationNameDispatching = this.hasUniqueOperationNames;
        boolean bl = useSoapActionDispatching = !useOperationNameDispatching && this.hasUniqueSoapActions;
        if (useSoapActionDispatching) {
            p.plnI("public boolean usesSOAPActionForDispatching() {");
            p.pln("return true;");
            p.pOln("}");
            p.pln();
        }
    }

    @Override
    protected void writeGetOpcodeForFirstBodyElementName(IndentingWriter p) throws IOException {
        boolean useOperationNameDispatching = this.hasUniqueOperationNames;
        if (useOperationNameDispatching) {
            p.pln("/*");
            p.pln(" * This method must determine the opcode of the operation given the QName of the first body element.");
            p.pln(" */");
            p.plnI("public int getOpcodeForFirstBodyElementName(QName name) {");
            Iterator operationsIter = this.operations.iterator();
            Operation operationWithEmptyBody = null;
            int j = 0;
            while (operationsIter.hasNext()) {
                boolean hasEmptyBody;
                Operation operation = (Operation)operationsIter.next();
                Request message = operation.getRequest();
                boolean bl = hasEmptyBody = message.getBodyBlockCount() == 0;
                if (hasEmptyBody) {
                    if (operationWithEmptyBody != null) {
                        TieGenerator.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
                    } else {
                        operationWithEmptyBody = operation;
                    }
                }
                if (message.getBodyBlockCount() > 1) {
                    TieGenerator.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
                }
                if (j == 0) {
                    p.plnI("if (name == null) {");
                    p.pln("return InternalSOAPMessage.NO_OPERATION;");
                    p.pOln("}");
                }
                if (!hasEmptyBody) {
                    Block bodyBlock = (Block)message.getBodyBlocks().next();
                    p.plnI("if (name.equals(" + this.env.getNames().getBlockQNameName(operation, bodyBlock) + ")) {");
                    if (operation.isOverloaded()) {
                        p.pln("return InternalSOAPMessage.NO_OPERATION;");
                    } else {
                        p.pln("return " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ";");
                    }
                    p.pOln("}");
                }
                ++j;
            }
            p.pln("return super.getOpcodeForFirstBodyElementName(name);");
            p.pOln("}");
        }
    }

    @Override
    protected void writeGetOpcodeForSOAPAction(IndentingWriter p) throws IOException {
        boolean useSoapActionDispatching;
        boolean useOperationNameDispatching = this.hasUniqueOperationNames;
        boolean bl = useSoapActionDispatching = !useOperationNameDispatching && this.hasUniqueSoapActions;
        if (useSoapActionDispatching) {
            p.pln("/*");
            p.pln(" * This method must determine the opcode of the operation given the SOAPAction string.");
            p.pln(" */");
            p.plnI("public int getOpcodeForSOAPAction(java.lang.String action) {");
            Iterator operationsIter = this.operations.iterator();
            Object operationWithEmptyBody = null;
            int j = 0;
            while (operationsIter.hasNext()) {
                Operation operation = (Operation)operationsIter.next();
                if (j++ == 0) {
                    p.plnI("if (action == null) {");
                    p.pln("return InternalSOAPMessage.NO_OPERATION;");
                    p.pOln("}");
                }
                p.plnI("if (action.equals(\"\\\"" + operation.getSOAPAction() + "\\\"\")) {");
                p.pln("return " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ";");
                p.pOln("}");
            }
            p.pln("return super.getOpcodeForSOAPAction(action);");
            p.pOln("}");
        }
    }

    @Override
    protected void writeGetMethodForOpcode(IndentingWriter p) throws IOException, ClassNotFoundException {
        Object theMethods = null;
        p.plnI("private Method internalGetMethodForOpcode(int opcode) throws ClassNotFoundException, NoSuchMethodException {");
        p.pln();
        p.pln("Method theMethod = null;");
        p.pln();
        p.plnI("switch(opcode) {");
        Iterator operationsIter = this.operations.iterator();
        String str = "";
        String ops = "";
        int j = 0;
        Operation operationWithEmptyBody = null;
        j = 0;
        while (operationsIter.hasNext()) {
            boolean hasEmptyBody;
            Operation operation = (Operation)operationsIter.next();
            Request message = operation.getRequest();
            boolean bl = hasEmptyBody = message.getBodyBlockCount() == 0;
            if (hasEmptyBody) {
                if (operationWithEmptyBody != null) {
                    TieGenerator.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
                } else {
                    operationWithEmptyBody = operation;
                }
            }
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            JavaMethod jvmmethod = operation.getJavaMethod();
            Iterator ite = jvmmethod.getParameters();
            int i = 0;
            String data = "";
            p.plnI("{");
            p.p("Class[] carray = { ");
            while (ite.hasNext()) {
                JavaParameter astr = (JavaParameter)ite.next();
                str = astr.getType().getName();
                data = "";
                if (i != 0) {
                    p.p(",");
                }
                try {
                    if (astr.isHolder()) {
                        if (astr.getHolderName() == null) {
                            p.p(this.env.getNames().holderClassName(this.port, astr.getType()) + ".class");
                        } else {
                            p.p(astr.getHolderName() + ".class");
                        }
                    } else if (str.indexOf("[") > 0) {
                        int counter;
                        int end = str.lastIndexOf("]");
                        int range = (end - str.indexOf("[")) / 2;
                        if (GeneratorUtil.ht.containsKey(str)) {
                            for (counter = 0; counter <= range; ++counter) {
                                data = data + "[";
                            }
                            data = data + (String)GeneratorUtil.ht.get(str);
                            p.p("Class.forName(\"" + data + "\")");
                        } else {
                            for (counter = 0; counter <= range; ++counter) {
                                data = data + "[";
                            }
                            data = data + "L" + str.substring(0, str.indexOf("[")) + ";";
                            p.p("Class.forName(\"" + data + "\")");
                        }
                    } else if (GeneratorUtil.ht.containsKey(str)) {
                        p.p(GeneratorUtil.ht.get(str));
                    } else {
                        p.p(str + ".class");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            JavaInterface intf = this.port.getJavaInterface();
            p.pln(" };");
            p.pln("theMethod = (" + intf.getName() + ".class).getMethod(\"" + jvmmethod.getName() + "\", carray);");
            p.pOln("}");
            p.pln("break;");
            p.pOln("");
            ++j;
        }
        p.pln("default:");
        p.pOln("}");
        p.pln("return theMethod;");
        p.pOln("}");
        p.pln();
        p.pln("private Method[] methodMap = new Method[" + j + "];");
        p.pln();
        p.pln("/*");
        p.pln(" * This method returns the Method Obj for a specified opcode.");
        p.pln(" */");
        p.plnI("public Method getMethodForOpcode(int opcode) throws ClassNotFoundException, NoSuchMethodException {");
        p.pln(" ");
        p.plnI("if (opcode <= InternalSOAPMessage.NO_OPERATION ) {");
        p.pln("return null;");
        p.pOln("}");
        p.pln(" ");
        p.plnI("if (opcode >= " + j + " ) {");
        p.pln("return null;");
        p.pOln("}");
        p.pln(" ");
        p.plnI("if (methodMap[opcode] == null)  {");
        p.pln("methodMap[opcode] = internalGetMethodForOpcode(opcode);");
        p.pOln("}");
        p.pln(" ");
        p.pln("return methodMap[opcode];");
        p.pOln("}");
    }

    @Override
    protected void writeHandleEmptyBody(IndentingWriter p, Operation operation) throws IOException {
        p.pln("/*");
        p.pln(" * This method handles the case of an empty SOAP body.");
        p.pln(" */");
        p.plnI("protected void handleEmptyBody(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingHandlerState state) throws Exception {");
        p.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        p.pOln("}");
    }

    @Override
    protected void writeProcessingHookMethod(IndentingWriter p) throws IOException {
        p.pln("/*");
        p.pln(" * This method must invoke the correct method on the servant based on the opcode.");
        p.pln(" */");
        p.plnI("protected void processingHook(StreamingHandlerState state) throws Exception {");
        Iterator operationsIter = this.operations.iterator();
        p.plnI("switch (state.getRequest().getOperationCode()) {");
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln("invoke_" + this.env.getNames().validInternalJavaIdentifier(operation.getUniqueName()) + "(state);");
            p.pln("break;");
            p.pO();
        }
        p.plnI("default:");
        p.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", java.lang.Integer.toString(state.getRequest().getOperationCode()));");
        p.pO();
        p.pOln("}");
        p.pOln("}");
    }

    protected String getFaultCodeServer() {
        if (this.port.getSOAPVersion().equals(SOAPVersion.SOAP_12.toString())) {
            return "com.sun.xml.rpc.encoding.soap.SOAP12Constants.FAULT_CODE_SERVER";
        }
        return "com.sun.xml.rpc.encoding.soap.SOAPConstants.FAULT_CODE_SERVER";
    }

    protected String getQNameSOAPFault() {
        if (this.port.getSOAPVersion().equals(SOAPVersion.SOAP_12)) {
            return "com.sun.xml.rpc.encoding.soap.SOAP12Constants.QNAME_SOAP_FAULT";
        }
        return "com.sun.xml.rpc.encoding.soap.SOAPConstants.QNAME_SOAP_FAULT";
    }

    @Override
    protected void writeRpcEncodedOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException {
        String messageName = operation.getName().getLocalPart();
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        String requestObjType = null;
        String requestObjName = null;
        SOAPType requestBlockType = null;
        Request message = operation.getRequest();
        Iterator iterator = message.getBodyBlocks();
        Block requestBlock = null;
        String requestObjInit = null;
        while (iterator.hasNext()) {
            requestBlock = (Block)iterator.next();
            if (!requestBlock.getName().getLocalPart().equals(messageName)) continue;
            requestBlockType = (SOAPType)requestBlock.getType();
            requestObjType = requestBlockType.getJavaType().getName();
            requestObjInit = requestBlockType.getJavaType().getInitString();
            requestObjName = this.env.getNames().getTypeMemberName(requestBlockType.getJavaType());
            break;
        }
        this.writeInvokeMethodDecl(p, operation);
        if (operation.getResponse() == null) {
            p.pln("flushHttpResponse(state);");
        }
        this.declareRequestObjects(p, requestObjType, requestObjName, requestObjInit);
        this.declareHolderHeaderObjects(p, requestBlock, operation);
        boolean hasRequestHeaders = false;
        iterator = operation.getRequest().getHeaderBlocks();
        hasRequestHeaders = iterator.hasNext();
        if (hasRequestHeaders) {
            this.writeRequestHeaders(p, operation);
        }
        p.plnI("try {");
        this.declareRpcReturnType(p, operation, resultType);
        if (javaMethod.getDeclaringClass() != null) {
            p.p("((" + javaMethod.getDeclaringClass().replace('$', '.') + ") getTarget())." + javaMethod.getName() + "(");
        } else {
            p.p("((" + remoteClassName + ") getTarget())." + javaMethod.getName() + "(");
        }
        if (resultType != null && !resultType.getName().equals("void")) {
            p.pO();
        }
        iterator = javaMethod.getParameters();
        message = operation.getRequest();
        int i = 0;
        while (iterator.hasNext()) {
            JavaParameter javaParameter;
            Parameter parameter;
            Block paramBlock;
            if (i > 0) {
                p.p(", ");
            }
            if ((paramBlock = (parameter = (javaParameter = (JavaParameter)iterator.next()).getParameter()).getBlock()).getLocation() != 1) {
                if (javaParameter.isHolder()) {
                    p.p(javaParameter.getParameter().getName() + "_holder");
                } else {
                    p.p(parameter.getName());
                }
            } else {
                JavaType javaObjType = paramBlock.getType().getJavaType();
                String javaObjName = this.env.getNames().getTypeMemberName(javaObjType);
                JavaStructureMember javaMember = TieGenerator.getJavaMember(parameter);
                if (javaParameter.isHolder()) {
                    p.p(javaParameter.getParameter().getName() + "_holder");
                } else if (javaMember.isPublic()) {
                    p.p(javaObjName + "." + parameter.getName());
                } else {
                    p.p(javaObjName + "." + javaMember.getReadMethod() + "()");
                }
            }
            ++i;
        }
        p.pln(");");
        if (operation.getResponse() != null) {
            this.declareRpcResponseObject(p, operation);
        }
        this.writeCatchClauses(p, operation);
        p.pOln("}");
        p.pOln("}");
    }

    private void writeCatchClauses(IndentingWriter p, Operation operation) throws IOException {
        TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
        faultSet.addAll(operation.getFaultsSet());
        for (Fault fault : faultSet) {
            p.pOlnI("} catch (" + this.env.getNames().customExceptionClassName(fault) + " e) {");
            p.plnI("SOAPFaultInfo fault = new SOAPFaultInfo(" + this.getFaultCodeServer() + ",");
            p.pln("\"" + this.env.getNames().customExceptionClassName(fault) + "\", null, e);");
            p.pO();
            p.pln("SOAPBlockInfo faultBlock = new SOAPBlockInfo(" + this.getQNameSOAPFault() + ");");
            p.pln("faultBlock.setValue(fault);");
            p.pln("faultBlock.setSerializer(" + this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.servicePackage, this.port, operation)) + ");");
            p.pln("state.getResponse().setBody(faultBlock);");
            p.pln("state.getResponse().setFailure(true);");
            if (!(fault instanceof HeaderFault)) continue;
            p.pln("SOAPHeaderBlockInfo headerInfo;");
            p.pln("headerInfo = new SOAPHeaderBlockInfo(" + this.env.getNames().getQNameName(fault.getBlock().getName()) + ", null, false);");
            p.pln("headerInfo.setValue(e);");
            p.pln("headerInfo.setSerializer(" + this.writerFactory.createWriter(this.servicePackage, fault.getBlock().getType()).serializerMemberName() + ");");
            p.pln("state.getResponse().add(headerInfo);");
        }
        p.pOlnI("} catch (javax.xml.rpc.soap.SOAPFaultException e) {");
        p.plnI("SOAPFaultInfo fault = new SOAPFaultInfo(e.getFaultCode(),");
        p.pln("e.getFaultString(), e.getFaultActor(), e.getDetail());");
        p.pO();
        p.pln("SOAPBlockInfo faultBlock = new SOAPBlockInfo(" + this.getQNameSOAPFault() + ");");
        p.pln("faultBlock.setValue(fault);");
        p.pln("faultBlock.setSerializer(new SOAPFaultInfoSerializer(false, e.getDetail()==null));");
        p.pln("state.getResponse().setBody(faultBlock);");
        p.pln("state.getResponse().setFailure(true);");
    }

    private void writeInvokeMethodDecl(IndentingWriter p, Operation operation) throws IOException {
        String messageName = operation.getName().getLocalPart();
        p.pln("/*");
        p.pln(" * This method does the actual method invocation for operation: " + messageName);
        p.pln(" */");
        p.plnI("private void invoke_" + this.env.getNames().validInternalJavaIdentifier(operation.getUniqueName()) + "(StreamingHandlerState state) throws Exception {");
        p.pln();
    }

    private void declareRequestObjects(IndentingWriter p, String requestObjType, String requestObjName, String requestObjInit) throws IOException {
        if (requestObjType != null && requestObjName != null) {
            String boxName;
            String requestObjMemberName = requestObjName + "Obj";
            p.pln(requestObjType + " " + requestObjName + " = " + requestObjInit + ";");
            p.plnI("Object " + requestObjMemberName + " =");
            p.pln("state.getRequest().getBody().getValue();");
            p.pO();
            p.pln();
            p.plnI("if (" + requestObjMemberName + " instanceof SOAPDeserializationState) {");
            String valueStr = "((SOAPDeserializationState)" + requestObjMemberName + ").getInstance()";
            if (SimpleToBoxedUtil.isPrimitive(requestObjType)) {
                boxName = SimpleToBoxedUtil.getBoxedClassName(requestObjType);
                valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + valueStr, requestObjType);
            } else {
                valueStr = "(" + requestObjType + ")" + valueStr;
            }
            p.pln(requestObjName + " = " + valueStr + ";");
            p.pOlnI("} else {");
            valueStr = requestObjMemberName;
            if (SimpleToBoxedUtil.isPrimitive(requestObjType)) {
                boxName = SimpleToBoxedUtil.getBoxedClassName(requestObjType);
                valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + valueStr, requestObjType);
            } else {
                valueStr = "(" + requestObjType + ")" + valueStr;
            }
            p.pln(requestObjName + " = " + valueStr + ";");
            p.pOln("}");
            p.pln();
        }
    }

    private void declareHolderHeaderObjects(IndentingWriter p, Block requestBlock, Operation operation) throws IOException {
        if (requestBlock != null) {
            AbstractType requestBlockType = requestBlock.getType();
            String requestObjType = requestBlockType.getJavaType().getName();
            String requestObjName = this.env.getNames().getTypeMemberName(requestBlockType.getJavaType());
            String requestObjMemberName = requestObjName + "Obj";
            JavaMethod javaMethod = operation.getJavaMethod();
            Iterator iterator = javaMethod.getParameters();
            boolean declaredHeaderObj = false;
            boolean declaredAttachmentObj = false;
            boolean i = false;
            while (iterator.hasNext()) {
                JavaParameter javaParameter = (JavaParameter)iterator.next();
                if (javaParameter.isHolder()) {
                    String holderClassName = javaParameter.getHolderName() != null ? javaParameter.getHolderName() : this.env.getNames().holderClassName(this.port, javaParameter.getType());
                    p.plnI(holderClassName + " " + javaParameter.getParameter().getName() + "_holder =");
                    p.pln("new " + holderClassName + "();");
                    p.pO();
                    if (javaParameter.getParameter().getLinkedParameter() != null && javaParameter.getParameter().getBlock().getLocation() != 2) {
                        JavaStructureMember javaMember = TieGenerator.getJavaMember(javaParameter.getParameter());
                        if (javaMember != null && javaMember.getType() instanceof JavaStructureType && ((JavaStructureType)javaMember.getType()).getOwner() instanceof LiteralArrayWrapperType) {
                            LiteralArrayWrapperType owner = (LiteralArrayWrapperType)((JavaStructureType)javaMember.getType()).getOwner();
                            JavaStructureMember tmpMember = (JavaStructureMember)((JavaStructureType)owner.getJavaType()).getMembers().next();
                            p.plnI(javaParameter.getParameter().getName() + "_holder.value = ");
                            p.pln("(" + requestObjName + "." + javaMember.getReadMethod() + "() != null) ?");
                            p.pln(requestObjName + "." + javaMember.getReadMethod() + "()." + tmpMember.getReadMethod() + "() : null;");
                            p.pO();
                            continue;
                        }
                        if (javaParameter.getParameter().getBlock().getLocation() == 3) continue;
                        p.pln(javaParameter.getParameter().getName() + "_holder.value = " + requestObjName + "." + javaMember.getReadMethod() + "();");
                        continue;
                    }
                    if (javaParameter.getParameter().getBlock().getLocation() != 2 || declaredHeaderObj) continue;
                    p.pln("Object _headerObj;");
                    declaredHeaderObj = true;
                    continue;
                }
                if (javaParameter.getParameter().getBlock().getLocation() != 2) continue;
                if (!declaredHeaderObj) {
                    p.pln("Object _headerObj;");
                    declaredHeaderObj = true;
                }
                AbstractType paramType = javaParameter.getParameter().getType();
                String initValue = javaParameter.getType().getInitString();
                p.pln(paramType.getJavaType().getName() + " " + javaParameter.getParameter().getName() + " = " + initValue + ";");
            }
        } else {
            JavaMethod javaMethod = operation.getJavaMethod();
            Iterator iterator = javaMethod.getParameters();
            while (iterator.hasNext()) {
                JavaParameter javaParameter = (JavaParameter)iterator.next();
                if (!javaParameter.isHolder()) continue;
                String holderClassName = javaParameter.getHolderName() != null ? javaParameter.getHolderName() : this.env.getNames().holderClassName(this.port, javaParameter.getType());
                p.plnI(holderClassName + " " + javaParameter.getParameter().getName() + "_holder =");
                p.pln("new " + holderClassName + "();");
                p.pO();
            }
        }
    }

    private boolean declareRpcReturnType(IndentingWriter p, Operation operation, JavaType resultType) throws IOException {
        Response message = operation.getResponse();
        if (message == null) {
            return false;
        }
        Iterator iterator = message.getBodyBlocks();
        if (resultType != null && !resultType.getName().equals("void") && (iterator = message.getParameters()).hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            String resultName = resultType instanceof JavaStructureType && ((JavaStructureType)resultType).getOwner() instanceof LiteralArrayWrapperType ? ((LiteralArrayWrapperType)((JavaStructureType)resultType).getOwner()).getJavaArrayType().getName() : resultType.getName();
            p.plnI(resultName + " " + parameter.getName() + " = ");
            return true;
        }
        return false;
    }

    private void writeRequestHeaders(IndentingWriter p, Operation operation) throws IOException {
        p.pln("Iterator headers = state.getRequest().headers();");
        p.pln("SOAPHeaderBlockInfo curHeader;");
        p.plnI("while (headers.hasNext()) {");
        p.pln("curHeader = (SOAPHeaderBlockInfo)headers.next();");
        Iterator iterator = operation.getRequest().getParameters();
        boolean startedHeaders = false;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getBlock().getLocation() != 2) continue;
            if (startedHeaders) {
                p.p(" else ");
            }
            startedHeaders = true;
            String paramName = parameter.getName();
            String paramType = parameter.getType().getJavaType().getName();
            String varName = null;
            varName = parameter.getJavaParameter() != null && parameter.getJavaParameter().isHolder() ? paramName + "_holder.value" : paramName;
            String qname = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
            p.plnI("if (curHeader.getName().equals(" + qname + ")) {");
            p.pln("_headerObj = (" + paramType + ")curHeader.getValue();");
            p.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
            p.pln(varName + " = (" + paramType + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
            p.pOlnI("} else {");
            p.pln(varName + " = (" + paramType + ")_headerObj;");
            p.pOln("}");
            p.pO("}");
        }
        if (startedHeaders) {
            p.pln();
        }
        p.pOln("}");
        p.pln();
    }

    private void declareRpcResponseObject(IndentingWriter p, Operation operation) throws IOException {
        String messageName = operation.getName().getLocalPart();
        Response message = operation.getResponse();
        if (message == null) {
            return;
        }
        Iterator iterator = message.getBodyBlocks();
        Block responseBlock = null;
        SOAPType responseBlockType = null;
        String responseObjType = null;
        String responseObjName = null;
        while (iterator.hasNext()) {
            responseBlock = (Block)iterator.next();
            if (responseBlock.getName().getLocalPart().equals(messageName + "Response")) {
                responseBlockType = (SOAPType)responseBlock.getType();
                responseObjType = responseBlockType.getJavaType().getName();
                responseObjName = this.env.getNames().getTypeMemberName(responseBlockType.getJavaType());
                break;
            }
            responseBlock = null;
        }
        p.plnI(responseObjType + " " + responseObjName + " =");
        p.pln("new " + responseObjType + "();");
        p.pO();
        message = operation.getResponse();
        Iterator iterator2 = message.getParameters();
        p.pln("SOAPHeaderBlockInfo headerInfo;");
        int i = 0;
        while (iterator2.hasNext()) {
            String memberName;
            JavaParameter javaParameter;
            Parameter parameter = (Parameter)iterator2.next();
            Block block = parameter.getBlock();
            if (block.getLocation() == 1) {
                JavaStructureMember javaMember = TieGenerator.getJavaMember(parameter);
                javaParameter = parameter.getJavaParameter();
                memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                if (javaMember != null) {
                    if (javaMember.isPublic()) {
                        p.pln(responseObjName + "." + javaMember.getName() + " = " + memberName + ";");
                    } else {
                        p.pln(responseObjName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
                    }
                }
            } else {
                javaParameter = parameter.getJavaParameter();
                String qname = this.env.getNames().getBlockQNameName(null, block);
                memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                p.pln("headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
                p.pln("headerInfo.setValue(" + memberName + ");");
                p.pln("headerInfo.setSerializer(" + this.writerFactory.createWriter(this.servicePackage, (SOAPType)block.getType()).serializerMemberName() + ");");
                p.pln("state.getResponse().add(headerInfo);");
            }
            ++i;
        }
        p.pln();
        p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, responseBlock) + ");");
        p.pln("bodyBlock.setValue(" + responseObjName + ");");
        p.pln("bodyBlock.setSerializer(" + this.writerFactory.createWriter(this.servicePackage, responseBlockType).serializerMemberName() + ");");
        p.pln("state.getResponse().setBody(bodyBlock);");
    }

    @Override
    protected void writeRpcLiteralOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException {
        JavaStructureMember javaMember;
        JavaParameter javaParameter;
        Parameter parameter;
        String messageName = operation.getName().getLocalPart();
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        String requestObjType = null;
        String requestObjName = null;
        String responseObjType = null;
        String responseObjName = null;
        LiteralType responseBlockType = null;
        LiteralType requestBlockType = null;
        Block responseBlock = null;
        Request requestMessage = operation.getRequest();
        int headerParameterCount = 0;
        int attachmentParameterCount = 0;
        Iterator iterator = requestMessage.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            Block paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) continue;
            if (paramBlock.getLocation() == 2) {
                ++headerParameterCount;
                continue;
            }
            if (paramBlock.getLocation() != 3) continue;
            ++attachmentParameterCount;
        }
        iterator = requestMessage.getBodyBlocks();
        Block requestBlock = null;
        String requestObjInit = null;
        if (iterator.hasNext()) {
            requestBlock = (Block)iterator.next();
            requestBlockType = (LiteralType)requestBlock.getType();
            requestObjType = requestBlockType.getJavaType().getName();
            requestObjInit = requestBlockType.getJavaType().getInitString();
            requestObjName = this.env.getNames().getTypeMemberName(requestBlockType.getJavaType());
        }
        this.writeInvokeMethodDecl(p, operation);
        if (operation.getResponse() == null) {
            p.pln("flushHttpResponse(state);");
        }
        this.declareRequestObjects(p, requestObjType, requestObjName, requestObjInit);
        this.declareHolderHeaderObjects(p, requestBlock, operation);
        boolean hasRequestHeaders = false;
        iterator = operation.getRequest().getHeaderBlocks();
        hasRequestHeaders = iterator.hasNext();
        if (hasRequestHeaders) {
            this.writeRequestHeaders(p, operation);
        }
        this.declareHolderAttachmentObjects(p, requestBlock, operation);
        p.plnI("try {");
        Response message = operation.getResponse();
        boolean resultIsEmbedded = false;
        if (message != null) {
            iterator = message.getBodyBlocks();
            if (iterator.hasNext()) {
                responseBlock = (Block)iterator.next();
                responseBlockType = (LiteralType)responseBlock.getType();
                responseObjType = responseBlockType.getJavaType().getName();
                responseObjName = "_response";
            }
            resultIsEmbedded = false;
            if (resultType != null && !resultType.getName().equals("void")) {
                iterator = message.getParameters();
                if (iterator.hasNext()) {
                    parameter = (Parameter)iterator.next();
                    p.p(responseObjType + " " + responseObjName + " = new ");
                    p.pln(responseObjType + "();");
                }
            } else if ((resultType == null || resultType.getName().equals("void")) && responseBlock != null) {
                resultIsEmbedded = true;
            }
        }
        boolean declaredResult = this.declareRpcReturnType(p, operation, resultType);
        p.p("((" + remoteClassName + ") getTarget())." + operation.getJavaMethod().getName() + "(");
        boolean hasBodyParams = false;
        int count = 0;
        iterator = javaMethod.getParameters();
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            parameter = javaParameter.getParameter();
            if (parameter.getBlock().getLocation() == 1) {
                hasBodyParams = true;
                javaMember = TieGenerator.getJavaMember(parameter);
                if (count > 0) {
                    p.p(", ");
                }
                String unWrapMethod = "";
                if (parameter.getType() instanceof LiteralArrayWrapperType) {
                    JavaStructureMember tmpJMember = (JavaStructureMember)((JavaStructureType)((LiteralArrayWrapperType)parameter.getType()).getJavaType()).getMembers().next();
                    unWrapMethod = ".toArray()";
                }
                if (parameter.getJavaParameter().isHolder()) {
                    p.p(parameter.getName() + "_holder");
                } else if (javaMember.isPublic()) {
                    p.p(requestObjName + "." + parameter.getName() + unWrapMethod);
                } else {
                    p.p(requestObjName + "." + javaMember.getReadMethod() + "()" + unWrapMethod);
                }
            } else if (parameter.getBlock().getLocation() == 3) {
                if (count > 0) {
                    p.p(", ");
                }
                if ((javaParameter = parameter.getJavaParameter()).isHolder()) {
                    p.p(parameter.getName() + "_holder");
                } else {
                    p.p(parameter.getName());
                }
            }
            ++count;
        }
        count = 0;
        if (headerParameterCount > 0) {
            iterator = requestMessage.getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (!parameter.getJavaParameter().isHolder() && parameter.getBlock().getLocation() == 2) {
                    if (hasBodyParams || count > 0) {
                        p.p(", ");
                    }
                    p.p(parameter.getName());
                }
                ++count;
            }
        }
        if (operation.getResponse() != null) {
            iterator = operation.getResponse().getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 2) continue;
                p.p(", ");
                javaParameter = parameter.getJavaParameter();
                if (javaParameter.isHolder()) {
                    p.p(parameter.getName() + "_holder");
                    continue;
                }
                p.p(parameter.getName());
            }
        }
        p.pln(");");
        if (declaredResult) {
            p.pO();
        }
        p.pln();
        if (operation.getResponse() != null) {
            p.pln("SOAPHeaderBlockInfo headerInfo;");
            if (resultIsEmbedded) {
                p.pln(responseObjType + " " + responseObjName + " = new " + responseObjType + "();");
                iterator = message.getParameters();
                if (iterator.hasNext() && (javaMember = TieGenerator.getJavaMember(parameter = (Parameter)iterator.next())) != null && !parameter.getJavaParameter().isHolder()) {
                    if (javaMember.isPublic()) {
                        p.pln(responseObjName + "." + parameter.getName() + " = _result;");
                    } else {
                        p.pln(responseObjName + "." + javaMember.getWriteMethod() + "(_result);");
                    }
                }
            }
            iterator = operation.getResponse().getParameters();
            while (iterator.hasNext()) {
                String memberName;
                parameter = (Parameter)iterator.next();
                responseBlock = parameter.getBlock();
                if (responseBlock.getLocation() == 1) {
                    javaMember = TieGenerator.getJavaMember(parameter);
                    javaParameter = parameter.getJavaParameter();
                    memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                    if (javaMember != null) {
                        if (parameter.getType() instanceof LiteralArrayWrapperType) {
                            memberName = "new " + parameter.getType().getJavaType().getName() + "(" + memberName + ")";
                        }
                        if (javaMember.isPublic()) {
                            p.pln(responseObjName + "." + javaMember.getName() + " = " + memberName + ";");
                        } else {
                            p.pln(responseObjName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
                        }
                    }
                }
                if (responseBlock.getLocation() != 2) continue;
                javaParameter = parameter.getJavaParameter();
                String qname = this.env.getNames().getBlockQNameName(null, responseBlock);
                memberName = javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                p.pln("headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
                p.pln("headerInfo.setValue(" + memberName + ");");
                p.pln("headerInfo.setSerializer(" + this.writerFactory.createWriter(this.servicePackage, responseBlock.getType()).serializerMemberName() + ");");
                p.pln("state.getResponse().add(headerInfo);");
            }
            p.pln();
            p.pln();
            iterator = operation.getResponse().getBodyBlocks();
            if (iterator.hasNext()) {
                responseBlock = (Block)iterator.next();
                if (responseBlock != null && responseBlock.getLocation() == 1) {
                    p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, responseBlock) + ");");
                    String valueStr = responseObjName;
                    if (SimpleToBoxedUtil.isPrimitive(responseObjType)) {
                        valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, responseObjType);
                    }
                    p.pln("bodyBlock.setValue(" + valueStr + ");");
                    String serializer = this.writerFactory.createWriter(this.servicePackage, responseBlockType).serializerMemberName();
                    p.pln("bodyBlock.setSerializer(" + serializer + ");");
                    p.pln("state.getResponse().setBody(bodyBlock);");
                } else {
                    p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(null);");
                    p.pln("bodyBlock.setSerializer(DummySerializer.getInstance());");
                    p.pln("state.getResponse().setBody(bodyBlock);");
                }
            }
            p.pln();
            this.addAttachmentsToResponse(p, operation.getResponse().getParameters());
        }
        this.writeCatchClauses(p, operation);
        p.pOln("}");
        p.pOln("}");
    }

    @Override
    protected void writeDocumentLiteralOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException {
        JavaParameter javaParameter;
        JavaStructureMember javaMember;
        Parameter parameter;
        String messageName = operation.getName().getLocalPart();
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        String requestObjType = null;
        String requestObjName = null;
        String responseObjType = null;
        String responseObjName = null;
        LiteralType responseBlockType = null;
        LiteralType requestBlockType = null;
        Block responseBlock = null;
        Request requestMessage = operation.getRequest();
        int embeddedParameterCount = 0;
        int nonEmbeddedParameterCount = 0;
        int headerParameterCount = 0;
        int attachmentParameterCount = 0;
        Iterator iterator = requestMessage.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            Block paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) {
                if (parameter.isEmbedded()) {
                    ++embeddedParameterCount;
                    continue;
                }
                ++nonEmbeddedParameterCount;
                continue;
            }
            if (paramBlock.getLocation() == 2) {
                ++headerParameterCount;
                continue;
            }
            if (paramBlock.getLocation() != 3) continue;
            ++attachmentParameterCount;
        }
        if (nonEmbeddedParameterCount > 1 || nonEmbeddedParameterCount > 0 && embeddedParameterCount > 0) {
            throw new GeneratorException("generator.internal.error.should.not.happen", "tie.generator.002");
        }
        iterator = requestMessage.getBodyBlocks();
        Block requestBlock = null;
        String requestObjInit = null;
        if (iterator.hasNext()) {
            requestBlock = (Block)iterator.next();
            requestBlockType = (LiteralType)requestBlock.getType();
            requestObjType = requestBlockType.getJavaType().getName();
            requestObjInit = requestBlockType.getJavaType().getInitString();
            requestObjName = this.env.getNames().getTypeMemberName(requestBlockType.getJavaType());
        }
        this.writeInvokeMethodDecl(p, operation);
        if (operation.getResponse() == null) {
            p.pln("flushHttpResponse(state);");
        }
        this.declareRequestObjects(p, requestObjType, requestObjName, requestObjInit);
        this.declareHolderHeaderObjects(p, requestBlock, operation);
        boolean hasRequestHeaders = false;
        iterator = operation.getRequest().getHeaderBlocks();
        hasRequestHeaders = iterator.hasNext();
        if (hasRequestHeaders) {
            this.writeRequestHeaders(p, operation);
        }
        this.declareHolderAttachmentObjects(p, requestBlock, operation);
        p.plnI("try {");
        Response message = operation.getResponse();
        boolean resultIsEmbedded = false;
        if (message != null) {
            iterator = message.getBodyBlocks();
            if (iterator.hasNext()) {
                responseBlock = (Block)iterator.next();
                responseBlockType = (LiteralType)responseBlock.getType();
                responseObjType = responseBlockType.getJavaType().getName();
                responseObjName = "_response";
            }
            if (resultType != null && !resultType.getName().equals("void")) {
                iterator = message.getParameters();
                if (iterator.hasNext()) {
                    parameter = (Parameter)iterator.next();
                    if (parameter.isEmbedded()) {
                        resultIsEmbedded = true;
                        p.p(resultType.getName() + " " + parameter.getName() + " = ");
                    } else {
                        p.p(resultType.getName() + " " + parameter.getName() + " = ");
                    }
                }
            } else if (resultType == null) {
                resultIsEmbedded = true;
            } else {
                boolean cond;
                boolean bl = cond = VersionUtil.compare(this.sourceVersion, "1.1.1") >= 0;
                if (cond && resultType.getName().equals("void")) {
                    resultIsEmbedded = true;
                }
            }
        }
        p.p("((" + remoteClassName + ") getTarget())." + operation.getJavaMethod().getName() + "(");
        boolean hasBodyParams = false;
        int count = 0;
        Iterator params = operation.getJavaMethod().getParameters();
        while (params.hasNext()) {
            JavaParameter jp = (JavaParameter)params.next();
            Parameter param = jp.getParameter();
            if (param.getBlock().getLocation() == 1) {
                if (param.getBlock() == requestBlock) {
                    if (nonEmbeddedParameterCount > 0) {
                        hasBodyParams = true;
                        if (count > 0) {
                            p.p(", ");
                        }
                        p.p(requestObjName);
                    } else {
                        hasBodyParams = true;
                        javaMember = TieGenerator.getJavaMember(param);
                        if (count > 0) {
                            p.p(", ");
                        }
                        if (javaMember.isPublic()) {
                            p.p(requestObjName + "." + param.getName());
                        } else {
                            p.p(requestObjName + "." + javaMember.getReadMethod() + "()");
                        }
                    }
                } else if (param.getBlock() == responseBlock && param.getJavaParameter().isHolder()) {
                    if (hasBodyParams) {
                        p.p(", ");
                    }
                    p.p(param.getName() + "_holder");
                    hasBodyParams = true;
                }
            } else if (param.getBlock().getLocation() == 3) {
                if (hasBodyParams || count > 0) {
                    p.p(", ");
                }
                if (param.getJavaParameter().isHolder()) {
                    p.p(param.getName() + "_holder");
                } else {
                    p.p(param.getName());
                }
                hasBodyParams = true;
                ++count;
            }
            ++count;
        }
        if (headerParameterCount > 0) {
            boolean count1 = false;
            iterator = requestMessage.getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (!parameter.getJavaParameter().isHolder() && parameter.getBlock().getLocation() == 2) {
                    if (hasBodyParams || count > 0) {
                        p.p(", ");
                    }
                    p.p(parameter.getName());
                }
                ++count;
            }
        }
        if (operation.getResponse() != null) {
            iterator = operation.getResponse().getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 2) continue;
                p.p(", ");
                javaParameter = parameter.getJavaParameter();
                if (javaParameter.isHolder()) {
                    p.p(parameter.getName() + "_holder");
                    continue;
                }
                p.p(parameter.getName());
            }
        }
        p.pln(");");
        p.pln();
        if (operation.getResponse() != null) {
            String memberName;
            p.pln("SOAPHeaderBlockInfo headerInfo;");
            iterator = operation.getResponse().getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                Block responseBlock1 = parameter.getBlock();
                if (responseBlock1.getLocation() != 2) continue;
                javaParameter = parameter.getJavaParameter();
                String qname = this.env.getNames().getBlockQNameName(null, responseBlock1);
                memberName = javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                p.pln("headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
                p.pln("headerInfo.setValue(" + memberName + ");");
                p.pln("headerInfo.setSerializer(" + this.writerFactory.createWriter(this.servicePackage, responseBlock1.getType()).serializerMemberName() + ");");
                p.pln("state.getResponse().add(headerInfo);");
            }
            p.pln();
            p.pln();
            iterator = operation.getResponse().getParameters();
            if (!iterator.hasNext() && resultIsEmbedded && responseBlock != null) {
                p.pln(responseObjType + " " + responseObjName + " = new " + responseObjType + "();");
                iterator = message.getParameters();
                if (iterator.hasNext()) {
                    parameter = (Parameter)iterator.next();
                    javaMember = TieGenerator.getJavaMember(parameter);
                    if (javaMember.isPublic()) {
                        p.pln(responseObjName + "." + parameter.getName() + " = _result;");
                    } else {
                        p.pln(responseObjName + "." + javaMember.getWriteMethod() + "(_result);");
                    }
                }
            }
            while (iterator.hasNext()) {
                JavaParameter javaParam;
                String pName;
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 1) continue;
                if (resultIsEmbedded && responseBlock != null) {
                    javaMember = TieGenerator.getJavaMember(parameter);
                    javaParameter = parameter.getJavaParameter();
                    memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                    if (javaMember != null) {
                        p.pln(responseObjType + " " + responseObjName + " = new " + responseObjType + "();");
                        if (parameter.getType() instanceof LiteralArrayWrapperType) {
                            memberName = "new " + parameter.getType().getJavaType().getName() + "(" + memberName + ")";
                        }
                        if (javaMember.isPublic()) {
                            p.pln(responseObjName + "." + javaMember.getName() + " = " + memberName + ";");
                            break;
                        }
                        p.pln(responseObjName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
                        break;
                    }
                    if (parameter.getBlock() != responseBlock) continue;
                    pName = parameter.getName();
                    javaParam = parameter.getJavaParameter();
                    if (javaParam != null && javaParam.isHolder()) {
                        pName = pName + "_holder.value";
                    }
                    p.pln(responseObjType + " " + responseObjName + " = " + pName + ";");
                    break;
                }
                if (parameter.getBlock() != responseBlock) continue;
                pName = parameter.getName();
                javaParam = parameter.getJavaParameter();
                if (javaParam != null && javaParam.isHolder()) {
                    pName = pName + "_holder.value";
                }
                p.pln(responseObjType + " " + responseObjName + " = " + pName + ";");
                break;
            }
            if (responseBlock != null) {
                p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, responseBlock) + ");");
                String valueStr = responseObjName;
                if (SimpleToBoxedUtil.isPrimitive(responseObjType)) {
                    valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, responseObjType);
                }
                p.pln("bodyBlock.setValue(" + valueStr + ");");
                String serializer = this.writerFactory.createWriter(this.servicePackage, responseBlockType).serializerMemberName();
                p.pln("bodyBlock.setSerializer(" + serializer + ");");
                p.pln("state.getResponse().setBody(bodyBlock);");
            } else if (responseBlock == null) {
                p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(null);");
                p.pln("bodyBlock.setSerializer(DummySerializer.getInstance());");
                p.pln("state.getResponse().setBody(bodyBlock);");
            }
            this.addAttachmentsToResponse(p, operation.getResponse().getParameters());
        }
        this.writeCatchClauses(p, operation);
        p.pOln("}");
        p.pOln("}");
    }

    @Override
    protected void writeReadFirstBodyElementDefault(IndentingWriter p, String opCode) throws IOException {
        p.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", java.lang.Integer.toString(" + opCode + "));");
    }

    private void addAttachmentsToResponse(IndentingWriter p, Iterator params) throws IOException {
        boolean gotone = false;
        while (params.hasNext()) {
            Object getUUIDMethod = null;
            Parameter parameter = (Parameter)params.next();
            Block responseBlock = parameter.getBlock();
            if (responseBlock.getLocation() != 3) continue;
            JavaParameter javaParameter = parameter.getJavaParameter();
            String paramName = parameter.getName();
            if (javaParameter != null && javaParameter.isHolder()) {
                paramName = paramName + "_holder.value";
            }
            String mimeType = null;
            String contentID = null;
            AbstractType pType = parameter.getType();
            if (pType instanceof LiteralAttachmentType) {
                LiteralAttachmentType attType = (LiteralAttachmentType)pType;
                mimeType = attType.getJavaType().getRealName().equals("javax.activation.DataHandler") ? "((" + parameter.getType().getJavaType().getName() + ")" + paramName + ").getContentType()" : "\"" + attType.getMIMEType() + "\"";
                contentID = attType.getContentID();
            }
            p.pln("addAttachment(state.getResponse().getMessage(), (java.lang.Object)" + paramName + ", " + mimeType + ", " + "\"" + contentID + "\");");
            this.setAddAttachmentMethodFlag(true);
        }
    }

    private void declareHolderAttachmentObjects(IndentingWriter p, Block requestBlock, Operation operation) throws IOException {
        JavaMethod javaMethod = operation.getJavaMethod();
        Iterator iterator = javaMethod.getParameters();
        boolean declaredHeaderObj = false;
        boolean declaredAttachmentObj = false;
        boolean mimeTypesDeclared = false;
        boolean isDataHandler = false;
        boolean i = false;
        while (iterator.hasNext()) {
            Iterator iter;
            int j;
            List mimeList;
            String cId;
            int index;
            LiteralAttachmentType attType;
            AbstractType pType;
            JavaParameter javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.getParameter().getBlock().getLocation() != 3) continue;
            if (!mimeTypesDeclared) {
                p.pln("String[] mimeTypes = null;");
                mimeTypesDeclared = true;
            }
            if (javaParameter.getParameter().getLinkedParameter() != null) {
                pType = javaParameter.getParameter().getType();
                if (!(pType instanceof LiteralAttachmentType)) continue;
                attType = (LiteralAttachmentType)pType;
                String javaType = javaParameter.getParameter().getType().getJavaType().getName();
                index = attType.getContentID().indexOf(64);
                cId = attType.getContentID().substring(index + 1);
                isDataHandler = attType.getJavaType().getRealName().equals("javax.activation.DataHandler");
                mimeList = attType.getAlternateMIMETypes();
                p.pln("mimeTypes = new String[" + mimeList.size() + "];");
                j = 0;
                iter = mimeList.iterator();
                while (iter.hasNext()) {
                    p.pln("mimeTypes[" + j + "] = new String(\"" + (String)iter.next() + "\");");
                    ++j;
                }
                p.pln(javaParameter.getParameter().getName() + "_holder.value = (" + javaType + ")getAttachment(state.getRequest().getMessage(), mimeTypes, \"" + cId + "\", " + String.valueOf(isDataHandler) + ");");
                this.setGetAttachmentMethodFlag(true);
                continue;
            }
            if (javaParameter.isHolder() || !((pType = javaParameter.getParameter().getType()) instanceof LiteralAttachmentType)) continue;
            attType = (LiteralAttachmentType)pType;
            AbstractType paramType = javaParameter.getParameter().getType();
            index = attType.getContentID().indexOf(64);
            cId = attType.getContentID().substring(index + 1);
            isDataHandler = attType.getJavaType().getRealName().equals("javax.activation.DataHandler");
            mimeList = attType.getAlternateMIMETypes();
            p.pln("mimeTypes = new String[" + mimeList.size() + "];");
            j = 0;
            iter = mimeList.iterator();
            while (iter.hasNext()) {
                p.pln("mimeTypes[" + j + "] = new String(\"" + (String)iter.next() + "\");");
                ++j;
            }
            p.pln(paramType.getJavaType().getName() + " " + javaParameter.getParameter().getName() + " = (" + paramType.getJavaType().getName() + ")getAttachment(state.getRequest().getMessage(), mimeTypes, \"" + cId + "\", " + String.valueOf(isDataHandler) + ");");
            this.setGetAttachmentMethodFlag(true);
        }
    }

    @Override
    protected void writeStaticMembers(IndentingWriter p, Map headerMap) throws IOException {
        super.writeStaticMembers(p, headerMap);
    }

    @Override
    protected void writeUnderstoodHeadersMember(IndentingWriter p, Map headerMap) throws IOException {
        p.p("private static final QName[] understoodHeaderNames = new QName[] { ");
        boolean first = true;
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            Iterator blocks = operation.getRequest().getHeaderBlocks();
            while (blocks.hasNext()) {
                Block block = (Block)blocks.next();
                String qname = this.env.getNames().getBlockQNameName(operation, block);
                if (!first) {
                    p.p(", ");
                }
                p.p(qname);
                first = false;
            }
            ++i;
        }
        p.pln(" };");
    }

    @Override
    protected void writePreResponseWritingHook(IndentingWriter p, List operations) throws IOException {
        p.pln("");
        p.plnI("protected void preResponseWritingHook(StreamingHandlerState state) throws Exception {");
        p.pln("super.preResponseWritingHook(state);");
        p.plnI("switch (state.getRequest().getOperationCode()) {");
        for (Operation operation : operations) {
            if (!this.needsReadFirstBodyElementFor(operation)) continue;
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln("addNonExplicitAttachment(state);");
            p.pln("break;");
            p.pO();
        }
        p.pOln("}");
        p.pOln("}");
        p.pln();
    }

    @Override
    protected void writePostEnvelopeReadingHook(IndentingWriter p, List operations) throws IOException {
        p.pln();
        p.plnI("protected void postEnvelopeReadingHook(StreamingHandlerState state) throws Exception {");
        p.pln("super.postEnvelopeReadingHook(state);");
        p.plnI("switch (state.getRequest().getOperationCode()) {");
        for (Operation operation : operations) {
            if (!this.needsReadFirstBodyElementFor(operation)) continue;
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln("getNonExplicitAttachment(state);");
            p.pln("break;");
            p.pO();
        }
        p.pOln("}");
        p.pOln("}");
    }

    @Override
    protected void writeAttachmentHooks(IndentingWriter p) throws IOException {
        boolean generateGetNonExplicitAttachmentMethod = false;
        boolean generateAddNonExplicitAttachmentMethod = false;
        ArrayList<Operation> reqOps = new ArrayList<Operation>();
        ArrayList<Operation> resOps = new ArrayList<Operation>();
        Iterator iter = this.operations.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Response res;
            Operation operation = (Operation)iter.next();
            Request req = operation.getRequest();
            if (req != null && req.getProperty("com.sun.xml.rpc.processor.modeler.wsdl.mimeMultipartRelatedBinding") != null) {
                if (!generateGetNonExplicitAttachmentMethod) {
                    generateGetNonExplicitAttachmentMethod = true;
                }
                reqOps.add(operation);
            }
            if ((res = operation.getResponse()) != null && res.getProperty("com.sun.xml.rpc.processor.modeler.wsdl.mimeMultipartRelatedBinding") != null) {
                if (!generateAddNonExplicitAttachmentMethod) {
                    generateAddNonExplicitAttachmentMethod = true;
                }
                resOps.add(operation);
            }
            ++i;
        }
        if (generateAddNonExplicitAttachmentMethod) {
            this.writePreResponseWritingHook(p, resOps);
            this.writeAddNonExplicitAttachment(p);
        }
        if (generateGetNonExplicitAttachmentMethod) {
            this.writePostEnvelopeReadingHook(p, reqOps);
            this.writeGetNonExplicitAttachment(p);
        }
    }

    private void writeGetNonExplicitAttachment(IndentingWriter p) throws IOException {
        p.plnI("private void getNonExplicitAttachment(StreamingHandlerState state) throws Exception {");
        p.pln("javax.xml.rpc.handler.soap.SOAPMessageContext smc = state.getMessageContext();");
        p.pln("javax.xml.soap.SOAPMessage message = state.getRequest().getMessage();");
        p.pln("java.util.ArrayList attachments = null;");
        p.plnI("for(java.util.Iterator iter = message.getAttachments(); iter.hasNext();) {");
        p.plnI("if(attachments == null) {");
        p.pln("attachments = new java.util.ArrayList();");
        p.pOln("}");
        p.pln("attachments.add(iter.next());");
        p.pOln("}");
        p.pln("smc.setProperty(com.sun.xml.rpc.server.ServerPropertyConstants.GET_ATTACHMENT_PROPERTY, attachments);");
        p.pOln("}");
    }

    private void writeAddNonExplicitAttachment(IndentingWriter p) throws IOException {
        p.pln();
        p.plnI("private void addNonExplicitAttachment(StreamingHandlerState state) throws Exception {");
        p.pln("javax.xml.rpc.handler.soap.SOAPMessageContext smc = state.getMessageContext();");
        p.pln("javax.xml.soap.SOAPMessage message = state.getResponse().getMessage();");
        p.pln("Object c = smc.getProperty(com.sun.xml.rpc.server.ServerPropertyConstants.SET_ATTACHMENT_PROPERTY);");
        p.pln("smc.setProperty(com.sun.xml.rpc.server.ServerPropertyConstants.SET_ATTACHMENT_PROPERTY, null);");
        p.plnI("if(c != null && c instanceof java.util.Collection) {");
        p.plnI("for(java.util.Iterator iter = ((java.util.Collection)c).iterator(); iter.hasNext();) {");
        p.pln("Object attachment = iter.next();");
        p.plnI("if(attachment instanceof javax.xml.soap.AttachmentPart) {");
        p.pln("message.addAttachmentPart((javax.xml.soap.AttachmentPart)attachment);");
        p.pOln("}");
        p.pOln("}");
        p.pOln("}");
        p.pOln("}");
    }

    @Override
    protected void writeHooks(IndentingWriter p) throws IOException {
        Iterator iter = ToolPluginFactory.getInstance().getExtensions("com.sun.xml.rpc.tools.wscompile", "com.sun.xml.rpc.tools.wscompile.tieHooks");
        if (iter != null && iter.hasNext()) {
            this.writePreHandlingHook(p);
            this.writePostResponseWritingHook(p);
        }
    }

    protected void writePreHandlingHook(IndentingWriter p) throws IOException {
        p.pln();
        p.plnI("protected boolean preHandlingHook(StreamingHandlerState state) throws Exception {");
        p.pln("boolean bool = false;");
        Iterator iter = ToolPluginFactory.getInstance().getExtensions("com.sun.xml.rpc.tools.wscompile", "com.sun.xml.rpc.tools.wscompile.tieHooks");
        TieHooksIf.TieHooksState state = new TieHooksIf.TieHooksState();
        state.superDone = false;
        while (iter != null && iter.hasNext()) {
            TieHooksIf plugin = (TieHooksIf)iter.next();
            plugin.preHandlingHook(this.model, p, state);
        }
        if (!state.superDone) {
            p.pln("bool = super.preHandlingHook(state);");
        }
        p.pln("return bool;");
        p.pOln("}");
        p.pln();
    }

    protected void writePostResponseWritingHook(IndentingWriter p) throws IOException {
        p.pln();
        p.plnI("protected void postResponseWritingHook(StreamingHandlerState state) throws Exception {");
        Iterator iter = ToolPluginFactory.getInstance().getExtensions("com.sun.xml.rpc.tools.wscompile", "com.sun.xml.rpc.tools.wscompile.tieHooks");
        TieHooksIf.TieHooksState state = new TieHooksIf.TieHooksState();
        state.superDone = false;
        while (iter != null && iter.hasNext()) {
            TieHooksIf plugin = (TieHooksIf)iter.next();
            plugin.postResponseWritingHook(this.model, p, state);
        }
        if (!state.superDone) {
            p.pln("super.postResponseWritingHook(state);");
        }
        p.pOln("}");
        p.pln();
    }

    @Override
    protected void writeStatic(IndentingWriter p) throws IOException {
        Iterator iter = ToolPluginFactory.getInstance().getExtensions("com.sun.xml.rpc.tools.wscompile", "com.sun.xml.rpc.tools.wscompile.tieHooks");
        while (iter != null && iter.hasNext()) {
            TieHooksIf plugin = (TieHooksIf)iter.next();
            plugin.writeTieStatic(this.model, this.port, p);
        }
    }

    @Override
    protected Operation operationHasEmptyBody(Operation operation) {
        if (operation.getRequest() != null && operation.getRequest().getBodyBlockCount() == 0) {
            return operation;
        }
        return null;
    }
}

