/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppMsgContextImpl
implements MessageContext {
    private MessageContext ctxt;
    private Map<String, Object> appContext;

    private void init() {
        if (this.appContext == null) {
            this.appContext = new HashMap<String, Object>();
            for (Map.Entry entry : this.ctxt.entrySet()) {
                if (this.ctxt.getScope((String)entry.getKey()) != MessageContext.Scope.APPLICATION) continue;
                this.appContext.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public AppMsgContextImpl(MessageContext ctxt) {
        this.ctxt = ctxt;
    }

    public void clear() {
        this.init();
        Set<Map.Entry<String, Object>> props = this.appContext.entrySet();
        for (Map.Entry<String, Object> prop : props) {
            this.ctxt.remove((Object)prop.getKey());
        }
        this.appContext.clear();
    }

    public boolean containsKey(Object obj) {
        this.init();
        return this.appContext.containsKey(obj);
    }

    public boolean containsValue(Object obj) {
        this.init();
        return this.appContext.containsValue(obj);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.init();
        return this.appContext.entrySet();
    }

    public Object get(Object obj) {
        this.init();
        return this.appContext.get(obj);
    }

    public boolean isEmpty() {
        this.init();
        return this.appContext.isEmpty();
    }

    public Set<String> keySet() {
        this.init();
        return this.appContext.keySet();
    }

    public Object put(String str, Object obj) {
        this.init();
        MessageContext.Scope scope = null;
        try {
            scope = this.ctxt.getScope(str);
        }
        catch (IllegalArgumentException ie) {
            // empty catch block
        }
        if (scope != null && scope == MessageContext.Scope.HANDLER) {
            throw new IllegalArgumentException("Cannot overwrite property in HANDLER scope");
        }
        this.ctxt.put((Object)str, obj);
        this.ctxt.setScope(str, MessageContext.Scope.APPLICATION);
        return this.appContext.put(str, obj);
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        this.init();
        Set<Map.Entry<? extends String, ? extends Object>> props = map.entrySet();
        for (Map.Entry<? extends String, ? extends Object> prop : props) {
            this.put(prop.getKey(), prop.getValue());
        }
    }

    public Object remove(Object key) {
        this.init();
        MessageContext.Scope scope = null;
        try {
            scope = this.ctxt.getScope((String)key);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (scope != null && scope == MessageContext.Scope.HANDLER) {
            throw new IllegalArgumentException("Cannot remove property in HANDLER scope");
        }
        this.ctxt.remove(key);
        return this.appContext.remove(key);
    }

    public int size() {
        this.init();
        return this.appContext.size();
    }

    public Collection<Object> values() {
        this.init();
        return this.appContext.values();
    }

    public void setScope(String name, MessageContext.Scope scope) {
    }

    public MessageContext.Scope getScope(String name) {
        return null;
    }
}

