/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.protocol.soap.client;

import com.sun.xml.messaging.saaj.soap.MessageImpl;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.AsyncHandlerService;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.client.ContextMap;
import com.sun.xml.ws.client.EndpointIFContext;
import com.sun.xml.ws.client.EndpointIFInvocationHandler;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.WSFuture;
import com.sun.xml.ws.client.dispatch.DispatchContext;
import com.sun.xml.ws.client.dispatch.ResponseImpl;
import com.sun.xml.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.ws.encoding.soap.client.SOAP12XMLEncoder;
import com.sun.xml.ws.encoding.soap.client.SOAPXMLDecoder;
import com.sun.xml.ws.encoding.soap.client.SOAPXMLEncoder;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.internal.MessageInfoBase;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.handler.HandlerChainCaller;
import com.sun.xml.ws.handler.MessageContextUtil;
import com.sun.xml.ws.handler.SOAPHandlerContext;
import com.sun.xml.ws.model.JavaMethod;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.model.soap.SOAPBinding;
import com.sun.xml.ws.pept.ept.EPTFactory;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.spi.runtime.Binding;
import com.sun.xml.ws.spi.runtime.ClientTransportFactory;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.transport.http.client.HttpClientTransportFactory;
import com.sun.xml.ws.util.Base64Util;
import com.sun.xml.ws.util.FastInfosetUtil;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.SOAPConnectionUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageDispatcher
implements MessageDispatcher {
    protected static final int MAX_THREAD_POOL_SIZE = 3;
    protected static final long AWAIT_TERMINATION_TIME = 10L;
    protected ExecutorService executorService;
    private static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "SOAP must understand error";

    @Override
    public void send(MessageInfo messageInfo) {
        if (this.isAsync(messageInfo)) {
            this.doSendAsync(messageInfo);
        } else {
            this.doSend(messageInfo);
        }
    }

    protected SOAPMessage doSend(MessageInfo messageInfo) {
        EPTFactory contactInfo = messageInfo.getEPTFactory();
        SOAPXMLEncoder encoder = (SOAPXMLEncoder)contactInfo.getEncoder(messageInfo);
        SOAPMessage sm = null;
        boolean handlerResult = true;
        boolean isRequestResponse = messageInfo.getMEP() == 1;
        try {
            if (messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
                sm = (SOAPMessage)messageInfo.getData()[0];
                FastInfosetUtil.ensureCorrectEncoding(messageInfo, sm);
            }
            SOAPHandlerContext handlerContext = null;
            InternalMessage im = encoder.toInternalMessage(messageInfo);
            HandlerChainCaller caller = this.getHandlerChainCaller(messageInfo);
            if (caller.hasHandlers()) {
                block19: {
                    im = this.preHandlerOutboundHook(sm, im);
                    handlerContext = new SOAPHandlerContext(messageInfo, im, sm);
                    handlerContext.getMessageContext().put((Object)"javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
                    handlerContext.populateAttachmentMap();
                    encoder.setAttachmentsMap(messageInfo, im);
                    this.updateMessageContext(messageInfo, handlerContext);
                    try {
                        JAXWSAttachmentMarshaller am = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
                        boolean isXopped = false;
                        if (am != null && am.isXOPPackage()) {
                            isXopped = am.isXOPPackage();
                            am.setXOPPackage(false);
                        }
                        handlerResult = this.callHandlersOnRequest(handlerContext);
                        if (am != null) {
                            am.setXOPPackage(isXopped);
                        }
                    }
                    catch (ProtocolException pe) {
                        handlerResult = false;
                        if (!MessageContextUtil.ignoreFaultInMessage(handlerContext.getMessageContext())) break block19;
                        throw new WebServiceException((Throwable)pe);
                    }
                }
                sm = handlerContext.getSOAPMessage();
                this.postHandlerOutboundHook(messageInfo, handlerContext, sm);
                if (sm == null) {
                    sm = encoder.toSOAPMessage(handlerContext.getInternalMessage(), messageInfo);
                }
                if (isRequestResponse && !handlerResult) {
                    SOAPXMLDecoder decoder = (SOAPXMLDecoder)contactInfo.getDecoder(messageInfo);
                    im = decoder.toInternalMessage(sm, messageInfo);
                    decoder.toMessageInfo(im, messageInfo);
                    return sm;
                }
            }
            messageInfo.setEncoder(encoder);
            SystemHandlerDelegate systemHandlerDelegate = ((Binding)this.getBinding(messageInfo)).getSystemHandlerDelegate();
            if (systemHandlerDelegate != null) {
                if (handlerContext == null) {
                    handlerContext = new SOAPHandlerContext(messageInfo, im, sm);
                    handlerContext.getMessageContext().put((Object)"javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
                    handlerContext.populateAttachmentMap();
                    this.updateMessageContext(messageInfo, handlerContext);
                }
                encoder.setAttachmentsMap(messageInfo, im);
                if (sm != null && im != null) {
                    handlerContext.setInternalMessage(null);
                }
                handlerContext.getBindingId();
                systemHandlerDelegate.processRequest(handlerContext.getSHDSOAPMessageContext());
                sm = handlerContext.getSOAPMessage();
            }
            if (sm == null) {
                sm = encoder.toSOAPMessage(im, messageInfo);
            }
            Map<String, Object> context = this.processMetadata(messageInfo, sm);
            this.setConnection(messageInfo, context);
            if (!this.isAsync(messageInfo)) {
                WSConnection connection = messageInfo.getConnection();
                this.logRequestMessage(sm, messageInfo);
                SOAPConnectionUtil.sendResponse(connection, sm);
            }
            if (isRequestResponse) {
                this.receive(messageInfo);
            } else if (this.isOneway(messageInfo)) {
                this.checkReturnStatus(messageInfo);
            }
        }
        catch (WebServiceException wse) {
            this.setResponseType(wse, messageInfo);
            messageInfo.setResponse((Object)wse);
        }
        catch (Throwable e) {
            WebServiceException wse = new WebServiceException(e);
            this.setResponseType(wse, messageInfo);
            messageInfo.setResponse((Object)wse);
        }
        return sm;
    }

    private boolean isOneway(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 2;
    }

    protected Map<String, Object> processMetadata(MessageInfo messageInfo, SOAPMessage soapMessage) {
        HashMap<String, Object> messageContext = new HashMap<String, Object>();
        ArrayList header = new ArrayList();
        ContextMap properties = (ContextMap)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        if (messageInfo.getMEP() == 2) {
            messageContext.put("com.sun.xml.ws.server.OneWayOperation", "true");
        }
        String soapAction = null;
        boolean useSoapAction = false;
        if (properties != null) {
            Iterator<String> names = properties.getPropertyNames();
            while (names.hasNext()) {
                String propName = names.next();
                if (propName.equals(ClientTransportFactory.class.getName())) {
                    messageContext.put("com.sun.xml.ws.client.ClientTransportFactory", (ClientTransportFactory)properties.get(propName));
                    continue;
                }
                if (propName.equals("javax.xml.ws.security.auth.username")) {
                    String credentials = (String)properties.get("javax.xml.ws.security.auth.username");
                    if (credentials == null) continue;
                    credentials = credentials + ":";
                    String password = (String)properties.get("javax.xml.ws.security.auth.password");
                    if (password != null) {
                        credentials = credentials + password;
                    }
                    try {
                        credentials = Base64Util.encode(credentials.getBytes());
                    }
                    catch (Exception ex) {
                        throw new WebServiceException((Throwable)ex);
                    }
                    soapMessage.getMimeHeaders().addHeader("Authorization", "Basic " + credentials);
                    continue;
                }
                if (propName.equals("javax.xml.ws.soap.http.soapaction.use")) {
                    useSoapAction = (Boolean)properties.get("javax.xml.ws.soap.http.soapaction.use");
                    if (!useSoapAction) continue;
                    soapAction = (String)properties.get("javax.xml.ws.soap.http.soapaction.uri");
                    continue;
                }
                messageContext.put(propName, properties.get(propName));
            }
        }
        String contentNegotiation = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        String bindingId = this.getBindingId(messageInfo);
        if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            soapMessage.getMimeHeaders().setHeader("Accept", contentNegotiation != "none" ? "application/soap+fastinfoset, application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        } else {
            soapMessage.getMimeHeaders().setHeader("Accept", contentNegotiation != "none" ? "application/fastinfoset, text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        messageContext.put("com.sun.xml.ws.binding", bindingId);
        RuntimeContext runtimeContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.ws.runtime.context");
        if (runtimeContext != null) {
            JavaMethod javaMethod = runtimeContext.getModel().getJavaMethod(messageInfo.getMethod());
            if (javaMethod != null) {
                soapAction = ((SOAPBinding)javaMethod.getBinding()).getSOAPAction();
                header.clear();
                if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                    if (soapAction != null && soapAction.length() > 0) {
                        ((MessageImpl)soapMessage).setAction(soapAction);
                    }
                } else if (soapAction == null) {
                    soapMessage.getMimeHeaders().addHeader("SOAPAction", "\"\"");
                } else {
                    soapMessage.getMimeHeaders().addHeader("SOAPAction", "\"" + soapAction + "\"");
                }
            }
        } else if (messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context") != null) {
            header.clear();
            if (soapAction == null) {
                soapMessage.getMimeHeaders().addHeader("SOAPAction", "\"\"");
            } else {
                soapMessage.getMimeHeaders().addHeader("SOAPAction", "\"" + soapAction + "\"");
            }
        }
        return messageContext;
    }

    protected void setConnection(MessageInfo messageInfo, Map<String, Object> context) {
        ClientTransportFactory clientTransportFactory = (ClientTransportFactory)context.get("com.sun.xml.ws.client.ClientTransportFactory");
        WSConnection connection = null;
        if (clientTransportFactory == null) {
            clientTransportFactory = new HttpClientTransportFactory();
            context.put("com.sun.xml.ws.client.ClientTransportFactory", clientTransportFactory);
        }
        connection = clientTransportFactory.create(context);
        messageInfo.setConnection(connection);
    }

    protected void setResponseType(Throwable e, MessageInfo messageInfo) {
        if (e instanceof RuntimeException) {
            messageInfo.setResponseType(2);
            if (e instanceof ClientTransportException) {
                Throwable temp = e;
                e = new WebServiceException(temp.getMessage(), temp);
            }
        } else {
            messageInfo.setResponseType(1);
        }
        messageInfo.setResponse(e);
    }

    public void checkReturnStatus(MessageInfo messageInfo) {
        WSConnection connection = messageInfo.getConnection();
        Map<String, List<String>> headers = connection.getHeaders();
        if (connection.getStatus() != 202 && connection.getStatus() != 200) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "HTTP status code for oneway: expected 202 or 200, got " + connection.getStatus());
        }
    }

    @Override
    public void receive(MessageInfo messageInfo) {
        SystemHandlerDelegate systemHandlerDelegate;
        EPTFactory contactInfo = messageInfo.getEPTFactory();
        SOAPXMLDecoder decoder = (SOAPXMLDecoder)contactInfo.getDecoder(messageInfo);
        SOAPMessage sm = decoder.toSOAPMessage(messageInfo);
        String contentNegotiationType = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (contentNegotiationType == "pessimistic") {
            try {
                if (((MessageImpl)sm).isFastInfoset()) {
                    Map requestContext = (Map)messageInfo.getMetaData("com.sun.xml.ws.context.request");
                    requestContext.put("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        try {
            this.logResponseMessage(sm, messageInfo);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        SOAPHandlerContext handlerContext = this.getInboundHandlerContext(messageInfo, sm);
        WSConnection con = messageInfo.getConnection();
        MessageContextUtil.setHttpStatusCode(handlerContext.getMessageContext(), con.getStatus());
        MessageContextUtil.setHttpResponseHeaders(handlerContext.getMessageContext(), con.getHeaders());
        RuntimeContext rtContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        if (rtContext != null) {
            rtContext.setHandlerContext(handlerContext);
        }
        handlerContext.getMessageContext().put((Object)"javax.xml.ws.handler.message.outbound", (Object)Boolean.FALSE);
        MessageContext msgCtxt = MessageInfoUtil.getMessageContext(messageInfo);
        if (msgCtxt != null) {
            try {
                Map attMap = (Map)msgCtxt.get((Object)"javax.xml.ws.binding.attachments.outbound");
                if (attMap != null) {
                    attMap.clear();
                }
                MessageContextUtil.copyInboundMessageAttachments(msgCtxt, sm.getAttachments());
            }
            catch (SOAPException e) {
                throw new RuntimeException(e);
            }
        }
        if ((systemHandlerDelegate = ((Binding)this.getBinding(messageInfo)).getSystemHandlerDelegate()) != null) {
            try {
                systemHandlerDelegate.processResponse(handlerContext.getSHDSOAPMessageContext());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            MessageInfoUtil.setHandlerChainCaller(messageInfo, this.getHandlerChainCaller(messageInfo));
            decoder.doMustUnderstandProcessing(sm, messageInfo, handlerContext, false);
        }
        catch (SOAPException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
        catch (SOAPFaultException sfe) {
            this.closeAllHandlers(handlerContext);
            throw sfe;
        }
        HandlerChainCaller caller = this.getHandlerChainCaller(messageInfo);
        if (caller.hasHandlers()) {
            this.callHandlersOnResponse(handlerContext);
            this.postHandlerInboundHook(messageInfo, handlerContext, sm);
        }
        SOAPXMLEncoder encoder = (SOAPXMLEncoder)contactInfo.getEncoder(messageInfo);
        InternalMessage im = handlerContext.getInternalMessage();
        if (messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
            im = null;
        }
        im = im == null ? decoder.toInternalMessage(sm, messageInfo) : decoder.toInternalMessage(sm, im, messageInfo);
        decoder.toMessageInfo(im, messageInfo);
        this.updateResponseContext(messageInfo, handlerContext);
        if (messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
            messageInfo.setResponse(sm);
            this.postReceiveAndDecodeHook(messageInfo);
        }
    }

    private SOAPHandlerContext getInboundHandlerContext(MessageInfo messageInfo, SOAPMessage sm) {
        SOAPHandlerContext handlerContext = (SOAPHandlerContext)messageInfo.getMetaData("com.sun.xml.ws.handler.context");
        if (handlerContext != null) {
            handlerContext.setSOAPMessage(sm);
            handlerContext.setInternalMessage(null);
        } else {
            handlerContext = new SOAPHandlerContext(messageInfo, null, sm);
        }
        return handlerContext;
    }

    protected void doSendAsync(MessageInfo messageInfo) {
        try {
            this.preSendHook(messageInfo);
            SOAPMessage sm = this.doSend(messageInfo);
            this.postSendHook(messageInfo);
            Response<Object> r = this.sendAsyncReceive(MessageInfoBase.copy(messageInfo), sm);
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(3, new DaemonThreadFactory());
            }
            AsyncHandlerService service = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.asynchandler");
            WSFuture<Object> wsfuture = null;
            if (service != null) {
                wsfuture = service.setupAsyncCallback(r);
                ((ResponseImpl)r).setUID(service.getUID());
                ((ResponseImpl)r).setHandlerService(service);
            }
            this.executorService.execute((FutureTask)r);
            if (service == null) {
                messageInfo.setResponse(r);
            } else {
                messageInfo.setResponse(wsfuture);
            }
        }
        catch (Throwable e) {
            messageInfo.setResponse(e);
        }
    }

    protected Response<Object> sendAsyncReceive(final MessageInfo messageInfo, final SOAPMessage sm) {
        boolean callback;
        AsyncHandlerService handler = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.asynchandler");
        boolean bl = callback = messageInfo.getMEP() == 4;
        if (callback && handler == null) {
            throw new WebServiceException("Asynchronous callback invocation, but no handler - AsyncHandler required");
        }
        ResponseImpl<Object> r = new ResponseImpl<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    WSConnection connection = messageInfo.getConnection();
                    SOAPMessageDispatcher.this.logRequestMessage(sm, messageInfo);
                    SOAPConnectionUtil.sendResponse(connection, sm);
                }
                catch (Throwable t) {
                    messageInfo.setResponse(t);
                    messageInfo.setResponseType(2);
                }
                SOAPMessageDispatcher.this.preReceiveHook(messageInfo);
                try {
                    SOAPMessageDispatcher.this.receive(messageInfo);
                }
                catch (Exception ex) {
                    messageInfo.setResponse(ex);
                }
                SOAPMessageDispatcher.this.postReceiveHook(messageInfo);
                if (messageInfo.getResponse() instanceof Exception) {
                    throw (Exception)messageInfo.getResponse();
                }
                return messageInfo.getResponse();
            }
        });
        messageInfo.setMetaData("com.sun.xml.ws.client.dispatch.async.response.context", r);
        return r;
    }

    protected boolean callHandlersOnRequest(SOAPHandlerContext handlerContext) {
        HandlerChainCaller caller = this.getHandlerChainCaller(handlerContext.getMessageInfo());
        boolean responseExpected = handlerContext.getMessageInfo().getMEP() != 2;
        return caller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, handlerContext, responseExpected);
    }

    protected boolean callHandlersOnResponse(SOAPHandlerContext handlerContext) {
        HandlerChainCaller caller = this.getHandlerChainCaller(handlerContext.getMessageInfo());
        try {
            return caller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, handlerContext, false);
        }
        catch (WebServiceException wse) {
            throw new WebServiceException((Throwable)wse);
        }
    }

    protected javax.xml.ws.Binding getBinding(MessageInfo messageInfo) {
        ContextMap context = (ContextMap)((MessageInfoBase)messageInfo).getMetaData("com.sun.xml.ws.context.request");
        BindingProvider provider = (BindingProvider)context.get("com.sun.xml.ws.client.handle");
        return provider.getBinding();
    }

    protected HandlerChainCaller getHandlerChainCaller(MessageInfo messageInfo) {
        BindingImpl binding = (BindingImpl)this.getBinding(messageInfo);
        return binding.getHandlerChainCaller();
    }

    private void updateSOAPMessage(Object value, SOAPMessage sm) {
        try {
            if (value instanceof Source) {
                SOAPBody sb = sm.getSOAPPart().getEnvelope().getBody();
                sb.removeContents();
                XmlUtil.newTransformer().transform((Source)value, new DOMResult((Node)sb));
                sm.saveChanges();
            }
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    protected void updateMessageContext(MessageInfo messageInfo, SOAPHandlerContext context) {
        Object prop;
        RuntimeContext rtContext;
        SOAPMessageContext messageContext = context.getSOAPMessageContext();
        messageInfo.setMetaData("com.sun.xml.ws.handler.context", context);
        RequestContext ctxt = (RequestContext)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        Iterator<String> i = ctxt.copy().getPropertyNames();
        while (i.hasNext()) {
            String name = i.next();
            Object value = ctxt.get(name);
            messageContext.put((Object)name, value);
        }
        BindingProvider provider = (BindingProvider)context.getMessageContext().get((Object)"com.sun.xml.ws.client.handle");
        if (provider != null && Proxy.isProxyClass(provider.getClass())) {
            EndpointIFInvocationHandler invocationHandler = (EndpointIFInvocationHandler)Proxy.getInvocationHandler(provider);
            EndpointIFContext endpointContext = invocationHandler.getEndpointContext();
            messageContext.put((Object)"javax.xml.ws.wsdl.service", (Object)invocationHandler.getServiceQName());
            messageContext.put((Object)"javax.xml.ws.wsdl.port", (Object)endpointContext.getPortName());
            context.setBindingId(endpointContext.getBindingID().toString());
        }
        if ((rtContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.ws.runtime.context")) != null) {
            RuntimeModel model = rtContext.getModel();
            JavaMethod javaMethod = model.getJavaMethod(messageInfo.getMethod());
            if (javaMethod != null) {
                QName operationName = model.getQNameForJM(javaMethod);
                messageContext.put((Object)"javax.xml.ws.wsdl.operation", (Object)operationName);
            }
            rtContext.setHandlerContext(context);
        }
        if ((prop = messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation")) != null) {
            messageContext.put((Object)"com.sun.xml.ws.client.ContentNegotiation", prop);
        }
    }

    protected void updateResponseContext(MessageInfo messageInfo, SOAPHandlerContext context) {
        SOAPMessageContext messageContext = context.getSOAPMessageContext();
        RequestContext rc = (RequestContext)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        BindingProvider provider = (BindingProvider)rc.get("com.sun.xml.ws.client.handle");
        ResponseContext responseContext = new ResponseContext(provider);
        for (String name : messageContext.keySet()) {
            MessageContext.Scope scope = messageContext.getScope(name);
            if (MessageContext.Scope.APPLICATION != scope) continue;
            Object value = messageContext.get((Object)name);
            responseContext.put(name, value);
        }
        ResponseImpl asyncResponse = (ResponseImpl)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.async.response.context");
        if (asyncResponse != null) {
            asyncResponse.setResponseContext(responseContext.copy());
        } else {
            messageInfo.setMetaData("com.sun.xml.ws.context.response", responseContext.copy());
        }
    }

    protected boolean isAsync(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 3 || messageInfo.getMEP() == 4;
    }

    private void preSendHook(MessageInfo messageInfo) {
    }

    private void preReceiveHook(MessageInfo messageInfo) {
    }

    private void postSendHook(MessageInfo messageInfo) {
        if (messageInfo.getResponseType() != 0) {
            this.postReceiveHook(messageInfo);
            throw (WebServiceException)((Object)messageInfo.getResponse());
        }
    }

    private void postReceiveAndDecodeHook(MessageInfo messageInfo) {
        Object response;
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context");
        if (messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE && dispatchContext.getProperty("com.sun.xml.ws.rt.client.dispatch.messagetype") == DispatchContext.MessageType.SOURCE_MESSAGE && (response = messageInfo.getResponse()) instanceof SOAPMessage) {
            SOAPPart part = ((SOAPMessage)response).getSOAPPart();
            try {
                messageInfo.setResponse(part.getContent());
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    private void postReceiveHook(MessageInfo messageInfo) {
        Object response = messageInfo.getResponse();
        switch (messageInfo.getResponseType()) {
            case 0: {
                return;
            }
            case 1: {
                if (response instanceof SOAPFaultInfo) {
                    SOAPFaultInfo soapFaultInfo = (SOAPFaultInfo)response;
                    JAXBException jbe = null;
                    if (soapFaultInfo.getString().contains("javax.xml.bind")) {
                        jbe = new JAXBException(soapFaultInfo.getString());
                    }
                    SOAPFaultException sfe = new SOAPFaultException(soapFaultInfo.getSOAPFault());
                    if (jbe != null) {
                        sfe.initCause((Throwable)jbe);
                    }
                    messageInfo.setResponse((Object)sfe);
                }
                return;
            }
            case 2: {
                if (response instanceof SOAPFaultException) {
                    messageInfo.setResponse((Object)((SOAPFaultException)((Object)response)));
                } else {
                    WebServiceException jex = null;
                    if (response instanceof Exception) {
                        jex = new WebServiceException((Throwable)((Exception)response));
                        messageInfo.setResponse((Object)jex);
                    }
                    messageInfo.setResponse(response);
                }
                return;
            }
        }
        messageInfo.setResponse(response);
    }

    private InternalMessage preHandlerOutboundHook(SOAPMessage sm, InternalMessage im) {
        if (sm != null && im != null) {
            im = null;
        }
        return im;
    }

    private void postHandlerOutboundHook(MessageInfo messageInfo, SOAPHandlerContext handlerContext, SOAPMessage sm) {
        if (messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
            InternalMessage im = handlerContext.getInternalMessage();
            if (im != null) {
                Object value = im.getBody().getValue();
                this.updateSOAPMessage(value, sm);
                im = null;
            } else {
                try {
                    sm.saveChanges();
                }
                catch (SOAPException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        }
    }

    private void postHandlerInboundHook(MessageInfo messageInfo, SOAPHandlerContext handlerContext, SOAPMessage sm) {
        if (messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
            InternalMessage im = handlerContext.getInternalMessage();
            if (im != null) {
                Object value = im.getBody().getValue();
                this.updateSOAPMessage(value, sm);
                im = null;
            } else {
                try {
                    sm.saveChanges();
                }
                catch (SOAPException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        }
    }

    private void closeAllHandlers(SOAPHandlerContext context) {
        HandlerChainCaller caller = this.getHandlerChainCaller(context.getMessageInfo());
        if (caller != null && caller.hasHandlers()) {
            caller.forceCloseHandlers(context);
        }
    }

    protected String getBindingId(MessageInfo messageInfo) {
        SOAPEncoder encoder = (SOAPEncoder)messageInfo.getEncoder();
        if (encoder instanceof SOAP12XMLEncoder) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    protected void logRequestMessage(SOAPMessage soapMessage, MessageInfo messageInfo) throws IOException, SOAPException {
        OutputStream out = messageInfo.getConnection().getDebug();
        if (out != null) {
            String s = "******************\nRequest\n";
            out.write(s.getBytes());
            Iterator iter = soapMessage.getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                s = header.getName() + ": " + header.getValue() + "\n";
                out.write(s.getBytes());
            }
            out.flush();
            soapMessage.writeTo(out);
            s = "\n";
            out.write(s.getBytes());
            out.flush();
        }
    }

    protected void logResponseMessage(SOAPMessage response, MessageInfo messageInfo) throws IOException, SOAPException {
        OutputStream out = messageInfo.getConnection().getDebug();
        if (out != null) {
            String s = "Response\n";
            out.write(s.getBytes());
            s = "Http Status Code: " + messageInfo.getConnection().getStatus() + "\n\n";
            out.write(s.getBytes());
            Iterator iter = response.getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                s = header.getName() + ": " + header.getValue() + "\n";
                out.write(s.getBytes());
            }
            out.flush();
            response.writeTo(out);
            s = "******************\n\n";
            out.write(s.getBytes());
        }
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r);
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }
}

