/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.streambuffer;

import com.sun.xml.fastinfoset.types.ValueInstance;
import com.sun.xml.stream.buffer.AbstractProcessor;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import org.jvnet.fastinfoset.sax.FastInfosetWriter;
import org.jvnet.fastinfoset.sax.helpers.EncodingAlgorithmAttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class FastInfosetWriterSAXBufferProcessor
extends AbstractProcessor {
    FastInfosetWriter _writer;
    boolean _namespacePrefixesFeature = false;
    EncodingAlgorithmAttributesImpl _attributes;
    String[] _namespacePrefixes = new String[16];
    int _namespacePrefixesIndex;
    int[] _namespaceAttributesStack = new int[16];
    int _namespaceAttributesStackIndex;

    public FastInfosetWriterSAXBufferProcessor() {
        this._attributes = new EncodingAlgorithmAttributesImpl();
    }

    public FastInfosetWriterSAXBufferProcessor(XMLStreamBuffer buffer) {
        this();
        this.setXMLStreamBuffer(buffer);
    }

    public final void process(XMLStreamBuffer buffer, FastInfosetWriter writer) throws SAXException {
        this.setXMLStreamBuffer(buffer);
        this.process(writer);
    }

    public void setXMLStreamBuffer(XMLStreamBuffer buffer) {
        this.setBuffer(buffer, buffer.isFragment());
    }

    public final void process(FastInfosetWriter writer) throws SAXException {
        this._writer = writer;
        int item = this.readStructure();
        switch (FastInfosetWriterSAXBufferProcessor.getAIIState((int)item)) {
            case 1: {
                this.processDocument();
                break;
            }
            case 17: {
                return;
            }
            case 3: {
                this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                break;
            }
            case 4: {
                String prefix = this.readStructureString();
                String uri = this.readStructureString();
                String localName = this.readStructureString();
                this.processElement(uri, localName, this.getQName(prefix, localName));
                break;
            }
            case 5: {
                String uri = this.readStructureString();
                String localName = this.readStructureString();
                this.processElement(uri, localName, localName);
                break;
            }
            case 6: {
                String localName = this.readStructureString();
                this.processElement("", localName, localName);
                break;
            }
            default: {
                throw this.reportFatalError("Illegal state for DIIs: " + item);
            }
        }
    }

    private SAXParseException reportFatalError(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, null);
        return spe;
    }

    private void processDocument() throws SAXException {
        int item;
        this._writer.startDocument();
        boolean firstElementHasOccured = false;
        do {
            item = this.readStructure();
            switch (FastInfosetWriterSAXBufferProcessor.getAIIState((int)item)) {
                case 3: {
                    firstElementHasOccured = true;
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    firstElementHasOccured = true;
                    String prefix = this.readStructureString();
                    String uri = this.readStructureString();
                    String localName = this.readStructureString();
                    this.processElement(uri, localName, this.getQName(prefix, localName));
                    break;
                }
                case 5: {
                    firstElementHasOccured = true;
                    String uri = this.readStructureString();
                    String localName = this.readStructureString();
                    this.processElement(uri, localName, localName);
                    break;
                }
                case 6: {
                    firstElementHasOccured = true;
                    String localName = this.readStructureString();
                    this.processElement("", localName, localName);
                    break;
                }
                case 12: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 13: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 14: {
                    char[] ch = this.readContentCharactersCopy();
                    this.processComment(ch, 0, ch.length);
                    break;
                }
                case 15: {
                    this.processComment(this.readContentString());
                    break;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 17: {
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state for child of DII: " + item);
                }
            }
        } while (item != 144 || !firstElementHasOccured);
        block21: while (item != 144) {
            item = this.readStructure();
            switch (FastInfosetWriterSAXBufferProcessor.getAIIState((int)item)) {
                case 12: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    continue block21;
                }
                case 13: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    continue block21;
                }
                case 14: {
                    char[] ch = this.readContentCharactersCopy();
                    this.processComment(ch, 0, ch.length);
                    continue block21;
                }
                case 15: {
                    this.processComment(this.readContentString());
                    continue block21;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    continue block21;
                }
                case 17: {
                    continue block21;
                }
            }
            throw this.reportFatalError("Illegal state for child of DII: " + item);
        }
        this._writer.endDocument();
    }

    private void processElement(String uri, String localName, String qName) throws SAXException {
        boolean hasAttributes = false;
        boolean hasNamespaceAttributes = false;
        int item = this.peekStructure();
        if ((item & 0xF0) == 64) {
            hasNamespaceAttributes = true;
            item = this.processNamespaceAttributes(item);
        }
        if ((item & 0xF0) == 48) {
            hasAttributes = true;
            this.processAttributes(item);
        }
        this._writer.startElement(uri, localName, qName, (Attributes)this._attributes);
        if (hasAttributes) {
            this._attributes.clear();
        }
        block17: do {
            item = FastInfosetWriterSAXBufferProcessor.getAIIState((int)this.readStructure());
            switch (item) {
                case 3: {
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    String p = this.readStructureString();
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this.processElement(u, ln, this.getQName(p, ln));
                    break;
                }
                case 5: {
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this.processElement(u, ln, ln);
                    break;
                }
                case 6: {
                    String ln = this.readStructureString();
                    this.processElement("", ln, ln);
                    break;
                }
                case 7: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this._writer.characters(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 8: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this._writer.characters(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 9: {
                    char[] ch = this.readContentCharactersCopy();
                    this._writer.characters(ch, 0, ch.length);
                    break;
                }
                case 10: {
                    String s = this.readContentString();
                    this._writer.characters(s.toCharArray(), 0, s.length());
                    break;
                }
                case 11: {
                    ValueInstance v = (ValueInstance)this.readContentObject();
                    if (v.type == ValueInstance.Type.encodingAlgorithm) {
                        this._writer.object(null, v.id, v.instance);
                        break;
                    }
                    if (v.type == ValueInstance.Type.alphabet) {
                        char[] ch = (char[])v.instance;
                        if (v.alphabet.equals("0123456789-:TZ ")) {
                            this._writer.dateTimeCharacters(ch, 0, ch.length);
                            break;
                        }
                        if (!v.alphabet.equals("0123456789-+.E ")) continue block17;
                        this._writer.numericCharacters(ch, 0, ch.length);
                        break;
                    }
                    char[] ch = (char[])v.instance;
                    this._writer.characters(ch, 0, ch.length, true);
                    break;
                }
                case 12: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 13: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 14: {
                    char[] ch = this.readContentCharactersCopy();
                    this.processComment(ch, 0, ch.length);
                    break;
                }
                case 104: {
                    this.processComment(this.readContentString());
                    break;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 17: {
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state for child of EII: " + item);
                }
            }
        } while (item != 17);
        this._writer.endElement(uri, localName, qName);
        if (hasNamespaceAttributes) {
            this.processEndPrefixMapping();
        }
    }

    private void processEndPrefixMapping() throws SAXException {
        int end = this._namespaceAttributesStack[--this._namespaceAttributesStackIndex];
        int start = this._namespaceAttributesStackIndex > 0 ? this._namespaceAttributesStack[this._namespaceAttributesStackIndex] : 0;
        for (int i = end - 1; i >= start; --i) {
            this._writer.endPrefixMapping(this._namespacePrefixes[i]);
        }
        this._namespacePrefixesIndex = start;
    }

    private int processNamespaceAttributes(int item) throws SAXException {
        do {
            switch (FastInfosetWriterSAXBufferProcessor.getAIIState((int)item)) {
                case 1: {
                    this.processNamespaceAttribute("", "");
                    break;
                }
                case 2: {
                    this.processNamespaceAttribute(this.readStructureString(), "");
                    break;
                }
                case 3: {
                    this.processNamespaceAttribute(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    this.processNamespaceAttribute("", this.readStructureString());
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state: " + item);
                }
            }
            this.readStructure();
        } while (((item = this.peekStructure()) & 0xF0) == 64);
        this.cacheNamespacePrefixIndex();
        return item;
    }

    private void processAttributes(int item) throws SAXException {
        do {
            switch (FastInfosetWriterSAXBufferProcessor.getAIIState((int)item)) {
                case 1: {
                    this._attributes.addAttribute(this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readContentString());
                    break;
                }
                case 2: {
                    String p = this.readStructureString();
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this._attributes.addAttribute(u, ln, this.getQName(p, ln), this.readStructureString(), this.readContentString());
                    break;
                }
                case 3: {
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this._attributes.addAttribute(u, ln, ln, this.readStructureString(), this.readContentString());
                    break;
                }
                case 4: {
                    String ln = this.readStructureString();
                    this._attributes.addAttribute("", ln, ln, this.readStructureString(), this.readContentString());
                    break;
                }
                case 5: {
                    this.processAttributeValue(this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readStructureString());
                    break;
                }
                case 6: {
                    String p = this.readStructureString();
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this.processAttributeValue(u, ln, this.getQName(p, ln), this.readStructureString());
                    break;
                }
                case 7: {
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this.processAttributeValue(u, ln, ln, this.readStructureString());
                    break;
                }
                case 8: {
                    String ln = this.readStructureString();
                    this.processAttributeValue("", ln, ln, this.readStructureString());
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state: " + item);
                }
            }
            this.readStructure();
        } while (((item = this.peekStructure()) & 0xF0) == 48);
    }

    private void processAttributeValue(String u, String ln, String qn, String t) throws SAXException {
        ValueInstance v = (ValueInstance)this.readContentObject();
        if (v.type == ValueInstance.Type.encodingAlgorithm) {
            this._attributes.addAttributeWithAlgorithmData(u, ln, qn, null, v.id, v.instance);
        } else if (v.type == ValueInstance.Type.alphabet) {
            this._attributes.addAttribute(u, ln, qn, t, (String)v.instance, false, v.alphabet);
        } else {
            this._attributes.addAttribute(u, ln, qn, t, (String)v.instance, true, null);
        }
    }

    private void processNamespaceAttribute(String prefix, String uri) throws SAXException {
        this._writer.startPrefixMapping(prefix, uri);
        if (this._namespacePrefixesFeature) {
            if (!prefix.isEmpty()) {
                this._attributes.addAttribute("http://www.w3.org/2000/xmlns/", prefix, this.getQName("xmlns", prefix), "CDATA", uri);
            } else {
                this._attributes.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", "CDATA", uri);
            }
        }
        this.cacheNamespacePrefix(prefix);
    }

    private void cacheNamespacePrefix(String prefix) {
        if (this._namespacePrefixesIndex == this._namespacePrefixes.length) {
            String[] namespaceAttributes = new String[this._namespacePrefixesIndex * 3 / 2 + 1];
            System.arraycopy(this._namespacePrefixes, 0, namespaceAttributes, 0, this._namespacePrefixesIndex);
            this._namespacePrefixes = namespaceAttributes;
        }
        this._namespacePrefixes[this._namespacePrefixesIndex++] = prefix;
    }

    private void cacheNamespacePrefixIndex() {
        if (this._namespaceAttributesStackIndex == this._namespaceAttributesStack.length) {
            int[] namespaceAttributesStack = new int[this._namespaceAttributesStackIndex * 3 / 2 + 1];
            System.arraycopy(this._namespaceAttributesStack, 0, namespaceAttributesStack, 0, this._namespaceAttributesStackIndex);
            this._namespaceAttributesStack = namespaceAttributesStack;
        }
        this._namespaceAttributesStack[this._namespaceAttributesStackIndex++] = this._namespacePrefixesIndex;
    }

    private void processComment(String s) throws SAXException {
        this.processComment(s.toCharArray(), 0, s.length());
    }

    private void processComment(char[] ch, int start, int length) throws SAXException {
        this._writer.comment(ch, start, length);
    }

    private void processProcessingInstruction(String target, String data) throws SAXException {
        this._writer.processingInstruction(target, data);
    }
}

