/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.analysis.frequency;

import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaProcessor {
    private StringComparator _stringComparator = new StringComparator();
    private QNameComparator _qNameComparator = new QNameComparator();
    Set<QName> elements = new TreeSet<QName>(this._qNameComparator);
    Set<QName> attributes = new TreeSet<QName>(this._qNameComparator);
    Set<String> localNames = new TreeSet<String>(this._stringComparator);
    Set<String> namespaces = new TreeSet<String>(this._stringComparator);
    Set<String> prefixes = new TreeSet<String>(this._stringComparator);
    Set<String> attributeValues = new TreeSet<String>(this._stringComparator);
    Set<String> textContentValues = new TreeSet<String>(this._stringComparator);
    private List<URL> _schema;
    private boolean _collectValues;
    private boolean _generatePrefixes;
    private Map<String, String> _namespaceToPrefix = new HashMap<String, String>();
    private String _generatedPrefix = "a";

    public SchemaProcessor(URL schema) {
        this(schema, false, false);
    }

    public SchemaProcessor(URL schema, boolean collectValues, boolean generatePrefixes) {
        this._schema = new ArrayList<URL>();
        this._schema.add(schema);
        this._collectValues = collectValues;
        this._generatePrefixes = generatePrefixes;
    }

    public SchemaProcessor(List<URL> schema) {
        this(schema, false, false);
    }

    public SchemaProcessor(List<URL> schema, boolean collectValues, boolean generatePrefixes) {
        this._schema = schema;
        this._collectValues = collectValues;
        this._generatePrefixes = generatePrefixes;
    }

    public void process() throws Exception {
        InputSource s;
        XSOMParser parser = new XSOMParser();
        parser.setErrorHandler((ErrorHandler)new ErrorHandlerImpl());
        for (URL u : this._schema) {
            s = new InputSource(u.openStream());
            s.setSystemId(u.toString());
            parser.parse(s);
        }
        XSSchemaSet sset = parser.getResult();
        Iterator is = sset.iterateSchema();
        while (is.hasNext()) {
            s = (XSSchema)is.next();
            s.visit(new InternalSchemaProcessor());
        }
    }

    private void addAttribute(XSDeclaration d) {
        QName q = this.getQName(d);
        if ("http://www.w3.org/XML/1998/namespace".equals(q.getNamespaceURI())) {
            return;
        }
        this.attributes.add(q);
        this.addNamespaceLocalNameAndPrefix(q);
    }

    private void addElement(XSDeclaration d) {
        QName q = this.getQName(d);
        this.elements.add(q);
        this.addNamespaceLocalNameAndPrefix(q);
    }

    private void addNamespaceLocalNameAndPrefix(QName q) {
        this.localNames.add(q.getLocalPart());
        String namespaceURI = q.getNamespaceURI();
        if (this.hasProcessibleNamespaceURI(namespaceURI)) {
            this.namespaces.add(namespaceURI);
            String prefix = q.getPrefix();
            if (prefix != null) {
                this.prefixes.add(prefix);
            }
        }
    }

    private void addAttributeValue(String s) {
        if (this._collectValues) {
            this.attributeValues.add(s);
        }
    }

    private void addTextContentValue(String s) {
        if (this._collectValues) {
            this.textContentValues.add(s);
        }
    }

    private QName getQName(XSDeclaration d) {
        String n = d.getTargetNamespace();
        String l = d.getName();
        if (this._generatePrefixes && this.hasProcessibleNamespaceURI(n)) {
            String p = this._namespaceToPrefix.get(n);
            if (p == null) {
                p = this._generatedPrefix;
                this._namespaceToPrefix.put(n, p);
                this.nextGeneratedPrefix();
            }
            return new QName(n, l, p);
        }
        return new QName(n, l);
    }

    private void nextGeneratedPrefix() {
        char c = this._generatedPrefix.charAt(0);
        this._generatedPrefix = (c = (char)(c + '\u0001')) < 'z' ? c + this._generatedPrefix.substring(1) : "a" + this._generatedPrefix;
    }

    private boolean hasProcessibleNamespaceURI(String namespaceURI) {
        return namespaceURI != "" && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace");
    }

    private void print() {
        System.out.println("Prefixes");
        System.out.println("----------");
        int i = 1;
        for (String s : this.prefixes) {
            System.out.println(i++ + ": " + s);
        }
        System.out.println("Namespaces");
        System.out.println("----------");
        i = 1;
        for (String s : this.namespaces) {
            System.out.println(i++ + ": " + s);
        }
        System.out.println("LocaNames");
        System.out.println("---------");
        i = 1;
        for (String s : this.localNames) {
            System.out.println(i++ + ": " + s);
        }
        System.out.println("Elements");
        System.out.println("--------");
        i = 1;
        for (QName q : this.elements) {
            System.out.println(i++ + ": " + q);
        }
        System.out.println("Attributes");
        System.out.println("----------");
        i = 1;
        for (QName q : this.attributes) {
            System.out.println(i++ + ": " + q);
        }
    }

    public static void main(String[] args) throws Exception {
        SchemaProcessor v = new SchemaProcessor(new File(args[0]).toURL(), true, true);
        v.process();
        v.print();
    }

    private static class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        public void warning(SAXParseException e) throws SAXException {
            System.out.println("WARNING");
            e.printStackTrace();
        }

        public void error(SAXParseException e) throws SAXException {
            System.out.println("ERROR");
            e.printStackTrace();
        }

        public void fatalError(SAXParseException e) throws SAXException {
            System.out.println("FATAL ERROR");
            e.printStackTrace();
        }
    }

    private class InternalSchemaProcessor
    implements XSVisitor,
    XSSimpleTypeVisitor {
        private InternalSchemaProcessor() {
        }

        public void annotation(XSAnnotation xSAnnotation) {
        }

        public void attGroupDecl(XSAttGroupDecl decl) {
            Iterator itr = decl.iterateAttGroups();
            while (itr.hasNext()) {
                SchemaProcessor.this.addAttribute((XSDeclaration)((XSAttGroupDecl)itr.next()));
            }
            itr = decl.iterateDeclaredAttributeUses();
            while (itr.hasNext()) {
                this.attributeUse((XSAttributeUse)itr.next());
            }
        }

        public void attributeDecl(XSAttributeDecl xSAttributeDecl) {
            if (xSAttributeDecl.getDefaultValue() != null) {
                SchemaProcessor.this.addAttributeValue(xSAttributeDecl.getDefaultValue().value);
            }
            SchemaProcessor.this.addAttribute((XSDeclaration)xSAttributeDecl);
            if (xSAttributeDecl.getType().isRestriction()) {
                for (XSFacet f : xSAttributeDecl.getType().asRestriction().getDeclaredFacets("enumeration")) {
                    SchemaProcessor.this.addAttributeValue(f.getValue().value);
                }
            }
        }

        public void attributeUse(XSAttributeUse use) {
            XSAttributeDecl decl = use.getDecl();
            this.attributeDecl(decl);
        }

        public void complexType(XSComplexType type) {
            XSType baseType;
            if (type.getContentType().asSimpleType() != null) {
                baseType = type.getBaseType();
                if (type.getDerivationMethod() != 2 && type.getTargetNamespace().compareTo(baseType.getTargetNamespace()) == 0 && type.getName().compareTo(baseType.getName()) == 0) {
                    baseType.visit((XSVisitor)this);
                }
            } else {
                baseType = type.getBaseType().asComplexType();
                if (type.getDerivationMethod() != 2) {
                    if (type.getTargetNamespace().compareTo(baseType.getTargetNamespace()) == 0 && type.getName().compareTo(baseType.getName()) == 0) {
                        baseType.visit((XSVisitor)this);
                    }
                    type.getExplicitContent().visit((XSVisitor)this);
                }
                type.getContentType().visit((XSVisitor)this);
            }
            Iterator itr = type.iterateAttGroups();
            while (itr.hasNext()) {
                SchemaProcessor.this.addAttribute((XSDeclaration)((XSAttGroupDecl)itr.next()));
            }
            itr = type.iterateDeclaredAttributeUses();
            while (itr.hasNext()) {
                this.attributeUse((XSAttributeUse)itr.next());
            }
        }

        public void schema(XSSchema s) {
            for (XSAttGroupDecl groupDecl : s.getAttGroupDecls().values()) {
                this.attGroupDecl(groupDecl);
            }
            for (XSAttributeDecl attrDecl : s.getAttributeDecls().values()) {
                this.attributeDecl(attrDecl);
            }
            for (XSComplexType complexType : s.getComplexTypes().values()) {
                this.complexType(complexType);
            }
            for (XSElementDecl elementDecl : s.getElementDecls().values()) {
                this.elementDecl(elementDecl);
            }
            for (XSModelGroupDecl modelGroupDecl : s.getModelGroupDecls().values()) {
                this.modelGroupDecl(modelGroupDecl);
            }
            for (XSSimpleType simpleType : s.getSimpleTypes().values()) {
                this.simpleType(simpleType);
            }
        }

        public void facet(XSFacet facet) {
            if (facet.getName().equals("enumeration")) {
                SchemaProcessor.this.addAttributeValue(facet.getValue().value);
                SchemaProcessor.this.addTextContentValue(facet.getValue().value);
            }
        }

        public void notation(XSNotation xSNotation) {
        }

        public void identityConstraint(XSIdentityConstraint xSIdentityConstraint) {
        }

        public void xpath(XSXPath xSXPath) {
        }

        public void wildcard(XSWildcard xSWildcard) {
        }

        public void modelGroupDecl(XSModelGroupDecl decl) {
            this.modelGroup(decl.getModelGroup());
        }

        public void modelGroup(XSModelGroup group) {
            int len = group.getSize();
            for (int i = 0; i < len; ++i) {
                this.particle(group.getChild(i));
            }
        }

        public void elementDecl(XSElementDecl type) {
            if (type.getDefaultValue() != null) {
                SchemaProcessor.this.addTextContentValue(type.getDefaultValue().value);
            }
            if (type.getType().isSimpleType() && type.getType().asSimpleType().isRestriction()) {
                XSSimpleType s = type.getType().asSimpleType();
                for (XSFacet f : s.asRestriction().getDeclaredFacets("enumeration")) {
                    SchemaProcessor.this.addTextContentValue(f.getValue().value);
                }
            }
            SchemaProcessor.this.addElement((XSDeclaration)type);
        }

        public void particle(XSParticle part) {
            part.getTerm().visit((XSVisitor)this);
        }

        public void empty(XSContentType xSContentType) {
        }

        public void simpleType(XSSimpleType type) {
            type.visit((XSSimpleTypeVisitor)this);
        }

        public void listSimpleType(XSListSimpleType xSListSimpleType) {
        }

        public void unionSimpleType(XSUnionSimpleType type) {
            int len = type.getMemberSize();
            for (int i = 0; i < len; ++i) {
                XSSimpleType member = type.getMember(i);
                if (!member.isLocal()) continue;
                this.simpleType(member);
            }
        }

        public void restrictionSimpleType(XSRestrictionSimpleType type) {
            XSSimpleType baseType = type.getSimpleBaseType();
            if (baseType == null) {
                return;
            }
            if (baseType.isLocal()) {
                this.simpleType(baseType);
            }
            Iterator itr = type.iterateDeclaredFacets();
            while (itr.hasNext()) {
                this.facet((XSFacet)itr.next());
            }
        }
    }

    private static class QNameComparator
    implements Comparator,
    Serializable {
        private QNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            QName q1 = (QName)o1;
            QName q2 = (QName)o2;
            if (q1.getNamespaceURI() == null && q2.getNamespaceURI() == null) {
                return q1.getLocalPart().compareTo(q2.getLocalPart());
            }
            if (q1.getNamespaceURI() == null) {
                return 1;
            }
            if (q2.getNamespaceURI() == null) {
                return -1;
            }
            int c = q1.getNamespaceURI().compareTo(q2.getNamespaceURI());
            if (c != 0) {
                return c;
            }
            return q1.getLocalPart().compareTo(q2.getLocalPart());
        }
    }

    private static class StringComparator
    implements Comparator,
    Serializable {
        private StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

