/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.utilities.tools;

import com.sun.xml.analysis.types.SchemaProcessor;
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import com.sun.xml.fastinfoset.streambuffer.FastInfosetWriterSAXBufferProcessor;
import com.sun.xml.fastinfoset.streambuffer.TypedSAXBufferCreator;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jvnet.fastinfoset.sax.FastInfosetWriter;
import org.xml.sax.XMLReader;

public class XML_SAX_TYPED_FI {
    public void parse(String[] args) throws Exception {
        String schemaLocation = null;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        if (args.length == 1) {
            schemaLocation = args[0];
            in = new BufferedInputStream(System.in);
            out = new BufferedOutputStream(System.out);
        } else if (args.length == 2) {
            schemaLocation = args[0];
            in = new BufferedInputStream(new FileInputStream(args[1]));
            out = new BufferedOutputStream(System.out);
        } else if (args.length == 3) {
            schemaLocation = args[0];
            in = new BufferedInputStream(new FileInputStream(args[1]));
            out = new BufferedOutputStream(new FileOutputStream(args[2]));
        } else {
            throw new IllegalArgumentException("Incorrect arguments: schema <in> <out>");
        }
        this.parse(schemaLocation, in, out);
    }

    public void parse(String schemaLocation, InputStream xml, OutputStream fi) throws Exception {
        XMLStreamBuffer source = this.createBufferFromXMLDocument(schemaLocation, xml);
        FastInfosetWriterSAXBufferProcessor processor = new FastInfosetWriterSAXBufferProcessor();
        processor.setXMLStreamBuffer(source);
        SAXDocumentSerializer serializer = this.getSerializer(fi);
        processor.process((FastInfosetWriter)serializer);
    }

    private SAXParser getParser() throws Exception {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory.newSAXParser();
    }

    private SAXDocumentSerializer getSerializer(OutputStream fi) {
        SAXDocumentSerializer documentSerializer = new SAXDocumentSerializer();
        documentSerializer.setOutputStream(fi);
        return documentSerializer;
    }

    private XMLStreamBuffer createBufferFromXMLDocument(String schemaLocation, InputStream xml) throws Exception {
        XMLReader reader = this.getParser().getXMLReader();
        if (schemaLocation != null) {
            SchemaProcessor sp = new SchemaProcessor(new File(schemaLocation).toURL());
            sp.process();
            return TypedSAXBufferCreator.createNewBufferFromXMLReader(sp.getElementToXSDataTypeMap(), sp.getAttributeToXSDataTypeMap(), reader, xml);
        }
        return XMLStreamBuffer.createNewBufferFromXMLReader((XMLReader)reader, (InputStream)xml);
    }

    public static void main(String[] args) throws Exception {
        XML_SAX_TYPED_FI s = new XML_SAX_TYPED_FI();
        s.parse(args);
    }
}

