/*
 * Decompiled with CFR 0.152.
 */
package samples.transform;

import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class XMLToFastInfosetSAXSerializer {
    Transformer _transformer;
    DocumentBuilder _docBuilder;
    DOMSource _source = null;
    SAXResult _result = null;

    public XMLToFastInfosetSAXSerializer() {
        try {
            this._transformer = TransformerFactory.newInstance().newTransformer();
            this._docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void getDOMSource(File input) {
        try {
            FileInputStream fis = new FileInputStream(input);
            Document document = this._docBuilder.parse(fis);
            fis.close();
            this._source = new DOMSource(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void getSAXResult(File output) {
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(output));
            SAXDocumentSerializer serializer = new SAXDocumentSerializer();
            serializer.setOutputStream((OutputStream)fos);
            this._result = new SAXResult();
            this._result.setHandler((ContentHandler)serializer);
            this._result.setLexicalHandler((LexicalHandler)serializer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(File input, File output) {
        this.getDOMSource(input);
        this.getSAXResult(output);
        if (this._source != null && this._result != null) {
            try {
                System.out.println("Transforming " + input.getName() + " into " + output.getName());
                this._transformer.transform(this._source, this._result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("\ndone.");
        } else {
            System.out.println("Source or Result could not be null.");
        }
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 4) {
            XMLToFastInfosetSAXSerializer.displayUsageAndExit();
        }
        try {
            File input = new File(args[0]);
            File ouput = new File(args[1]);
            XMLToFastInfosetSAXSerializer docSerializer = new XMLToFastInfosetSAXSerializer();
            docSerializer.write(input, ouput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void displayUsageAndExit() {
        System.err.println("Usage: ant FISAXSerialixer or samples.sax.FISerializer XML_input_file FI_output_file");
        System.exit(1);
    }
}

