package com.sun.tools.xjc;

import java.io.PrintStream;

import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.outline.Outline;

/**
 * Call-back interface that can be implemented by the caller of {@link Driver}
 * to receive output from XJC.
 *
 * <p>
 * Most of the messages XJC produce once the real work starts is structured
 * as (message,source). Those outputs will be reported to various methods on
 * {@link ErrorListener}, which is inherited by this interface.
 *
 * <p>
 * The other messages (such as the usage screen when there was an error in
 * the command line option) will go to the {@link #message(String)} method.
 *
 * @author Kohsuke Kawaguchi
 * @since JAXB 2.0 EA
 */
public abstract class XJCListener implements ErrorListener {

    /**
     * Called for each file generated by XJC.
     *
     * <p>
     * XJC may generate not only source files but also resources files.
     * The file name includes the path portions that correspond with the package name.
     *
     * <p>
     * When generating files into a directory, file names will be relative to the
     * output directory. When generating files into a zip file, file names will be
     * those in the zip file.
     *
     * @param fileName
     *      file names like "org/acme/foo/Foo.java" or "org/acme/foo/jaxb.properties".
     */
    public void generatedFile(String fileName) {}

    /**
     * Other miscellenous messages that do not have structures
     * will be reported through this method.
     *
     * This method is used like {@link PrintStream#println(String)}.
     * The callee is expected to add '\n'. 
     */
    public void message(String msg) {}

    /**
     * Called after the schema is compiled and the code generation strategy is determined,
     * but before any code is actually generated as files.
     *
     * @param outline
     *      never null. this is the root object that represents the code generation strategy.
     */
    public void compiled(Outline outline) {}
}
