/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.serializer;

import com.sun.xml.bind.serializer.XMLSerializer;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ContentHandlerAdaptor
implements ContentHandler {
    private final ArrayList prefixMap = new ArrayList();
    private final XMLSerializer serializer;
    private final StringBuffer text = new StringBuffer();

    public ContentHandlerAdaptor(XMLSerializer _serializer) {
        this.serializer = _serializer;
    }

    @Override
    public void startDocument() throws SAXException {
        this.prefixMap.clear();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMap.add(prefix);
        this.prefixMap.add(uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.flushText();
        this.serializer.startElement(namespaceURI, localName);
        for (int i = 0; i < atts.getLength(); ++i) {
            this.serializer.startAttribute(atts.getURI(i), atts.getLocalName(i));
            this.serializer.text(atts.getValue(i));
            this.serializer.endAttribute();
        }
        this.prefixMap.clear();
        this.serializer.endAttributes();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushText();
        this.serializer.endElement();
    }

    private void flushText() throws SAXException {
        if (this.text.length() != 0) {
            this.serializer.text(this.text.toString());
            this.text.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

