/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

import com.sun.xml.bind.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class ContextFactory_1_0_1 {
    public static final String RUNTIME_KEY = "com.sun.xml.bind.jaxbContextImpl";

    public static JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        Class<?> cls;
        String packageName = new StringTokenizer(contextPath, ":").nextToken();
        try {
            String propFileName = packageName.replace('.', '/') + "/jaxb.properties";
            Properties props = ContextFactory_1_0_1.loadJAXBProperties(classLoader, propFileName);
            String jaxbContextImplClassName = props.getProperty(RUNTIME_KEY);
            if (jaxbContextImplClassName == null) {
                throw new JAXBException(Messages.format((String)"ContextFactory.IncorrectVersion", (Object)packageName));
            }
            cls = classLoader.loadClass(jaxbContextImplClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException((Throwable)e);
        }
        try {
            return (JAXBContext)cls.getConstructor(String.class, ClassLoader.class).newInstance(contextPath, classLoader);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            throw new JAXBException(t);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new JAXBException((Throwable)e);
        }
    }

    private static Properties loadJAXBProperties(ClassLoader classLoader, String propFileName) throws JAXBException {
        try {
            InputStream is = classLoader.getResourceAsStream(propFileName);
            if (is == null) {
                return null;
            }
            Properties props = new Properties();
            props.load(is);
            is.close();
            return props;
        }
        catch (IOException ioe) {
            throw new JAXBException(ioe.toString(), (Throwable)ioe);
        }
    }
}

