/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.writer;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class FileCodeWriter
extends CodeWriter {
    private final File target;
    private final boolean readOnly;
    private final Set<File> readonlyFiles = new HashSet<File>();

    public FileCodeWriter(File target) throws IOException {
        this(target, false);
    }

    public FileCodeWriter(File target, String encoding) throws IOException {
        this(target, false, encoding);
    }

    public FileCodeWriter(File target, boolean readOnly) throws IOException {
        this(target, readOnly, null);
    }

    public FileCodeWriter(File target, boolean readOnly, String encoding) throws IOException {
        this.target = target;
        this.readOnly = readOnly;
        this.encoding = encoding;
        if (!target.exists() || !target.isDirectory()) {
            throw new IOException(target + ": non-existent directory");
        }
    }

    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        return new FileOutputStream(this.getFile(pkg, fileName));
    }

    protected File getFile(JPackage pkg, String fileName) throws IOException {
        File fn;
        File dir = pkg.isUnnamed() ? this.target : new File(this.target, FileCodeWriter.toDirName(pkg));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((fn = new File(dir, fileName)).exists() && !fn.delete()) {
            throw new IOException(fn + ": Can't delete previous version");
        }
        if (this.readOnly) {
            this.readonlyFiles.add(fn);
        }
        return fn;
    }

    public void close() throws IOException {
        for (File f : this.readonlyFiles) {
            f.setReadOnly();
        }
    }

    private static String toDirName(JPackage pkg) {
        return pkg.name().replace('.', File.separatorChar);
    }
}

