/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.merge.JSR68Merger;
import com.sun.tdk.signaturetest.merge.MergedSigFile;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Merge
extends SigTest
implements Log {
    public static final String FILES_OPTION = "-Files";
    public static final String WRITE_OPTION = "-Write";
    public static final String BINARY_OPTION = "-Binary";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Merge.class);
    private boolean binary = false;
    private String resultedFile;
    private String[] signatureFiles;

    public static void main(String[] args) {
        Merge m = Merge.getInstance();
        m.run(args, new PrintWriter(System.err, true), null);
        m.exit();
    }

    protected static Merge getInstance() {
        return new Merge();
    }

    public void run(String[] args, PrintWriter pw, PrintWriter ref) {
        this.setLog(pw);
        if (this.parseParameters(args)) {
            this.perform();
            this.getLog().flush();
        } else if (args.length > 0 && args[0].equalsIgnoreCase("-Version")) {
            System.err.println(Version.getVersionInfo());
        } else {
            this.usage();
        }
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        this.initErrors();
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], "-Help") || parser.isOptionSpecified(args[0], "-?"))) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption(FILES_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(WRITE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(BINARY_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Help", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-TestURL", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Version", OptionInfo.optionalFlag(), "decodeOptions");
        try {
            parser.processArgs(args);
            if (this.resultedFile != null) {
                this.checkValidWriteFile();
            }
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        return this.passed();
    }

    private void checkValidWriteFile() throws CommandLineParserException {
        File canonicalFile = null;
        try {
            canonicalFile = new File(this.resultedFile).getCanonicalFile();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.resultedFile));
        }
        for (int i = 0; i < this.signatureFiles.length; ++i) {
            try {
                File sigFile = new File(this.signatureFiles[i]).getCanonicalFile();
                if (!canonicalFile.equals(sigFile)) continue;
                throw new CommandLineParserException(i18n.getString("Merge.notunique.writefile"));
            }
            catch (IOException ex) {
                throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.signatureFiles[i]));
            }
        }
        try {
            FileOutputStream f = new FileOutputStream(this.resultedFile);
            f.close();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.create.write.file"));
        }
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(FILES_OPTION)) {
            StringTokenizer st = new StringTokenizer(args[0], File.pathSeparator);
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreElements()) {
                list.add(st.nextToken());
            }
            this.signatureFiles = list.toArray(new String[0]);
        } else if (optionName.equalsIgnoreCase(WRITE_OPTION)) {
            this.resultedFile = args[0];
        } else if (optionName.equalsIgnoreCase(BINARY_OPTION)) {
            this.binary = true;
        } else if (optionName.equalsIgnoreCase("-TestURL")) {
            this.testURL = args[0];
        }
    }

    void perform() {
        ClassDescription c;
        MemberCollectionBuilder builder;
        MergedSigFile[] files = new MergedSigFile[this.signatureFiles.length];
        PrintWriter log = new PrintWriter(System.out);
        FeaturesHolder fh = new FeaturesHolder();
        for (int i = 0; i < this.signatureFiles.length; ++i) {
            String sigFiles = this.signatureFiles[i];
            MultipleFileReader in = new MultipleFileReader(log, 1, this.getFileManager());
            if (!in.readSignatureFiles(this.testURL, sigFiles)) {
                String msg = i18n.getString("SignatureTest.error.sigfile.invalid", sigFiles);
                in.close();
                this.error(msg);
            }
            files[i] = new MergedSigFile(in, this);
            if (i == 0) {
                fh.setFeatures(in.getSupportedFeatures());
            } else {
                fh.retainFeatures(in.getSupportedFeatures());
            }
            builder = new MemberCollectionBuilder(new SilentLog());
            Iterator it = files[i].getClassSet().values().iterator();
            while (it.hasNext()) {
                c = (ClassDescription)it.next();
                c.setHierarchy(files[i].getClassHierarchy());
                try {
                    if (in.isFeatureSupported(FeaturesHolder.BuildMembers)) {
                        builder.createMembers(c, true, true, false);
                    }
                    this.normalizer.normThrows(c, true);
                }
                catch (ClassNotFoundException e) {}
            }
        }
        JSR68Merger merger = new JSR68Merger(this, this, fh);
        VirtualClassDescriptionLoader result = merger.merge(files, this.binary ? 1 : 0);
        if (!this.isPassed()) {
            this.printErrors();
            return;
        }
        ClassHierarchyImpl ch = new ClassHierarchyImpl(result, 2);
        Iterator i = result.getClassIterator();
        while (i.hasNext()) {
            ClassDescription c2 = (ClassDescription)i.next();
            c2.setHierarchy(ch);
        }
        builder = new MemberCollectionBuilder(new SilentLog());
        Iterator i2 = result.getClassIterator();
        while (i2.hasNext()) {
            c = (ClassDescription)i2.next();
            try {
                builder.createMembers(c, false, true, false);
                this.normalizer.normThrows(c, true);
            }
            catch (ClassNotFoundException e) {
                this.storeError(i18n.getString("Merge.warning.message.classnotfound", e.getMessage()), null);
            }
        }
        try {
            Writer writer = this.getFileManager().getWriter(merger.getSupportedFeatures());
            if (writer == null) {
                this.failed("Could not find a writer for given sigtest file formats.");
                return;
            }
            writer.setApiVersion("");
            if (this.resultedFile != null) {
                writer.init(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.resultedFile), "UTF8")));
            } else {
                writer.init(new PrintWriter(System.out));
            }
            Iterator it = merger.getSupportedFeatures().iterator();
            while (it.hasNext()) {
                writer.addFeature((FeaturesHolder.Feature)it.next());
            }
            writer.writeHeader();
            Iterator i3 = result.getClassIterator();
            while (i3.hasNext()) {
                ClassDescription c3 = (ClassDescription)i3.next();
                writer.write(c3);
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error(e.getMessage());
        }
        this.printErrors();
    }

    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(nl).append(this.getComponentName() + " - " + i18n.getString("SignatureTest.usage.version", "2.2"));
        sb.append(nl).append(i18n.getString("Setup.usage.start"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Merge.usage.files", FILES_OPTION));
        sb.append(nl).append(i18n.getString("Merge.usage.write", WRITE_OPTION));
        sb.append(nl).append(i18n.getString("Merge.usage.binary", BINARY_OPTION));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SetupAndTest.helpusage.version", "-Version"));
        sb.append(nl).append(i18n.getString("Setup.usage.help", "-Help"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.usage.end"));
        System.err.println(sb.toString());
    }

    protected String getComponentName() {
        return "Merge";
    }

    class SilentLog
    implements Log {
        SilentLog() {
        }

        public void storeError(String s, Logger utilLogger) {
        }

        public void storeWarning(String s, Logger utilLogger) {
        }
    }
}

