/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.LicenseAction;
import com.sun.pkg.client.Manifest;
import com.sun.pkg.client.SystemInfo;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class Client {
    static final String usage = "Usage:\n    java -jar pkg-client.jar [options] command [cmd_options] [operands]\nwhere command is one of:\n    list [-a]            - list packages, list all with -a\n    install [-l] pkgs... - install packages, list license(s) with -l\n    uninstall pkgs...    - uninstall packages\n    refresh              - refresh the catalogs\n    proxy                - print information about proxy being used\n";

    Client() {
    }

    public static void main(String[] args) throws Exception {
        Logger cl = Logger.getLogger("com.sun.pkg.client");
        cl.setLevel(Level.WARNING);
        File cwd = new File(System.getProperty("user.dir"));
        if (args.length >= 1 && args[0].equals("list")) {
            boolean all = false;
            if (args.length >= 2 && args[1].equals("-a")) {
                all = true;
            }
            Image img = new Image(cwd);
            List<Image.FmriState> list = img.getInventory(null, all);
            for (Image.FmriState fs : list) {
                StringBuffer sb = new StringBuffer();
                StringBuffer flags = new StringBuffer();
                sb.append(fs.fmri.toString());
                sb.append(" - " + fs.fmri.getAuthority());
                if (fs.installed) {
                    flags.append("I");
                }
                if (fs.upgradable) {
                    flags.append("U");
                }
                if (flags.length() > 0) {
                    sb.append(" (").append(flags).append(")");
                }
                System.out.println(sb);
            }
        } else if (args.length == 1 && args[0].equals("refresh")) {
            Image img = new Image(cwd);
            img.refreshCatalogs();
        } else if (args.length >= 1 && args[0].equals("install")) {
            boolean showLicenses = false;
            ArrayList<String> pnames = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equals("-l")) {
                    showLicenses = true;
                    continue;
                }
                pnames.add(args[i]);
            }
            Image img = new Image(cwd);
            if (showLicenses) {
                Image.ImagePlan ip = img.makeInstallPlan(pnames.toArray(new String[0]));
                StringBuffer licenseText = new StringBuffer();
                for (Fmri f : ip.getProposedFmris()) {
                    Manifest m = img.getManifest(f);
                    List<LicenseAction> lla = m.getActionsByType(LicenseAction.class);
                    for (LicenseAction la : lla) {
                        licenseText.append("===== ").append(la.getName()).append(" =====\n");
                        licenseText.append("\n");
                        licenseText.append(la.getText());
                        licenseText.append("\n\n");
                    }
                }
                if (licenseText.length() > 0) {
                    System.out.println(licenseText);
                }
                ip.execute();
            } else {
                img.installPackages(pnames.toArray(new String[0]));
            }
        } else if (args.length >= 1 && args[0].equals("uninstall")) {
            String[] pnames = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                pnames[i - 1] = args[i];
            }
            Image img = new Image(cwd);
            img.uninstallPackages(pnames);
        } else if (args.length == 1 && args[0].equals("proxy")) {
            Proxy p = SystemInfo.getProxy();
            if (p == null) {
                System.out.println("no proxy");
            } else {
                InetSocketAddress isa = (InetSocketAddress)p.address();
                System.out.println("proxy: " + isa.getHostName() + ":" + isa.getPort());
            }
        } else if (args.length != 1 || !args[0].equals("test")) {
            System.err.println(usage);
            System.exit(1);
        }
        System.exit(0);
    }
}

