/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Instruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Param;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Template;
import com.sun.org.apache.xalan.internal.xsltc.compiler.WithParam;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import com.sun.org.apache.xml.internal.utils.XML11Char;
import java.util.Vector;

final class CallTemplate
extends Instruction {
    private QName _name;
    private Object[] _parameters = null;
    private Template _calleeTemplate = null;

    CallTemplate() {
    }

    public void display(int indent) {
        this.indent(indent);
        System.out.print("CallTemplate");
        Util.println(" name " + this._name);
        this.displayContents(indent + 4);
    }

    public boolean hasWithParams() {
        return this.elementCount() > 0;
    }

    public void parseContents(Parser parser) {
        String name = this.getAttribute("name");
        if (name.length() > 0) {
            if (!XML11Char.isXML11ValidQName(name)) {
                ErrorMsg err = new ErrorMsg("INVALID_QNAME_ERR", (Object)name, this);
                parser.reportError(3, err);
            }
            this._name = parser.getQNameIgnoreDefaultNs(name);
        } else {
            this.reportError(this, parser, "REQUIRED_ATTR_ERR", "name");
        }
        this.parseChildren(parser);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Template template = stable.lookupTemplate(this._name);
        if (template == null) {
            ErrorMsg err = new ErrorMsg("TEMPLATE_UNDEF_ERR", (Object)this._name, this);
            throw new TypeCheckError(err);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        Stylesheet stylesheet = classGen.getStylesheet();
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (stylesheet.hasLocalParams() || this.hasContents()) {
            this._calleeTemplate = this.getCalleeTemplate();
            if (this._calleeTemplate != null) {
                this.buildParameterList();
            } else {
                int push = cpg.addMethodref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "pushParamFrame", "()V");
                il.append(classGen.loadTranslet());
                il.append(new INVOKEVIRTUAL(push));
                this.translateContents(classGen, methodGen);
            }
        }
        String className = stylesheet.getClassName();
        String methodName = Util.escape(this._name.toString());
        il.append(classGen.loadTranslet());
        il.append(methodGen.loadDOM());
        il.append(methodGen.loadIterator());
        il.append(methodGen.loadHandler());
        il.append(methodGen.loadCurrentNode());
        StringBuffer methodSig = new StringBuffer("(Lcom/sun/org/apache/xalan/internal/xsltc/DOM;Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;Lcom/sun/org/apache/xml/internal/serializer/SerializationHandler;I");
        if (this._calleeTemplate != null) {
            Vector calleeParams = this._calleeTemplate.getParameters();
            int numParams = this._parameters.length;
            for (int i = 0; i < numParams; ++i) {
                SyntaxTreeNode node = (SyntaxTreeNode)this._parameters[i];
                methodSig.append("Ljava/lang/Object;");
                if (node instanceof Param) {
                    il.append(ACONST_NULL);
                    continue;
                }
                node.translate(classGen, methodGen);
            }
        }
        methodSig.append(")V");
        il.append(new INVOKEVIRTUAL(cpg.addMethodref(className, methodName, methodSig.toString())));
        if (this._calleeTemplate == null && (stylesheet.hasLocalParams() || this.hasContents())) {
            int pop = cpg.addMethodref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "popParamFrame", "()V");
            il.append(classGen.loadTranslet());
            il.append(new INVOKEVIRTUAL(pop));
        }
    }

    public Template getCalleeTemplate() {
        Template foundTemplate = this.getXSLTC().getParser().getSymbolTable().lookupTemplate(this._name);
        return foundTemplate.isSimpleNamedTemplate() ? foundTemplate : null;
    }

    private void buildParameterList() {
        Vector defaultParams = this._calleeTemplate.getParameters();
        int numParams = defaultParams.size();
        this._parameters = new Object[numParams];
        for (int i = 0; i < numParams; ++i) {
            this._parameters[i] = defaultParams.elementAt(i);
        }
        int count = this.elementCount();
        block1: for (int i = 0; i < count; ++i) {
            Object node = this.elementAt(i);
            if (!(node instanceof WithParam)) continue;
            WithParam withParam = (WithParam)node;
            QName name = withParam.getName();
            for (int k = 0; k < numParams; ++k) {
                Object object = this._parameters[k];
                if (object instanceof Param && ((Param)object).getName() == name) {
                    withParam.setDoParameterOptimization(true);
                    this._parameters[k] = withParam;
                    continue block1;
                }
                if (!(object instanceof WithParam) || ((WithParam)object).getName() != name) continue;
                withParam.setDoParameterOptimization(true);
                this._parameters[k] = withParam;
                continue block1;
            }
        }
    }
}

