/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.validation;

import com.sun.messaging.jmq.jmsclient.validation.XMLValidator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;

public class ValidatorFactory {
    static final String TOPIC_PROP_NAME_PREFIX = "imq.xml.validate.topic";
    static final String QUEUE_PROP__NAME_PREFIX = "imq.xml.validate.queue";

    protected ValidatorFactory() {
    }

    public static ValidatorFactory newInstance() {
        return new ValidatorFactory();
    }

    public static XMLValidator newValidator() throws JMSException {
        return new XMLValidator();
    }

    public static XMLValidator newValidator(String string) throws JMSException {
        return new XMLValidator(string);
    }

    public static XMLValidator newValidator(String string, String string2) throws JMSException {
        return new XMLValidator(string, string2);
    }

    public static Hashtable getTopicValidateTable() {
        return ValidatorFactory.getValidateTable(TOPIC_PROP_NAME_PREFIX);
    }

    public static Hashtable getQueueValidateTable() {
        return ValidatorFactory.getValidateTable(QUEUE_PROP__NAME_PREFIX);
    }

    private static Hashtable getValidateTable(String string) {
        Hashtable<String, XMLValidator> hashtable = new Hashtable<String, XMLValidator>();
        try {
            Properties properties = System.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                int n = string.length() + 1;
                int n2 = string2.indexOf(46, n);
                String string3 = string2.substring(n, n2);
                String string4 = System.getProperty(string2);
                XMLValidator xMLValidator = null;
                xMLValidator = string4.length() > 4 ? ValidatorFactory.newValidator(string4) : ValidatorFactory.newValidator();
                hashtable.put(string3, xMLValidator);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }
}

