/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lookup.entry;

import java.awt.Image;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.jini.lookup.entry.ServiceType;

public class BasicServiceType
extends ServiceType {
    private static final long serialVersionUID = -9077088179092831351L;
    public String type;
    private transient ResourceBundle bundle;
    private transient boolean inited = false;

    public BasicServiceType() {
    }

    public BasicServiceType(String type) {
        this.type = type;
    }

    public Image getIcon(int iconKind) {
        this.init();
        if (this.bundle != null) {
            try {
                return (Image)this.bundle.getObject("icon." + iconKind);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getDisplayName() {
        this.init();
        if (this.bundle != null) {
            try {
                return this.bundle.getString("name");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.type.substring(this.type.lastIndexOf(46) + 1);
    }

    public String getShortDescription() {
        this.init();
        if (this.bundle != null) {
            try {
                return this.bundle.getString("desc");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private void init() {
        if (!this.inited) {
            String name = this.type;
            if (name.indexOf(46) < 0) {
                name = "net.jini.lookup.entry.servicetype." + name;
            }
            try {
                this.bundle = ResourceBundle.getBundle(name);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.inited = true;
        }
    }
}

