/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.storageservice.resources;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.samples.storageservice.Container;
import com.sun.jersey.samples.storageservice.Item;
import com.sun.jersey.samples.storageservice.MemoryStore;
import com.sun.jersey.samples.storageservice.resources.ItemResource;
import java.net.URI;
import java.util.Iterator;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Produces(value={"application/xml"})
public class ContainerResource {
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    String container;

    ContainerResource(UriInfo uriInfo, Request request, String container) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.container = container;
    }

    @GET
    public Container getContainer(@QueryParam(value="search") String search) {
        System.out.println("GET CONTAINER " + this.container + ", search = " + search);
        Container c = MemoryStore.MS.getContainer(this.container);
        if (c == null) {
            throw new NotFoundException("Container not found");
        }
        if (search != null) {
            c = c.clone();
            Iterator<Item> i = c.getItem().iterator();
            byte[] searchBytes = search.getBytes();
            while (i.hasNext()) {
                if (this.match(searchBytes, this.container, i.next().getName())) continue;
                i.remove();
            }
        }
        return c;
    }

    @PUT
    public Response putContainer() {
        System.out.println("PUT CONTAINER " + this.container);
        URI uri = this.uriInfo.getAbsolutePath();
        Container c = new Container(this.container, uri.toString());
        Response r = !MemoryStore.MS.hasContainer(c) ? Response.created((URI)uri).build() : Response.noContent().build();
        MemoryStore.MS.createContainer(c);
        return r;
    }

    @DELETE
    public void deleteContainer() {
        System.out.println("DELETE CONTAINER " + this.container);
        Container c = MemoryStore.MS.deleteContainer(this.container);
        if (c == null) {
            throw new NotFoundException("Container not found");
        }
    }

    @Path(value="{item: .+}")
    public ItemResource getItemResource(@PathParam(value="item") String item) {
        return new ItemResource(this.uriInfo, this.request, this.container, item);
    }

    private boolean match(byte[] search, String container, String item) {
        byte[] b = MemoryStore.MS.getItemData(container, item);
        block0: for (int i = 0; i < b.length - search.length + 1; ++i) {
            for (int j = 0; j < search.length; ++j) {
                if (b[i + j] != search[j]) continue block0;
            }
            return true;
        }
        return false;
    }
}

