/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.storageservice;

import com.sun.jersey.samples.storageservice.Container;
import com.sun.jersey.samples.storageservice.Containers;
import com.sun.jersey.samples.storageservice.Item;
import com.sun.jersey.samples.storageservice.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class MemoryStore
implements Store {
    public static final JAXBContext CONTEXT = MemoryStore.getContext();
    public static final MemoryStore MS = new MemoryStore();
    private Map<String, Container> containerMap = new HashMap<String, Container>();
    private Map<String, Map<String, byte[]>> dataMap = new HashMap<String, Map<String, byte[]>>();

    private static JAXBContext getContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{Containers.class, Container.class, Item.class});
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Containers getContainers() {
        Containers c = new Containers();
        ArrayList<Container> l = new ArrayList<Container>();
        l.addAll(this.containerMap.values());
        c.setContainer(l);
        return c;
    }

    public Container getContainer(String container) {
        return this.containerMap.get(container);
    }

    public boolean hasContainer(Container container) {
        return this.containerMap.get(container.getName()) != null;
    }

    public Container createContainer(Container container) {
        Container c = this.containerMap.get(container.getName());
        if (c != null) {
            return null;
        }
        this.containerMap.put(container.getName(), container);
        this.dataMap.put(container.getName(), new HashMap());
        return c;
    }

    public Container deleteContainer(String container) {
        Container c = this.containerMap.remove(container);
        if (c == null) {
            return null;
        }
        this.dataMap.remove(container);
        return c;
    }

    public boolean hasItem(String container, String item) {
        Container c = this.containerMap.get(container);
        if (c == null) {
            return false;
        }
        return c.getItem(item) != null;
    }

    public Item getItem(String container, String item) {
        Container c = this.containerMap.get(container);
        if (c == null) {
            return null;
        }
        return c.getItem(item);
    }

    public byte[] getItemData(String container, String item) {
        Container c = this.containerMap.get(container);
        if (c == null) {
            return null;
        }
        Map<String, byte[]> data = this.dataMap.get(container);
        return data != null ? data.get(item) : null;
    }

    public Item createOrUpdateItem(String container, Item item, byte[] content) {
        Container c = this.containerMap.get(container);
        if (c == null) {
            return null;
        }
        c.putItem(item);
        Map<String, byte[]> data = this.dataMap.get(container);
        data.put(item.getName(), content);
        return item;
    }

    public Item deleteItem(String container, String item) {
        Container c = this.containerMap.get(container);
        if (c == null) {
            return null;
        }
        Item i = c.removeItem(item);
        if (i != null) {
            Map<String, byte[]> data = this.dataMap.get(container);
            data.remove(item);
        }
        return i;
    }
}

