/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver;

import com.sun.grizzly.http.SelectorThread;
import com.sun.jersey.api.container.grizzly.GrizzlyWebContainerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;

public class Server {
    public static final URI BASE_URI = Server.getBaseURI();

    private static int getPort(int defaultPort) {
        String port = System.getenv("JERSEY_HTTP_PORT");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(Server.getPort(9998)).path("atom").build(new Object[0]);
    }

    protected static SelectorThread startServer() throws IOException {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("com.sun.jersey.config.property.packages", "com.sun.jersey.samples.atomserver.resources");
        System.out.println("Starting grizzly...");
        SelectorThread threadSelector = GrizzlyWebContainerFactory.create((URI)BASE_URI, initParams);
        return threadSelector;
    }

    public static void main(String[] args) throws IOException {
        SelectorThread threadSelector = Server.startServer();
        System.out.println(String.format("Jersey app started with WADL at  %s/application.wadl", BASE_URI));
        System.out.println("Hit return to stop...");
        System.in.read();
        threadSelector.stopEndpoint();
    }
}

