/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver;

import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;

public class Server {
    public static final URI BASE_URI = Server.getBaseURI();

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.test.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(Server.getPort(9998)).path("atom").build(new Object[0]);
    }

    protected static HttpServer startServer() throws IOException {
        PackagesResourceConfig rc = new PackagesResourceConfig(new String[]{"com.sun.jersey.samples.atomserver.resources"});
        System.out.println("Starting grizzly...");
        return GrizzlyServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)rc);
    }

    public static void main(String[] args) throws IOException {
        HttpServer httpServer = Server.startServer();
        System.out.println(String.format("Jersey app started with WADL at  %s/application.wadl", BASE_URI));
        System.out.println("Hit return to stop...");
        System.in.read();
        httpServer.stop();
    }
}

