/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver.resources;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.samples.atomserver.resources.FileStore;
import com.sun.jersey.spi.container.MessageBodyWorkers;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;

class AtomStore {
    private static final MediaType atomMediaType = new MediaType("application", "atom+xml");

    AtomStore() {
    }

    static String getCollectionPath() {
        return "collection";
    }

    static String getFeedPath() {
        return "collection/feed.xml";
    }

    static String getPath(String id) {
        return "collection/" + id;
    }

    static String getEntryPath(String id) {
        return AtomStore.getPath(id) + "/entry.xml";
    }

    static String getMediaPath(String id) {
        return AtomStore.getPath(id) + "/media";
    }

    static boolean hasMedia(String id) {
        String p = AtomStore.getMediaPath(id);
        return FileStore.FS.exists(p);
    }

    static void checkExistence(String path) {
        if (!FileStore.FS.exists(path)) {
            throw new NotFoundException("Entry does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Feed getFeedDocument() throws FeedException {
        InputStream in = null;
        FileStore fileStore = FileStore.FS;
        synchronized (fileStore) {
            in = FileStore.FS.getFileContents(AtomStore.getFeedPath());
        }
        WireFeedInput input = new WireFeedInput();
        WireFeed wireFeed = input.build((Reader)new InputStreamReader(in));
        return (Feed)wireFeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Feed getFeedDocument(MessageBodyWorkers bodyContext, URI feedUri) throws IOException, FeedException {
        InputStream in = null;
        FileStore fileStore = FileStore.FS;
        synchronized (fileStore) {
            in = FileStore.FS.getFileContents(AtomStore.getFeedPath());
            if (in == null) {
                in = AtomStore.createDefaultFeedDocument(bodyContext, feedUri.toString());
            }
        }
        WireFeedInput input = new WireFeedInput();
        WireFeed wireFeed = input.build((Reader)new InputStreamReader(in));
        return (Feed)wireFeed;
    }

    static void updateFeedDocumentWithNewEntry(MessageBodyWorkers bodyContext, Feed f, Entry e) throws IOException {
        f.getEntries().add(e);
        AtomStore.updateFeedDocument(bodyContext, f);
    }

    static void updateFeedDocumentRemovingEntry(MessageBodyWorkers bodyContext, Feed f, String id) throws IOException {
        Entry e = AtomStore.findEntry(id, f);
        f.getEntries().remove(e);
        AtomStore.updateFeedDocument(bodyContext, f);
    }

    static void updateFeedDocumentWithExistingEntry(MessageBodyWorkers bodyContext, Feed f, Entry e) throws IOException {
        Entry old = AtomStore.findEntry(e.getId(), f);
        f.getEntries().remove(old);
        f.getEntries().add(0, e);
        AtomStore.updateFeedDocument(bodyContext, f);
    }

    static Entry findEntry(String id, Feed f) {
        List l = f.getEntries();
        for (Object o : l) {
            Entry e = (Entry)o;
            if (!id.equals(e.getId())) continue;
            return e;
        }
        return null;
    }

    static void addLink(Entry e, String rel, URI uri) {
        Link l = new Link();
        l.setRel(rel);
        l.setHref(uri.toString());
        e.getOtherLinks().add(l);
    }

    static String getLink(Entry e, String rel) {
        List links = e.getOtherLinks();
        Link l = null;
        for (Object o : links) {
            l = (Link)o;
            if (!l.getRel().equals(rel)) continue;
            return l.getHref();
        }
        return null;
    }

    static void updateLink(Entry e, String rel, URI uri) {
        List links = e.getOtherLinks();
        Link l = null;
        for (Object o : links) {
            l = (Link)o;
            if (!l.getRel().equals(rel)) continue;
            links.remove(l);
            break;
        }
        l = new Link();
        l.setRel(rel);
        l.setHref(uri.toString());
        links.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateFeedDocument(MessageBodyWorkers bodyContext, Feed f) throws IOException {
        MessageBodyWriter ep = bodyContext.getMessageBodyWriter(Feed.class, null, null, atomMediaType);
        FileStore fileStore = FileStore.FS;
        synchronized (fileStore) {
            ep.writeTo((Object)f, f.getClass(), null, null, atomMediaType, null, FileStore.FS.getFileOutputStream(AtomStore.getFeedPath()));
        }
    }

    static void createEntryDocument(MessageBodyWorkers bodyContext, String id, Entry e) throws IOException {
        MessageBodyWriter ep = bodyContext.getMessageBodyWriter(Entry.class, null, null, atomMediaType);
        String path = AtomStore.getEntryPath(id);
        ep.writeTo((Object)e, e.getClass(), null, null, atomMediaType, null, FileStore.FS.getFileOutputStream(path));
    }

    static void createMediaDocument(String id, byte[] content) throws IOException {
        String path = AtomStore.getMediaPath(id);
        OutputStream o = FileStore.FS.getFileOutputStream(path);
        o.write(content);
        o.close();
    }

    static void deleteEntry(String entryId) {
        FileStore.FS.deleteDirectory(AtomStore.getPath(entryId));
    }

    static InputStream createDefaultFeedDocument(MessageBodyWorkers bodyContext, String uri) throws IOException {
        Feed f = new Feed();
        f.setTitle("Feed");
        Link selfLink = new Link();
        selfLink.setRel("self");
        selfLink.setHref(uri);
        f.getOtherLinks().add(selfLink);
        MessageBodyWriter ep = bodyContext.getMessageBodyWriter(Feed.class, null, null, atomMediaType);
        ep.writeTo((Object)f, f.getClass(), null, null, atomMediaType, null, FileStore.FS.getFileOutputStream(AtomStore.getFeedPath()));
        return FileStore.FS.getFileContents(AtomStore.getFeedPath());
    }

    static Entry createDefaulMediaLinkEntryDocument() {
        Entry e = new Entry();
        e.setTitle("Media Entry");
        Date d = new Date();
        e.setCreated(d);
        e.setUpdated(d);
        return e;
    }
}

