/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.mandel;

import com.sun.jersey.samples.mandel.Complex;
import com.sun.jersey.samples.mandel.ParallelMandelRenderer;
import java.awt.image.BufferedImage;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import scala.ScalaObject;

@Path(value="({lx},{ly}),({ux},{uy})")
public class MandelService
implements ScalaObject {
    private final int height;
    private final int width;
    private final double dy;
    private final double dx;
    private final Complex upper;
    private final Complex lower;
    @DefaultValue(value="8")
    @QueryParam(value="workers")
    private final int workers;
    @DefaultValue(value="512")
    @QueryParam(value="limit")
    private final int limit;

    public MandelService(@PathParam(value="lx") double lx, @PathParam(value="ly") double ly, @PathParam(value="ux") double ux, @PathParam(value="uy") double uy, @DefaultValue(value="512") @QueryParam(value="imageSize") int imageSize, @DefaultValue(value="512") @QueryParam(value="limit") int limit, @DefaultValue(value="8") @QueryParam(value="workers") int workers) {
        this.limit = limit;
        this.workers = workers;
        this.lower = new Complex(lx, ly);
        this.upper = new Complex(ux, uy);
        this.dx = this.upper().re() - this.lower().re();
        this.dy = this.upper().im() - this.lower().im();
        this.width = this.dx() >= this.dy() ? imageSize : (int)(this.dx() / this.dy() * (double)imageSize);
        this.height = this.dy() >= this.dx() ? imageSize : (int)(this.dy() / this.dx() * (double)imageSize);
    }

    /*
     * WARNING - void declaration
     */
    @Produces(value={"image/png"})
    @GET
    public BufferedImage getMandelbrot() {
        void var1_1;
        BufferedImage image = new BufferedImage(this.width(), this.height(), 1);
        new ParallelMandelRenderer(this.workers, this.lower(), this.upper(), this.limit, image.getRaster()).render();
        return var1_1;
    }

    public int height() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    public double dy() {
        return this.dy;
    }

    public double dx() {
        return this.dx;
    }

    public Complex upper() {
        return this.upper;
    }

    public Complex lower() {
        return this.lower;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

