/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.jacksonjsonprovider;

import com.sun.jersey.samples.jacksonjsonprovider.CombinedAnnotationBean;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

@Provider
public class MyObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    final ObjectMapper defaultObjectMapper = MyObjectMapperProvider.createDefaultMapper();
    final ObjectMapper combinedObjectMapper = MyObjectMapperProvider.createCombinedObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        if (type == CombinedAnnotationBean.class) {
            return this.combinedObjectMapper;
        }
        return this.defaultObjectMapper;
    }

    private static ObjectMapper createCombinedObjectMapper() {
        AnnotationIntrospector.Pair combinedIntrospector = MyObjectMapperProvider.createJaxbJacksonAnnotationIntrospector();
        ObjectMapper result = new ObjectMapper();
        result.configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, true);
        result.setDeserializationConfig(result.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)combinedIntrospector));
        result.setSerializationConfig(result.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)combinedIntrospector));
        return result;
    }

    private static ObjectMapper createDefaultMapper() {
        ObjectMapper result = new ObjectMapper();
        result.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        return result;
    }

    private static AnnotationIntrospector.Pair createJaxbJacksonAnnotationIntrospector() {
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        return new AnnotationIntrospector.Pair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
    }
}

