/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.https_grizzly;

import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.samples.https_grizzly.auth.SecurityFilter;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;

public class Server {
    private static final Object serverGuard = new Object();
    private static HttpServer webServer;
    public static final URI BASE_URI;
    public static final String CONTENT = "JERSEY HTTPS EXAMPLE\n";

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"https://localhost/").port(Server.getPort(8463)).build(new Object[0]);
    }

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.test.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void startServer() {
        WebappContext context = new WebappContext("context");
        ServletRegistration registration = context.addServlet("ServletContainer", ServletContainer.class);
        registration.setInitParameter("com.sun.jersey.config.property.packages", "com.sun.jersey.samples.https_grizzly.resource;com.sun.jersey.samples.https_grizzly.auth");
        registration.setInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", SecurityFilter.class.getName());
        SSLContextConfigurator sslContext = new SSLContextConfigurator();
        sslContext.setKeyStoreFile("./keystore_server");
        sslContext.setKeyStorePass("asdfgh");
        sslContext.setTrustStoreFile("./truststore_server");
        sslContext.setTrustStorePass("asdfgh");
        try {
            Object object = serverGuard;
            synchronized (object) {
                if (webServer != null) {
                    throw new IllegalStateException("Another instance of the SSL-secured HTTP test server has been already started.");
                }
                webServer = GrizzlyServerFactory.createHttpServer((URI)Server.getBaseURI(), null, (boolean)true, (SSLEngineConfigurator)new SSLEngineConfigurator(sslContext).setClientMode(false).setNeedClientAuth(true));
                System.out.println("Jersey app started. Try out " + BASE_URI + "\nHit CTRL + C to stop it...");
                context.deploy(webServer);
                webServer.start();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void stopServer() {
        Object object = serverGuard;
        synchronized (object) {
            if (webServer == null) {
                throw new IllegalStateException("Test run sync issue: There is no SSL-secured HTTP test server to stop.");
            }
            webServer.stop();
            webServer = null;
        }
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        Server.startServer();
        System.in.read();
    }

    static {
        BASE_URI = Server.getBaseURI();
    }
}

