/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.generatewadl.util;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.samples.generatewadl.util.MyNamedValueType;
import com.sun.jersey.server.wadl.ApplicationDescription;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.server.wadl.generators.resourcedoc.ResourceDocAccessor;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.MethodDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResourceDocType;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.Representation;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ExampleWadlGenerator
implements WadlGenerator {
    private static final Logger LOG = Logger.getLogger(ExampleWadlGenerator.class.getName());
    private WadlGenerator _delegate;
    private File _resourceDocFile;
    private ResourceDocAccessor _resourceDoc;

    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    public String getRequiredJaxbContextPath() {
        return this._delegate.getRequiredJaxbContextPath();
    }

    public void setResourceDocFile(File resourceDocFile) {
        this._resourceDocFile = resourceDocFile;
    }

    public void init() throws Exception {
        this._delegate.init();
        ResourceDocType resourceDoc = this.loadFile(this._resourceDocFile, ResourceDocType.class, ResourceDocType.class, MyNamedValueType.class);
        this._resourceDoc = new ResourceDocAccessor(resourceDoc);
    }

    private <T> T loadFile(File fileToLoad, Class<T> targetClass, Class<?> ... classesToBeBound) {
        if (fileToLoad == null) {
            throw new IllegalArgumentException("The resource-doc file to load is not set!");
        }
        try {
            JAXBContext c = JAXBContext.newInstance((Class[])classesToBeBound);
            Unmarshaller m = c.createUnmarshaller();
            return targetClass.cast(m.unmarshal(fileToLoad));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not unmarshal file " + fileToLoad, e);
            throw new RuntimeException("Could not unmarshal file " + fileToLoad, e);
        }
    }

    public Application createApplication() {
        return this._delegate.createApplication();
    }

    public Method createMethod(AbstractResource r, AbstractResourceMethod m) {
        Method result = this._delegate.createMethod(r, m);
        MethodDocType methodDoc = this._resourceDoc.getMethodDoc(r.getResourceClass(), m.getMethod());
        if (methodDoc != null && methodDoc.getAny() != null && !methodDoc.getAny().isEmpty()) {
            for (Object any : methodDoc.getAny()) {
                MyNamedValueType namedValue;
                System.out.println("test: " + (any instanceof MyNamedValueType) + " any: " + any);
                if (!(any instanceof MyNamedValueType) || !"exampletag".equals((namedValue = (MyNamedValueType)any).getName())) continue;
                Doc doc = new Doc();
                doc.getContent().add(namedValue.getValue());
                result.getDoc().add(doc);
            }
        }
        return result;
    }

    public Request createRequest(AbstractResource arg0, AbstractResourceMethod arg1) {
        return this._delegate.createRequest(arg0, arg1);
    }

    public Param createParam(AbstractResource arg0, AbstractMethod arg1, Parameter arg2) {
        return this._delegate.createParam(arg0, arg1, arg2);
    }

    public Representation createRequestRepresentation(AbstractResource arg0, AbstractResourceMethod arg1, MediaType arg2) {
        return this._delegate.createRequestRepresentation(arg0, arg1, arg2);
    }

    public Resource createResource(AbstractResource arg0, String arg1) {
        return this._delegate.createResource(arg0, arg1);
    }

    public Resources createResources() {
        return this._delegate.createResources();
    }

    public List<Response> createResponses(AbstractResource arg0, AbstractResourceMethod arg1) {
        return this._delegate.createResponses(arg0, arg1);
    }

    public WadlGenerator.ExternalGrammarDefinition createExternalGrammar() {
        return this._delegate.createExternalGrammar();
    }

    public void attachTypes(ApplicationDescription egd) {
        this._delegate.attachTypes(egd);
    }
}

