/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.generatewadl.resources;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.samples.generatewadl.model.Item;
import com.sun.jersey.samples.generatewadl.resources.ItemResource;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Singleton
@Path(value="items")
public class ItemsResource {
    @Context
    UriInfo _uriInfo;
    private final AtomicInteger _sequence = new AtomicInteger();
    private final Map<Integer, Item> _repository = new HashMap<Integer, Item>();

    @Path(value="{id}")
    public ItemResource getItem(@PathParam(value="id") Integer id) {
        Item item = this._repository.get(id);
        if (item == null) {
            throw new NotFoundException("Item with id " + id + " does not exist!");
        }
        return new ItemResource(item);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response createItem(Item item) {
        Integer id = this._sequence.incrementAndGet();
        this._repository.put(id, item);
        return Response.created((URI)this._uriInfo.getAbsolutePathBuilder().clone().path(new String[]{id.toString()}).build()).build();
    }
}

