/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server;

import com.sun.jersey.api.container.filter.RolesAllowedResourceFilterFactory;
import com.sun.jersey.api.container.grizzly2.GrizzlyWebContainerFactory;
import com.sun.jersey.samples.contacts.server.auth.SecurityFilter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;

public class Server {
    public static final URI BASE_URI = Server.getBaseURI();

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.test.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(Server.getPort(9998)).build(new Object[0]);
    }

    public static HttpServer startServer() throws IOException {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("com.sun.jersey.config.property.packages", "com.sun.jersey.samples.contacts.server;com.sun.jersey.samples.contacts.server.auth");
        initParams.put("com.sun.jersey.spi.container.ContainerRequestFilters", SecurityFilter.class.getName());
        initParams.put("com.sun.jersey.spi.container.ResourceFilters", RolesAllowedResourceFilterFactory.class.getName());
        return GrizzlyWebContainerFactory.create((URI)BASE_URI, initParams);
    }

    public static void main(String[] args) throws IOException {
        HttpServer httpServer = Server.startServer();
        System.out.println(String.format("Jersey app started with WADL at %sapplication.wadl", BASE_URI));
        System.out.println("Hit return to stop...");
        System.in.read();
        httpServer.stop();
    }
}

