/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server;

import com.sun.jersey.samples.contacts.models.Contact;
import com.sun.jersey.samples.contacts.server.BaseResource;
import com.sun.jersey.samples.contacts.server.ContactResource;
import com.sun.jersey.samples.contacts.server.Database;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;

@Path(value="contacts/{username}")
public class ContactsResource
extends BaseResource {
    private String username = null;

    public ContactsResource(@Context UriInfo uriInfo, @PathParam(value="username") String username) {
        this.uriInfo = uriInfo;
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @GET
    @Produces(value={"application/atom+xml", "application/atom+xml;type=feed", "application/atom+json", "application/atom+json;type=feed", "application/json", "application/xml", "text/xml"})
    public Response get() {
        Feed feed = abdera.newFeed();
        feed.setId("contacts");
        feed.setTitle("Contacts System Contacts for user '" + this.username + "'");
        feed.addLink(this.uriInfo.getRequestUriBuilder().build(new Object[0]).toString(), "self");
        Map<String, List<Contact>> map = Database.contacts;
        synchronized (map) {
            feed.setUpdated(Database.contactsUpdated.get(this.username));
            List<Contact> contacts = Database.contacts.get(this.username);
            if (contacts == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("No contacts for user '" + this.username + "'")).build();
            }
            for (Contact contact : contacts) {
                Entry entry = contact.asEntry();
                String uri = this.uriInfo.getRequestUriBuilder().path(contact.getId()).build(new Object[0]).toString();
                entry.addLink(uri, "self");
                entry.addLink(uri, "edit");
                feed.addEntry(entry);
            }
        }
        return Response.ok((Object)feed).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @POST
    @Consumes(value={"application/atom+xml", "application/atom+xml;type=entry", "application/xml", "text/xml"})
    public Response post(Entry entry) {
        Contact contact = Contact.fromEntry((Entry)entry);
        StringBuilder errors = new StringBuilder();
        if (contact.getContent() == null) {
            errors.append("Missing 'content' property\r\n");
        }
        if (contact.getId() == null || contact.getId().length() < 1) {
            contact.setId(UUID.randomUUID().toString());
        }
        if (contact.getName() == null || contact.getName().length() < 1) {
            errors.append("Missing 'name' property\r\n");
        }
        contact.setUpdated(new Date());
        if (errors.length() > 0) {
            return Response.status((int)400).type("text/plain").entity((Object)errors.toString()).build();
        }
        Map<String, List<Contact>> map = Database.contacts;
        synchronized (map) {
            List<Contact> contacts = Database.contacts.get(this.username);
            if (contacts == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("No contacts for user '" + this.username + "'\r\n")).build();
            }
            for (Contact existing : contacts) {
                if (!existing.getId().equals(contact.getId())) continue;
                return Response.status((int)409).type("text/plain").entity((Object)"Contact with this ID already exists\r\n").build();
            }
            contacts.add(contact);
            return Response.created((URI)this.uriInfo.getRequestUriBuilder().path(contact.getId()).build(new Object[0])).build();
        }
    }

    @Path(value="{id}")
    public ContactResource user(@PathParam(value="id") String id) {
        return new ContactResource(this.uriInfo, this.username, id);
    }
}

