/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server.auth;

import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.samples.contacts.models.User;
import com.sun.jersey.samples.contacts.server.Database;
import com.sun.jersey.samples.contacts.server.auth.AuthenticationException;
import com.sun.jersey.samples.contacts.server.auth.Base64;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.security.Principal;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

public class SecurityFilter
implements ContainerRequestFilter {
    private static final String REALM = "Contacts Service";
    @Context
    UriInfo uriInfo;

    public ContainerRequest filter(ContainerRequest request) {
        User user = this.authenticate(request);
        request.setSecurityContext((SecurityContext)new Authorizer(user));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User authenticate(ContainerRequest request) {
        String authentication = request.getHeaderValue("Authorization");
        if (authentication == null) {
            throw new MappableContainerException((Throwable)new AuthenticationException("Authentication credentials are required\r\n", REALM));
        }
        if (!authentication.startsWith("Basic ")) {
            throw new MappableContainerException((Throwable)new AuthenticationException("Only HTTP Basic authentication is supported\r\n", REALM));
        }
        String[] values = new String(Base64.base64Decode(authentication = authentication.substring("Basic ".length()))).split(":");
        if (values.length < 2) {
            throw new MappableContainerException((Throwable)new AuthenticationException("Invalid syntax for username and password\r\n", REALM));
        }
        String username = values[0];
        String password = values[1];
        if (username == null || password == null) {
            throw new MappableContainerException((Throwable)new AuthenticationException("Missing username or password\r\n", REALM));
        }
        User user = null;
        Map<String, User> map = Database.users;
        synchronized (map) {
            user = Database.users.get(username);
            if (user == null) {
                throw new MappableContainerException((Throwable)new AuthenticationException("Invalid username or password\r\n", REALM));
            }
            if (!password.trim().equals(user.getPassword().trim())) {
                throw new MappableContainerException((Throwable)new AuthenticationException("Invalid username or password\r\n", REALM));
            }
        }
        return user;
    }

    public class Authorizer
    implements SecurityContext {
        private Principal principal;

        public Authorizer(final User user) {
            this.principal = new Principal(){

                @Override
                public String getName() {
                    return user.getUsername();
                }
            };
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            if ("admin".equals(role)) {
                return "admin".equals(this.principal.getName());
            }
            if ("user".equals(role)) {
                if ("admin".equals(this.principal.getName())) {
                    return true;
                }
                String pathParam = (String)SecurityFilter.this.uriInfo.getPathParameters().getFirst((Object)"username");
                if (pathParam != null && this.principal.getName().endsWith(pathParam)) {
                    return true;
                }
            }
            return false;
        }

        public boolean isSecure() {
            return "https".equals(SecurityFilter.this.uriInfo.getRequestUri().getScheme());
        }

        public String getAuthenticationScheme() {
            return "BASIC";
        }
    }
}

