/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server;

import com.sun.jersey.atom.abdera.ContentHelper;
import com.sun.jersey.samples.contacts.models.Contact;
import com.sun.jersey.samples.contacts.models.User;
import com.sun.jersey.samples.contacts.server.BaseResource;
import com.sun.jersey.samples.contacts.server.Database;
import com.sun.jersey.samples.contacts.server.UserResource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;

@Path(value="users")
public class UsersResource
extends BaseResource {
    public UsersResource(@Context UriInfo uriInfo, @Context ContentHelper contentHelper) {
        this.uriInfo = uriInfo;
        this.contentHelper = contentHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"admin"})
    @GET
    @Produces(value={"application/atom+xml", "application/atom+xml;type=feed", "application/atom+json", "application/atom+json;type=feed", "application/json", "application/xml", "text/xml"})
    public Response get() {
        Feed feed = abdera.newFeed();
        feed.setId("users");
        feed.setTitle("Contacts System Users");
        feed.addLink(this.uriInfo.getRequestUriBuilder().build(new Object[0]).toString(), "self");
        Map<String, User> map = Database.users;
        synchronized (map) {
            feed.setUpdated(Database.usersUpdated);
            for (User user : Database.users.values()) {
                Entry entry = abdera.newEntry();
                entry.setId(user.getId());
                entry.setTitle(user.getUsername());
                entry.setUpdated(user.getUpdated());
                String uri = this.uriInfo.getRequestUriBuilder().path(user.getUsername()).build(new Object[0]).toString();
                entry.addLink(uri, "self");
                entry.addLink(uri, "edit");
                this.contentHelper.setContentEntity(entry, MediaType.APPLICATION_XML_TYPE, (Object)user);
                feed.addEntry(entry);
            }
        }
        return Response.ok((Object)feed).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"admin"})
    @POST
    @Consumes(value={"application/atom+xml", "application/atom+xml;type=entry", "application/xml", "text/xml"})
    public Response post(Entry entry) {
        if (entry == null) {
            return Response.status((int)400).type("text/plain").entity((Object)"Missing entry in request body\r\n").build();
        }
        User user = null;
        try {
            user = (User)this.contentHelper.getContentEntity(entry, MediaType.APPLICATION_XML_TYPE, User.class);
        }
        catch (IllegalArgumentException e) {
            return Response.status((int)400).type("text/plain").entity((Object)"Missing content element in the supplied entry\r\n").build();
        }
        StringBuilder errors = new StringBuilder();
        if (user.getId() == null || user.getId().length() < 1) {
            user.setId(UUID.randomUUID().toString());
        }
        if (user.getPassword() == null || user.getPassword().length() < 1) {
            errors.append("Missing 'password' property\r\n");
        }
        user.setUpdated(new Date());
        if (user.getUsername() == null || user.getUsername().length() < 1) {
            errors.append("Missing 'username' property\r\n");
        }
        if (errors.length() > 0) {
            return Response.status((int)400).type("text/plain").entity((Object)errors.toString()).build();
        }
        Map<String, User> map = Database.users;
        synchronized (map) {
            if (Database.users.get(user.getUsername()) != null) {
                return Response.status((int)409).type("text/plain").entity((Object)("User '" + user.getUsername() + "' already exists\r\n")).build();
            }
            Database.users.put(user.getUsername(), user);
            Database.usersUpdated = new Date();
            Map<String, List<Contact>> map2 = Database.contacts;
            synchronized (map2) {
                Database.contacts.put(user.getUsername(), new ArrayList());
                Database.contactsUpdated.put(user.getUsername(), Database.usersUpdated);
            }
            return Response.created((URI)this.uriInfo.getRequestUriBuilder().path(user.getUsername()).build(new Object[0])).build();
        }
    }

    @Path(value="{username}")
    public UserResource user(@PathParam(value="username") String username) {
        return new UserResource(this.uriInfo, this.contentHelper, username);
    }
}

