/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server;

import com.sun.grizzly.http.SelectorThread;
import com.sun.jersey.api.container.filter.RolesAllowedResourceFilterFactory;
import com.sun.jersey.api.container.grizzly.GrizzlyWebContainerFactory;
import com.sun.jersey.samples.contacts.server.auth.SecurityFilter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;

public class Server {
    public static final URI BASE_URI = Server.getBaseURI();

    private static int getPort(int defaultPort) {
        String port = System.getenv("JERSEY_HTTP_PORT");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(Server.getPort(9998)).build(new Object[0]);
    }

    public static SelectorThread startServer() throws IOException {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("com.sun.jersey.config.property.packages", "com.sun.jersey.samples.contacts.server;com.sun.jersey.samples.contacts.server.auth");
        initParams.put("com.sun.jersey.spi.container.ContainerRequestFilters", SecurityFilter.class.getName());
        initParams.put("com.sun.jersey.spi.container.ResourceFilters", RolesAllowedResourceFilterFactory.class.getName());
        SelectorThread threadSelector = GrizzlyWebContainerFactory.create((URI)BASE_URI, initParams);
        return threadSelector;
    }

    public static void main(String[] args) throws IOException {
        SelectorThread threadSelector = Server.startServer();
        System.out.println(String.format("Jersey app started with WADL at %sapplication.wadl", BASE_URI));
        System.out.println("Hit return to stop...");
        System.in.read();
        threadSelector.stopEndpoint();
    }
}

