/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server;

import com.sun.jersey.samples.contacts.models.Contact;
import com.sun.jersey.samples.contacts.server.BaseResource;
import com.sun.jersey.samples.contacts.server.Database;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.model.Entry;

public class ContactResource
extends BaseResource {
    private String id = null;
    private String username = null;

    public ContactResource(UriInfo uriInfo, String username, String id) {
        this.uriInfo = uriInfo;
        this.username = username;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @DELETE
    public Response delete() {
        Map<String, List<Contact>> map = Database.contacts;
        synchronized (map) {
            List<Contact> contacts = Database.contacts.get(this.username);
            if (contacts == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("No contacts for user '" + this.username + "'")).build();
            }
            for (int i = 0; i < contacts.size(); ++i) {
                if (!this.id.equals(contacts.get(i).getId())) continue;
                contacts.remove(i);
                Database.contactsUpdated.put(this.username, new Date());
                return Response.ok().build();
            }
        }
        return Response.status((int)404).type("text/plain").entity((Object)("No contact for user '" + this.username + "'")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @GET
    @Produces(value={"application/atom+xml", "application/atom+xml;type=entry", "application/atom+json", "application/atom+json;type=entry", "application/json", "application/xml", "text/xml"})
    public Response get() {
        Map<String, List<Contact>> map = Database.contacts;
        synchronized (map) {
            List<Contact> contacts = Database.contacts.get(this.username);
            if (contacts == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("No contacts for user '" + this.username + "'")).build();
            }
            for (int i = 0; i < contacts.size(); ++i) {
                if (!this.id.equals(contacts.get(i).getId())) continue;
                Entry entry = contacts.get(i).asEntry();
                String uri = this.uriInfo.getRequestUriBuilder().build(new Object[0]).toString();
                entry.addLink(uri, "self");
                entry.addLink(uri, "edit");
                return Response.ok((Object)entry).build();
            }
        }
        return Response.status((int)404).type("text/plain").entity((Object)("No contact for user '" + this.username + "'")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @PUT
    @Consumes(value={"application/atom+xml", "application/atom+xml;type=entry", "application/xml", "text/xml"})
    public Response put(Entry entry) {
        Contact contact = Contact.fromEntry((Entry)entry);
        StringBuilder errors = new StringBuilder();
        if (contact.getContent() == null) {
            errors.append("Missing 'content' property\r\n");
        }
        if (contact.getName() == null || contact.getName().length() < 1) {
            errors.append("Missing 'name' property\r\n");
        }
        contact.setUpdated(new Date());
        if (errors.length() > 0) {
            return Response.status((int)400).type("text/plain").entity((Object)errors.toString()).build();
        }
        Map<String, List<Contact>> map = Database.contacts;
        synchronized (map) {
            List<Contact> contacts = Database.contacts.get(this.username);
            if (contacts == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("No contacts for user '" + this.username + "'")).build();
            }
            Contact original = null;
            for (int i = 0; i < contacts.size(); ++i) {
                if (!this.id.equals(contacts.get(i).getId())) continue;
                original = contacts.get(i);
            }
            if (original == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("No contact for user '" + this.username + "'\r\n")).build();
            }
            original.updateFrom(contact);
            return Response.ok().build();
        }
    }
}

