/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server;

import com.sun.jersey.samples.contacts.models.User;
import com.sun.jersey.samples.contacts.server.BaseResource;
import com.sun.jersey.samples.contacts.server.Database;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;

@Path(value="service")
public class ServiceResource
extends BaseResource {
    public ServiceResource(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/atomsvc+xml", "application/xml", "text/xml", "application/atomsvc+json", "application/json"})
    public Response get() {
        User authenticatedUser = this.getAuthenticatedUser();
        Service service = abdera.newService();
        Workspace contactsWorkspace = service.addWorkspace("Contact List Feeds");
        Map<String, User> map = Database.users;
        synchronized (map) {
            if ("admin".equals(authenticatedUser.getUsername())) {
                for (User user : Database.users.values()) {
                    this.addContactList(contactsWorkspace, user);
                }
            } else {
                this.addContactList(contactsWorkspace, authenticatedUser);
            }
        }
        if ("admin".equals(authenticatedUser.getUsername())) {
            Workspace adminWorkspace = service.addWorkspace("Administrative Feeds");
            Collection usersCollection = adminWorkspace.addCollection("User List", this.uriInfo.getBaseUri() + "users");
        }
        return Response.ok((Object)service).build();
    }

    private void addContactList(Workspace workspace, User user) {
        String uri = this.uriInfo.getBaseUriBuilder().path("contacts").path(user.getUsername()).build(new Object[0]).toString();
        workspace.addCollection("Username '" + user.getUsername() + "' Contact List", uri);
    }
}

