/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.contacts.server;

import com.sun.jersey.atom.abdera.ContentHelper;
import com.sun.jersey.samples.contacts.models.Contact;
import com.sun.jersey.samples.contacts.models.User;
import com.sun.jersey.samples.contacts.server.BaseResource;
import com.sun.jersey.samples.contacts.server.Database;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.model.Entry;

public class UserResource
extends BaseResource {
    private String username = null;

    public UserResource(UriInfo uriInfo, ContentHelper contentHelper, String username) {
        this.uriInfo = uriInfo;
        this.contentHelper = contentHelper;
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"admin"})
    @DELETE
    public Response delete() {
        Map<String, User> map = Database.users;
        synchronized (map) {
            User user = Database.users.remove(this.username);
            if (user == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("User '" + this.username + "' not found\r\n")).build();
            }
            Database.usersUpdated = new Date();
            Map<String, List<Contact>> map2 = Database.contacts;
            synchronized (map2) {
                Database.contacts.remove(this.username);
            }
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"admin"})
    @GET
    @Produces(value={"application/atom+xml", "application/atom+xml;type=entry", "application/atom+json", "application/atom+json;type=entry", "application/json", "application/xml", "text/xml"})
    public Response get() {
        Entry entry = null;
        Map<String, User> map = Database.users;
        synchronized (map) {
            User user = Database.users.get(this.username);
            if (user == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("User '" + this.username + "' not found\r\n")).build();
            }
            entry = abdera.newEntry();
            entry.setId(user.getId());
            entry.setTitle(user.getUsername());
            entry.setUpdated(user.getUpdated());
            String uri = this.uriInfo.getRequestUriBuilder().build(new Object[0]).toString();
            entry.addLink(uri, "self");
            entry.addLink(uri, "edit");
            this.contentHelper.setContentEntity(entry, MediaType.APPLICATION_XML_TYPE, (Object)user);
        }
        return Response.ok((Object)entry).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"admin"})
    @PUT
    @Consumes(value={"application/atom+xml", "application/atom+xml;type=entry", "application/xml", "text/xml"})
    public Response put(Entry entry) {
        User user = (User)this.contentHelper.getContentEntity(entry, MediaType.APPLICATION_XML_TYPE, User.class);
        StringBuilder errors = new StringBuilder();
        if (user.getPassword() == null || user.getPassword().length() < 1) {
            errors.append("Missing 'password' property\r\n");
        }
        if (errors.length() > 0) {
            return Response.status((int)400).type("text/plain").entity((Object)errors.toString()).build();
        }
        Map<String, User> map = Database.users;
        synchronized (map) {
            User original = Database.users.get(this.username);
            if (original == null) {
                return Response.status((int)404).type("text/plain").entity((Object)("User '" + this.username + "' does not exist\r\n")).build();
            }
            original.setPassword(user.getPassword());
            original.setUpdated(new Date());
            Database.usersUpdated = new Date();
            return Response.ok().build();
        }
    }
}

