/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.grizzly2.web;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.ServletHandler;

public class GrizzlyWebTestContainerFactory
implements TestContainerFactory {
    public Class<WebAppDescriptor> supports() {
        return WebAppDescriptor.class;
    }

    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof WebAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of WebAppDescriptor");
        }
        return new GrizzlyWebTestContainer(baseUri, (WebAppDescriptor)ad);
    }

    private static class GrizzlyWebTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(GrizzlyWebTestContainer.class.getName());
        final URI baseUri;
        final String contextPath;
        final String servletPath;
        final Class servletClass;
        List<WebAppDescriptor.FilterDescriptor> filters = null;
        final List<Class<? extends EventListener>> eventListeners;
        final Map<String, String> initParams;
        final Map<String, String> contextParams;
        private HttpServer httpServer;

        private GrizzlyWebTestContainer(URI baseUri, WebAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(ad.getContextPath()).path(ad.getServletPath()).build(new Object[0]);
            LOGGER.info("Creating Grizzly2 Web Container configured at the base URI " + this.baseUri);
            this.contextPath = ad.getContextPath();
            this.servletPath = ad.getServletPath();
            this.servletClass = ad.getServletClass();
            this.filters = ad.getFilters();
            this.initParams = ad.getInitParams();
            this.contextParams = ad.getContextParams();
            this.eventListeners = ad.getListeners();
            this.instantiateGrizzlyWebServer();
        }

        public Client getClient() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            LOGGER.info("Starting the Grizzly2 Web Container...");
            try {
                this.httpServer.start();
            }
            catch (IOException ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }

        public void stop() {
            LOGGER.info("Stopping the Grizzly2 Web Container...");
            this.httpServer.stop();
        }

        private void instantiateGrizzlyWebServer() {
            ServletHandler handler = new ServletHandler();
            if (this.servletClass != null) {
                Servlet servletInstance;
                try {
                    servletInstance = (Servlet)this.servletClass.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                handler.setServletInstance(servletInstance);
            }
            for (Class<? extends EventListener> eventListener : this.eventListeners) {
                handler.addServletListener(eventListener.getName());
            }
            for (String contextParamName : this.contextParams.keySet()) {
                handler.addContextParameter(contextParamName, this.contextParams.get(contextParamName));
            }
            for (String initParamName : this.initParams.keySet()) {
                handler.addInitParameter(initParamName, this.initParams.get(initParamName));
            }
            if (this.contextPath != null && this.contextPath.length() > 0) {
                if (!this.contextPath.startsWith("/")) {
                    handler.setContextPath("/" + this.contextPath);
                } else {
                    handler.setContextPath(this.contextPath);
                }
            }
            if (this.servletPath != null && this.servletPath.length() > 0) {
                if (!this.servletPath.startsWith("/")) {
                    handler.setServletPath("/" + this.servletPath);
                } else {
                    handler.setServletPath(this.servletPath);
                }
            }
            if (this.filters != null) {
                try {
                    for (WebAppDescriptor.FilterDescriptor d : this.filters) {
                        handler.addFilter((Filter)d.getFilterClass().newInstance(), d.getFilterName(), d.getInitParams());
                    }
                }
                catch (InstantiationException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
            }
            try {
                this.httpServer = GrizzlyServerFactory.createHttpServer((URI)this.baseUri, (HttpHandler)handler);
            }
            catch (IOException ioe) {
                throw new TestContainerException((Throwable)ioe);
            }
        }
    }
}

