/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.test.framework.AppDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppDescriptor
extends AppDescriptor {
    private final Map<String, String> initParams;
    private final Map<String, String> contextParams;
    private final Class<? extends HttpServlet> servletClass;
    private final Class<? extends Filter> filterClass;
    private final Class<? extends ServletContextListener> contextListenerClass;
    private final String contextPath;
    private final String servletPath;

    private WebAppDescriptor(Builder b) {
        super(b);
        this.initParams = b.initParams == null ? new HashMap() : b.initParams;
        this.contextParams = b.contextParams == null ? new HashMap() : b.contextParams;
        this.servletClass = b.servletClass;
        this.filterClass = b.filterClass;
        this.contextPath = b.contextPath;
        this.servletPath = b.servletPath;
        this.contextListenerClass = b.contextListenerClass;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public Class<? extends HttpServlet> getServletClass() {
        return this.servletClass;
    }

    public Class<? extends Filter> getFilterClass() {
        return this.filterClass;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Class<? extends ServletContextListener> getContextListenerClass() {
        return this.contextListenerClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AppDescriptor.AppDescriptorBuilder<Builder, WebAppDescriptor> {
        protected Map<String, String> initParams;
        protected Map<String, String> contextParams;
        protected Class<? extends HttpServlet> servletClass = ServletContainer.class;
        protected Class<? extends Filter> filterClass;
        protected Class<? extends ServletContextListener> contextListenerClass;
        protected String contextPath = "";
        protected String servletPath = "";

        public Builder() {
        }

        public Builder(Map<String, String> initParams) throws IllegalArgumentException {
            if (initParams == null) {
                throw new IllegalArgumentException("The initialization parameters must not be null");
            }
            this.initParams = new HashMap<String, String>();
            this.initParams.putAll(initParams);
        }

        public Builder(String name, String value) {
            this.initParam(name, value);
        }

        public Builder(String ... packages) throws IllegalArgumentException {
            if (packages == null) {
                throw new IllegalArgumentException("The packages must not be null");
            }
            StringBuilder sb = new StringBuilder();
            for (String packageName : packages) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append(packageName);
            }
            this.initParam("com.sun.jersey.config.property.packages", sb.toString());
        }

        public Builder initParam(String name, String value) {
            if (this.initParams == null) {
                this.initParams = new HashMap<String, String>();
            }
            this.initParams.put(name, value);
            return this;
        }

        public Builder contextParam(String name, String value) {
            if (this.contextParams == null) {
                this.contextParams = new HashMap<String, String>();
            }
            this.contextParams.put(name, value);
            return this;
        }

        public Builder servletClass(Class<? extends HttpServlet> servletClass) throws IllegalArgumentException {
            if (servletClass == null) {
                throw new IllegalArgumentException("The servlet class must not be null");
            }
            this.servletClass = servletClass;
            this.filterClass = null;
            return this;
        }

        public Builder filterClass(Class<? extends Filter> filterClass) throws IllegalArgumentException {
            if (filterClass == null) {
                throw new IllegalArgumentException("The filter class must not be null");
            }
            this.filterClass = filterClass;
            this.servletClass = null;
            return this;
        }

        public Builder contextPath(String contextPath) {
            if (contextPath == null) {
                throw new IllegalArgumentException("The context path must not be null");
            }
            this.contextPath = contextPath;
            return this;
        }

        public Builder servletPath(String servletPath) {
            if (servletPath == null) {
                throw new IllegalArgumentException("The servlet path must not be null");
            }
            this.servletPath = servletPath;
            return this;
        }

        public Builder contextListenerClass(Class<? extends ServletContextListener> contextListenerClass) {
            if (contextListenerClass == null) {
                throw new IllegalArgumentException("The servlet context listener class must not be null");
            }
            this.contextListenerClass = contextListenerClass;
            return this;
        }

        @Override
        public WebAppDescriptor build() {
            WebAppDescriptor wd = new WebAppDescriptor(this);
            this.reset();
            return wd;
        }

        @Override
        protected void reset() {
            super.reset();
            this.initParams = null;
            this.contextParams = null;
            this.servletClass = ServletContainer.class;
            this.filterClass = null;
            this.contextListenerClass = null;
            this.contextPath = "";
            this.servletPath = "";
        }
    }
}

